package cn.quantgroup.dbc.spark.june;

import cn.quantgroup.dbc.bean.ComserviceIPhonePaymentInfo;
import cn.quantgroup.dbc.bean.UserInfo;
import cn.quantgroup.dbc.utils.DateUtil;
import cn.quantgroup.dbc.utils.JdbcExecuters;
import cn.quantgroup.dbc.utils.NumberUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-04-26 14:03
 */
public class PhonePaymentInfoApp {

    //uuid phone paytime paymethod payamount paychannel payspare timestamp


    public static void main(String[] args) {

        System.out.println("======充值记录任务开始执行======");
        System.out.println("本次导入" +  args[0]);

        SparkSession ss = SparkSession.builder().appName("PhonePaymentInfoApp").getOrCreate();

        Dataset<UserInfo> userInfoDataset = ss.read().parquet("hdfs:///app/user/data/user_data/feng.ren/user_parquet").map(row -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setPhone(row.getAs("phone"));
            userInfo.setUuid(row.getAs("uuid"));
            return userInfo;
        }, Encoders.bean(UserInfo.class));

        System.out.println("======用户加载完成======" + userInfoDataset.head().getPhone());
        System.out.println("======用户加载完成======" + userInfoDataset.count());

        Dataset<String> dataset = ss.read().textFile("hdfs:///app/user/data/deeplearning/export_data/phone_payment_info/" + args[0]);


        Dataset<ComserviceIPhonePaymentInfo> phonePaymentInfoDataset = dataset.filter(row -> row.split("\t", -1).length > 7)
                .map(row -> {
                    String[] split = row.split("\t", -1);
                    ComserviceIPhonePaymentInfo phonePaymentInfo = new ComserviceIPhonePaymentInfo();
                    phonePaymentInfo.setPhone(StringUtils.isBlank(split[1]) ? null : split[1].replaceAll(" ", ""));
                    phonePaymentInfo.setPayamount(StringUtils.isBlank(split[2]) ? null : NumberUtil.amountToFormat(split[2], "充值金额账单金额"));
                    phonePaymentInfo.setPaytime(StringUtils.isBlank(split[3]) ? null : DateUtil.dateString2Format(split[3], "缴费充值时间"));
                    phonePaymentInfo.setPaymethod(StringUtils.isBlank(split[4]) ? null : split[4]);
                    phonePaymentInfo.setPaychannel(StringUtils.isBlank(split[5]) ? null : split[5]);
                    phonePaymentInfo.setPayspare(StringUtils.isBlank(split[6]) ? null : split[6]);
                    phonePaymentInfo.setTimestamp(StringUtils.isBlank(split[7]) ? null : DateUtil.timeStamp2Date(split[7], "充值记录入库时间"));
                    return phonePaymentInfo;
                }, Encoders.bean(ComserviceIPhonePaymentInfo.class));


        Dataset<Row> finalData = phonePaymentInfoDataset.join(userInfoDataset, "phone");

        System.out.println("======join加载总数量======" + finalData.count());

        String sql = "INSERT IGNORE INTO comservice_i_phone_payment_info (uuid,phone,payamount,paytime,paymethod,paychannel,payspare,timestamp) values (?,?,?,?,?,?,?,?)";

        finalData.foreachPartition(line -> {
            List<List<String>> paramList = new ArrayList<>(500);

            line.forEachRemaining(o -> {
                List<String> list = new ArrayList<>();
                //取前4个元素(手机号/姓名/账单月/账单金额), 主要是用到的有 手机号/账单月/账单金额
                try {
                    String uuid = StringUtils.isBlank(o.getAs("uuid")) ? null : o.getAs("uuid");
                    list.add(uuid);

                    list.add(o.getAs("phone"));
                    list.add(o.getAs("payamount"));
                    list.add(o.getAs("paytime"));
                    list.add(o.getAs("paymethod"));
                    list.add(o.getAs("paychannel"));
                    list.add(o.getAs("payspare"));
                    list.add(o.getAs("timestamp"));

                    paramList.add(list);

                    if (paramList.size() != 0 && paramList.size() % 500 == 0) {
                        JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
                        paramList.clear();
                    }

                } catch (Exception e) {
                    System.out.println("======通话账单未知异常======");
                    e.printStackTrace();
                }
            });

            JdbcExecuters.prepareBatchUpdateExecute(sql, paramList);
        });

        ss.close();
        System.out.println("======充值记录任务执行完毕======");
    }

    public static String getExecuteSql(List<String> list, String uuid) {
        String str = "INSERT IGNORE INTO comservice_i_phone_payment_info (uuid,phone,payamount,paytime,paymethod,paychannel,payspare,timestamp) values (" + (StringUtils.isBlank(uuid) ? (null + ",") : ("'" + uuid + "',")) + "%s)";
        String formatStr = "";
        for (int i = 0; i < list.size(); i++) {
            String string = list.get(i);
            if (string == null) {
                formatStr += (string + (i == list.size() - 1 ? "" : ","));
            } else {
                formatStr += ("'" + string + "'" + (i == list.size() - 1 ? "" : ","));
            }
        }
        String executeSql = String.format(str, formatStr);
//        System.out.println("===========执行sql========="+executeSql);
        return executeSql;
    }

    public static String clearPhone(String phoneNo) {
        if (StringUtils.isBlank(phoneNo)) {
            return null;
        }

        if (phoneNo.startsWith("86125832")) {
            return phoneNo.replaceFirst("86125832", "");
        } else if (phoneNo.startsWith("0086")) {
            return phoneNo.replaceFirst("0086", "");
        } else if (phoneNo.startsWith("86")) {
            return phoneNo.replaceFirst("86", "");
        }


        return phoneNo;
    }


}
