package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackListChannelExpireConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListQueryManagerService;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 0.手机号
 * 1.身份证号
 * 2.手机号+身份证号 且关系
 * 3.手机号+姓名+身份证号  且关系
 * 4.身份证或手机号命中其一
 * 5.uuid
 *
 * @Author fengjunkai
 * @Date 2019-08-13 18:28
 */
@Slf4j
@Service
public class BlackListQueryManagerServiceImpl implements IBlackListQueryManagerService {

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    private static Map<String, Integer> channelBlackListExpireConfigMap = new ConcurrentHashMap<>();

    @Override
    public GlobalResponse queryBlackList(String uuid, String name, String phoneNo, String idNo, String type) {
        log.info("查询黑名单开始, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} ", uuid, name, phoneNo, idNo, type);
        try {
            switch (type) {
                case "0":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_SQL, phoneNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "1":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_SQL, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_ID_NO_SQL, idNo), uuid, name, phoneNo, idNo, type));
                case "2":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_IDNO_SQL, phoneNo, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "3":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_THREE_ELE_SQL, phoneNo, idNo, name), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "4":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_OR_PHONENO_SQL, phoneNo, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "5":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UUID_SQL, uuid), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_UUID_SQL, uuid), uuid, name, phoneNo, idNo, type));
                default:
                    return GlobalResponse.error("无效的查询类型");
            }
        } catch (Exception e) {
            log.error("查询黑名单异常, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} ", uuid, name, phoneNo, idNo, type, e);
        }

        return GlobalResponse.error("查询黑名单异常");
    }

    public List<BlackListQueryTidbVo0> getBlackListData(String queryBlackListSql, String queryUserIdSql, String uuid, String name, String phoneNo, String idNo, String type) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<BlackListQueryTidbVo0> queryListBlackListByPhoneNos = blackListJdbcTemplate.query(queryBlackListSql, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
        List<Map<String, Object>> queryXyqbUserInfoByPhoneNo = xyqbUserJdbcTemplate.queryForList(queryUserIdSql);

        if (CollectionUtils.isNotEmpty(queryListBlackListByPhoneNos)) {
            List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(queryXyqbUserInfoByPhoneNo)) {

                Map<String, Object> userIdMap = queryXyqbUserInfoByPhoneNo.get(0);
                List<Map<String, Object>> totalOverdueDaysList = xyqbJdbcTemplate.queryForList(String.format(Constant.SQL.XYQB_QUERY_USER_TOTAL_OVERDUE_SQL, userIdMap.get(Constant.PARAM.USER_ID)));
                List<Map<String, Object>> maxOverdueDaysList = xyqbJdbcTemplate.queryForList(String.format(Constant.SQL.XYQB_QUERY_USER_MAX_OVERDUE_SQL, userIdMap.get(Constant.PARAM.USER_ID)));

                queryListBlackListByPhoneNos.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0).forEach(blackListQueryTidbVo0 -> {

                    if (CollectionUtils.isNotEmpty(totalOverdueDaysList)) {
                        Object totalOverdueDays = totalOverdueDaysList.get(0).get(Constant.PARAM.TOTAL_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setTotalOverdueDays(totalOverdueDays.toString());
                    }
                    if (CollectionUtils.isNotEmpty(maxOverdueDaysList)) {
                        Object maxOverdueDays = maxOverdueDaysList.get(0).get(Constant.PARAM.MAX_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setMaxOverdueDays(maxOverdueDays.toString());
                    }

                    blackListQueryTidbVo0s.add(blackListQueryTidbVo0);
                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));

                });

            } else {

                queryListBlackListByPhoneNos.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0).forEach(blackListQueryTidbVo0 -> {

                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0s.add(blackListQueryTidbVo0);

                });

            }

            JdbcExecuters.blackListUpdateBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_UPDATE_FIRST_OR_MAX_OVERDUE_DAYS_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_UPDATE_OVERDUE_DAYS);

        }

        log.info("查询黑名单结束, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} , 耗时: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(queryListBlackListByPhoneNos), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return queryListBlackListByPhoneNos;
    }

    @PostConstruct
    public void initChannelBlackListExpireConfig() {
        List<BlackListChannelExpireConfigVo0> queryBlackListChannelExpireConfigVo0List = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_CHANNEL_BLACK_LIST_EXPIRE_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackListChannelExpireConfigVo0.class));
        channelBlackListExpireConfigMap = queryBlackListChannelExpireConfigVo0List.stream().collect(Collectors.toMap(BlackListChannelExpireConfigVo0::getType, BlackListChannelExpireConfigVo0::getExpireTime));
    }

}
