package cn.quantgroup.qgblservice.config.xyqb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @Author fengjunkai
 * @Date 2019-08-13 17:20
 */
@Import({XyqbProperties.class})
@MapperScan(basePackages = XyqbSourceConfig.PACKAGE, sqlSessionFactoryRef = "xyqbSqlSessionFactory")
@Configuration
public class XyqbSourceConfig {

    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.xyqb";

    @Value("${xyqb.mapper-locations}")
    private String mapperLocations;
    @Value("${xyqb.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${xyqb.config-location}")
    private String configLocation;

    @Autowired
    private XyqbProperties xyqbProperties;

    @Bean(name = "xyqbDataSource")
    public DataSource xyqbUserDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(xyqbProperties.getJdbcUrl());
        config.setPassword(xyqbProperties.getPassword());
        config.setMaximumPoolSize(xyqbProperties.getMaxPoolSize());
        config.setUsername(xyqbProperties.getUsername());
        config.setMinimumIdle(xyqbProperties.getMinPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        return new HikariDataSource(config);
    }

    @Bean(name = "xyqbJdbcTemplate")
    public JdbcTemplate xyqbJdbcTemplate(@Qualifier("xyqbDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "xyqbSqlSessionFactory")
    public SqlSessionFactory xyqbSqlSessionFactory(@Qualifier("xyqbDataSource") DataSource xyqbDataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(xyqbDataSource);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(configLocation));
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        return sessionFactory.getObject();
    }

    @Bean(name = "xyqbSqlSessionTemplate")
    public SqlSessionTemplate xyqbSqlSessionTemplate(@Qualifier("xyqbSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }


}
