package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListToolsManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 黑名单表操作工具类<br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.09.19 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */

@RestController
@RequestMapping("/tools")
public class BlackListToolsManagerController {

    @Autowired
    private IBlackListToolsManagerService iBlackListToolsManagerService;
    //-----------------测试git提交代码

    /**
     * @param filePath 原文件地址
     * @param titleNames 表格的头部标题，已逗号分隔
     * @param haveTitle 非必传，默认true；是否有标题列
     * @param byColumnName 查询类别，目前可以传idcard或mobile；name暂不支持
     * @param columnDataType 非必传，默认空“明文数据”，或可传值"MD5"；Excel表格里的byColumn数据类别
     * @return
     */
    @RequestMapping("/compareByExcel")
    public GlobalResponse compareByExcel(String filePath,String titleNames, String haveTitle, String byColumnName,String columnDataType){
        return iBlackListToolsManagerService.compareByExcel(filePath,titleNames,haveTitle,byColumnName,columnDataType);
    }


    /**
     * @param privateKey 私钥
     * @param operatType 操作类型，支持all,byId,byCreatUtc
     * @param idArray operatType=byId时必传，多个以逗号分隔
     * @param gtCreatUtc operatType=byCreatUtc时必传
     * @return
     */
    @RequestMapping("/buildMd5Tools")
    public GlobalResponse buildMd5Tools(String privateKey,String operatType, String idArray, String gtCreatUtc){
        return iBlackListToolsManagerService.buildMd5Tools(privateKey,operatType,idArray,gtCreatUtc);
    }

}
