package cn.quantgroup.qgblservice.utils;

import java.io.*;
import java.util.List;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述： <br>
 * 作者： Haoyanhui <br>
 * 时间：2019.09.09 22:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public class ReadOrWriteTxt {
    /**传入txt路径读取txt文件
     * @param txtPath
     * @return 返回读取到的内容
     */
    public static String readTxt(String txtPath) {
        File file = new File(txtPath);
        if(file.isFile() && file.exists()){
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

                StringBuffer sb = new StringBuffer();
                String text = null;
                while((text = bufferedReader.readLine()) != null){
                    sb.append(text);
                }
                return sb.toString();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }


    /**使用FileOutputStream来写入txt文件
     * @param txtPath txt文件路径
     * @param content 需要写入的文本
     */
    public static void writeTxt(String txtPath,String content){
        FileOutputStream fileOutputStream = null;
        File file = new File(txtPath);
        try {
            if(file.exists()){
                //判断文件是否存在，如果不存在就新建一个txt
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(content.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeTxt(String txtPath,List<String> contentList){
        FileOutputStream fileOutputStream = null;
        File file = new File(txtPath);
        try {
            if(file.exists()){
                //判断文件是否存在，如果不存在就新建一个txt
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            for(String content:contentList){
                fileOutputStream.write(content.getBytes());
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    public static void main(String[] args) {
        //String filePath = "D:\\JavaTeam\\shmf.txt";
        String filePath = "/opt/web_app/shmf.txt";
        String queryType = "aa";
        String writeFilePath = "";
        if(filePath.lastIndexOf("/")!=-1){//linux
            writeFilePath = filePath.substring(0,filePath.lastIndexOf("/"))+"/"+queryType+".txt";
        }else{//windows
            writeFilePath = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\"+queryType+".txt";
        }
        System.out.println(filePath);
        System.out.println(writeFilePath);
    }
}
