package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackListChannelExpireConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListToolsManagerService;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.ReadExcelUtils;
import cn.quantgroup.qgblservice.utils.ReadOrWriteTxt;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


@Slf4j
@Service
public class BlackListToolsManagerServiceImpl implements IBlackListToolsManagerService {

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    private static Map<String, Integer> channelBlackListExpireConfigMap = new ConcurrentHashMap<>();

    private final int LIMIT = 10000;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @PostConstruct
    public void initChannelBlackListExpireConfig() {
        List<BlackListChannelExpireConfigVo0> queryBlackListChannelExpireConfigVo0List = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_CHANNEL_BLACK_LIST_EXPIRE_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackListChannelExpireConfigVo0.class));
        channelBlackListExpireConfigMap = queryBlackListChannelExpireConfigVo0List.stream().collect(Collectors.toMap(BlackListChannelExpireConfigVo0::getType, BlackListChannelExpireConfigVo0::getExpireTime));
        log.info("加载渠道黑名单有效期配置完成, result: {} ", JSON.toJSONString(channelBlackListExpireConfigMap));
    }


    @Override
    public GlobalResponse compareByExcel(String filePath,String titleNames,String haveTitle, String byColumnName,String columnDataType) {
        log.info("用户black_list_new黑名单比对开始, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , columnDataType: {} ", filePath, titleNames, haveTitle, byColumnName,columnDataType);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<Map<String,String>> paramsList = new ArrayList<Map<String,String>>();
        if(filePath!=null && byColumnName!=null){
            //1.读取表格
            boolean have = haveTitle!=null && haveTitle.equals("false") ? false:true;//默认有标题
            Map<String, Object> readMap = ReadExcelUtils.readExcel(filePath,titleNames, have);
            List<String> readList = null;
            if(readMap!=null && readMap.get("code").toString().equals("0") && readMap.get("result")!=null) {
                readList = (List<String>) readMap.get("result");
                if(readList==null || readList.size()==0){
                    return GlobalResponse.error("读取文件内容为空！");
                }
            }else{
                return GlobalResponse.error(readMap.get("msg").toString());
            }


            //判断是否MD5数据
            boolean isMD5 = false;
            if(StringUtils.isNotEmpty(columnDataType) && "MD5".equals(columnDataType)){
                isMD5 = true;
            }

            //2.查询
            String sql = "";
            List<BlackListQueryTidbVo0> blackList = new ArrayList<BlackListQueryTidbVo0>();
            //byColumnName:idcard  phoneNo  name
            if(byColumnName.equals("idcard")){
                StringBuffer querysql = new StringBuffer();
                int beachCount = 0;
                for(String params : readList){
                    beachCount++;
                    String tmp[] = params.split("[|]");
                    String tmp_Sql = Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_SQL2;
                    //判断是否MD5数据
                    if(isMD5){
                        tmp_Sql = tmp_Sql.replace("id_no =","id_no_md5 =");
                    }
                    tmp_Sql = String.format(tmp_Sql, tmp[0], tmp[3].substring(0,10)+" 00:00:00");
                    //500条查询一次
                    if(beachCount==500){
                        querysql.append(tmp_Sql);
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                        beachCount=0;
                        querysql = new StringBuffer();
                    }else{
                        querysql.append(tmp_Sql.replace(";", " union all "));
                    }
                }
                //最后不够500
                if(querysql!=null && querysql.length()>0){
                    String sql2 = querysql.toString();
                    if(querysql.toString().endsWith("union all") || querysql.toString().endsWith("union all ")){
                        sql2 = sql2.substring(0,sql2.lastIndexOf("union all"));
                    }
                    if(!querysql.toString().endsWith(";")){
                        sql2 = sql2 + ";";
                    }
                    List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                    if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                        blackList.addAll(tmpQueryList);
                    }
                }
            }else if (byColumnName.equals("mobile")){
                StringBuffer querysql = new StringBuffer();
                int beachCount = 0;
                for(String params : readList){
                    beachCount++;
                    String tmp[] = params.split("[|]");

                    String tmp_Sql = Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_SQL2;
                    //判断是否MD5数据
                    if(isMD5){
                        tmp_Sql = tmp_Sql.replace("phone_no =","phone_no_md5 =");
                    }
                    tmp_Sql = String.format(tmp_Sql, tmp[2], tmp[3].substring(0,10)+" 00:00:00");
                    //500条查询一次
                    if(beachCount==500){
                        querysql.append(tmp_Sql);
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                        beachCount=0;
                        querysql = new StringBuffer();
                    }else{
                        querysql.append(tmp_Sql.replace(";", " union all "));
                    }
                }
                //最后不够500
                if(querysql!=null && querysql.length()>0){
                    String sql_2 = querysql.toString();
                    querysql=null;
                    if(sql_2.toString().endsWith("union all") || sql_2.toString().endsWith("union all ")){
                        sql_2 = sql_2.substring(0,sql_2.lastIndexOf("union all"));
                    }
                    if(!sql_2.toString().endsWith(";")){
                        sql_2 = sql_2 + ";";
                    }
                    List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql_2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                    if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                        blackList.addAll(tmpQueryList);
                    }
                }
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "byColumnName无效的查询类型", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.error("无效的查询类型byColumnName["+byColumnName+"]");
            }

            //3.比较，处理
            if (CollectionUtils.isNotEmpty(blackList)) {
                blackList.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0 && o.isStatus()).forEach(blackListQueryTidbVo0 -> {

                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));
                });

                StringBuffer tmp = new StringBuffer();
                String[] titilName = {"id", "uuid", "name", "phone_no", "id_no", "major_type", "type", "total_overdue_days", "max_overdue_days", "black_level", "join_black_reason", "status", "created_at", "updated_at"};
                //标题
                for (int i = 0; i < titilName.length; i++) {
                    if (i==0){
                        tmp.append(titilName[i]);
                    }else{
                        tmp.append("\t");
                        tmp.append(titilName[i]);
                    }
                }

                for (BlackListQueryTidbVo0 bean:blackList) {
                    tmp.append("\n");
                    tmp.append(bean.getId());
                    tmp.append("\t"+bean.getUuid());
                    tmp.append("\t"+bean.getName());
                    //判断是否MD5数据
                    if (isMD5){
                        tmp.append("\t"+bean.getPhoneNoMd5());
                        tmp.append("\t"+bean.getIdNoMd5());
                    }else {
                        tmp.append("\t"+bean.getPhoneNo());
                        tmp.append("\t"+bean.getIdNo());
                    }
                    tmp.append("\t"+bean.getMajorType());
                    tmp.append("\t"+bean.getType());
                    tmp.append("\t"+(bean.getTotalOverdueDays()!=null ? bean.getTotalOverdueDays(): ""));
                    tmp.append("\t"+(bean.getMaxOverdueDays()!=null ? bean.getMaxOverdueDays(): ""));
                    tmp.append("\t"+bean.getBlackLevel());
                    tmp.append("\t"+bean.getJoinBlackReason());
                    tmp.append("\t"+bean.isStatus());
                    tmp.append("\t"+bean.getJoinBlackTime());
                    tmp.append("\t"+bean.getBlackUpdatedTime());
                }
                String writeFilePath = "";
                if(filePath.lastIndexOf("/")!=-1){//linux
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("/"))+"/"+byColumnName+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }else{//windows
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\"+byColumnName+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }
                ReadOrWriteTxt.writeTxt(writeFilePath,tmp.toString());
                log.info("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, ("导出成功，文件位置:"+writeFilePath), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("导出成功，文件位置:"+writeFilePath);
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "查询为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("查询为空！");
            }
        }
        log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "参数为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return GlobalResponse.error("参数为空！");
    }

    /**
     * 描述: 手动更新black_list_new黑名单表手机号&身份证号md5字段   <br/>
     * 参数: [filePath, titleNames, haveTitle, queryType]  <br/>
     * 返回值: cn.quantgroup.qgblservice.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.10  <br/>
     */
    @Override
    public GlobalResponse buildMd5Tools(String privateKey, String operatType, String idArray, String gtCreatUtc) {
        //Base64.encode("huat24WBoOxpNBpBi5wd8w==")
        if(StringUtils.isNotEmpty(privateKey) && "aHVhdDI0V0JvT3hwTkJwQmk1d2Q4dz09".equals(privateKey)){
            if(StringUtils.isEmpty(operatType)){
                return GlobalResponse.error("参数为空！");
            }
            if("all".equals(operatType)){
                return GlobalResponse.success(dealWithAll());
            }else if("byId".equals(operatType)){
                if(StringUtils.isNotEmpty(idArray) && idArray.indexOf(",,")==-1){
                    return GlobalResponse.success(dealWithById(idArray));
                }else{
                    return GlobalResponse.error("参数为空或不正确！");
                }
            }else if("byCreatUtc".equals(operatType)){
                if(StringUtils.isNotEmpty(gtCreatUtc) && gtCreatUtc.length()==13){
                    Date date = new Date(Long.parseLong(gtCreatUtc));
                    return GlobalResponse.success(dealWithByCreatUtc(sdf.format(date)));
                }else{
                    return GlobalResponse.error("参数为空或不正确！");
                }
            }else{
                return GlobalResponse.error("未知的操作类型！");
            }
        }
        return GlobalResponse.error("私钥为空或不正确，请联系管理员！");
    }

    private String dealWithAll(){
        long star = System.currentTimeMillis();
        final String SQL_MAXID = "select max(id) as 'maxId' from black_list_new;";
        final String SQL_QUERLISTBYID = "select id as 'id', phone_no as 'phone_no', id_no as 'id_no' from black_list_new where id >%d and id<=%d;";
        int maxId = 0;
        int totalCount = 0, runOkCount = 0;
        Map<String, Object> maxIdMap = blackListJdbcTemplate.queryForMap(SQL_MAXID);
        if(maxIdMap!=null && maxIdMap.get("maxId")!=null){
            maxId = Integer.parseInt(String.valueOf(maxIdMap.get("maxId")));
            log.info("dealWith all query  maxId: {} ",maxId);
            int totalPage = maxId/LIMIT;
            if((maxId%LIMIT)!=0){
                totalPage+=1;
            }

            int startId = 0,endId = 0;
            for (int page = 1; page <= totalPage; page++) {
                startId = (page-1) * LIMIT;
                endId = page * LIMIT;
                int batchExecuteResult = 0;
                long startUtc = System.currentTimeMillis();
                List<BlackListQueryTidbVo0> updateBeanList = null;
                try{
                    String query_sql = String.format(SQL_QUERLISTBYID,startId,endId);
                    log.info("dealWith all Start page: {} , startId: {} , endId: {} ",page,startId,endId);
                    List<Map<String, Object>> tmpQueryList = blackListJdbcTemplate.queryForList(query_sql);

                    if(tmpQueryList!=null && tmpQueryList.size()>0){
                        totalCount = totalCount + tmpQueryList.size();
                        updateBeanList = new ArrayList<>();
                        BlackListQueryTidbVo0 bean = null;
                        String phoneNo_md5 = null, idNo_md5 = null;
                        for(Map<String, Object> map : tmpQueryList){
                            phoneNo_md5 = null;
                            idNo_md5 = null;
                            if(map.get("phone_no")!=null && !"".equals(map.get("phone_no").toString())){
                                phoneNo_md5 = MD5Util.getMD5Digest(map.get("phone_no").toString());
                            }
                            if(map.get("id_no")!=null && !"".equals(map.get("id_no").toString())){
                                idNo_md5 = MD5Util.getMD5Digest(map.get("id_no").toString());
                            }
                            if(StringUtils.isNotEmpty(phoneNo_md5) || StringUtils.isNotEmpty(idNo_md5)){
                                bean = new BlackListQueryTidbVo0();
                                bean.setId((Long)map.get("id"));
                                bean.setPhoneNoMd5(phoneNo_md5);
                                bean.setIdNoMd5(idNo_md5);
                                updateBeanList.add(bean);
                            }
                        }
                        if(updateBeanList.size()>0){
                            batchExecuteResult = JdbcExecuters.blackListUpdateMd5BatchExecute(updateBeanList, Constant.SQL.BLACK_LIST_NEW_UPDATE_PHONENOMD5_AND_IDNOMD5_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONESMD5_AND_IDNOMD5_MANUAL);
                            runOkCount = runOkCount+batchExecuteResult;
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                    log.error("dealWith all Error page: {} , startId: {} , endId: {} ",page,startId,endId);
                }finally {
                    log.info("dealWith all End page: {} , startId: {} , endId: {} , list.size: {} , batchExecuteResult: {} ,",page,startId,endId,(updateBeanList!=null ? updateBeanList.size(): 0),batchExecuteResult,((System.currentTimeMillis()-startUtc)+".ms"));
                }
            }
        }
        log.info("dealWithAll Method End, totalCount: {} , runOkCount: {} , total cost: {} ",totalCount,runOkCount,(System.currentTimeMillis()-star)+".ms");
        return "dealWith all OK, totalCount="+totalCount+",runOkCount="+runOkCount;
    }


    private String dealWithById(String idArray){
        long star = System.currentTimeMillis();
        final String SQL_QUERLISTBYID = "select id as 'id', phone_no as 'phone_no', id_no as 'id_no' from black_list_new where id=%s ";
        String[] idArrays = idArray.split(",");
        int maxCount = idArrays.length;
        int runOkCount = 0;
        log.info("dealWith byId query  maxCount: {} ",maxCount);
        int LIMIT = 1000;
        int totalPage = maxCount/LIMIT;
        if((maxCount%LIMIT)!=0){
            totalPage+=1;
        }
        for (int page = 1; page <= totalPage; page++) {
            int startIndex = (page-1) * LIMIT;
            int endIndex = page * LIMIT;
            if(endIndex > maxCount){
                endIndex = maxCount;
            }
            long startUtc = System.currentTimeMillis();
            log.info("dealWith byId Start page: {} , startIndex: {} , endIndex: {} , maxCount: {} ",page,startIndex,endIndex,maxCount);
            StringBuffer querysql = new StringBuffer();
            String[] log_idArry = new String[endIndex-startIndex];
            int c = 0;
            for(int indx = startIndex; indx < endIndex; indx++){
                String tmpsql = String.format(SQL_QUERLISTBYID,idArrays[indx]);
                if(querysql.length()==0){
                    querysql.append(tmpsql);
                }else{
                    querysql.append(" union all ");
                    querysql.append(tmpsql);
                }
                log_idArry[c] = idArrays[indx];
                c++;
            }
            if(querysql.length()>0){
                querysql.append(";");
            }

            int batchExecuteResult = 0;
            List<BlackListQueryTidbVo0> updateBeanList = null;
            try{
                List<Map<String, Object>> tmpQueryList = blackListJdbcTemplate.queryForList(querysql.toString());
                if(tmpQueryList!=null && tmpQueryList.size()>0){
                    updateBeanList = new ArrayList<>();
                    BlackListQueryTidbVo0 bean = null;
                    String phoneNo_md5 = null, idNo_md5 = null;
                    for(Map<String, Object> map : tmpQueryList){
                        phoneNo_md5 = null;
                        idNo_md5 = null;
                        if(map.get("phone_no")!=null && !"".equals(map.get("phone_no").toString())){
                            phoneNo_md5 = MD5Util.getMD5Digest(map.get("phone_no").toString());
                        }
                        if(map.get("id_no")!=null && !"".equals(map.get("id_no").toString())){
                            idNo_md5 = MD5Util.getMD5Digest(map.get("id_no").toString());
                        }
                        if(StringUtils.isNotEmpty(phoneNo_md5) || StringUtils.isNotEmpty(idNo_md5)){
                            bean = new BlackListQueryTidbVo0();
                            bean.setId((Long)map.get("id"));
                            bean.setPhoneNoMd5(phoneNo_md5);
                            bean.setIdNoMd5(idNo_md5);
                            updateBeanList.add(bean);
                        }
                    }
                    if(updateBeanList.size()>0){
                        batchExecuteResult = JdbcExecuters.blackListUpdateMd5BatchExecute(updateBeanList, Constant.SQL.BLACK_LIST_NEW_UPDATE_PHONENOMD5_AND_IDNOMD5_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONESMD5_AND_IDNOMD5_MANUAL);
                        runOkCount+=batchExecuteResult;
                    }
                }
            }catch (Exception e){
                e.printStackTrace();
                log.error("dealWith byId Error page: {} , startIndex: {} , endIndex: {} , ids: {} ",page,startIndex,endIndex,String.join(",",log_idArry));
            }finally {
                log.info("dealWith byId End page: {} , startIndex: {} , endIndex: {} , list.size: {} , batchExecuteResult: {} ,",page,startIndex,endIndex,(updateBeanList!=null ? updateBeanList.size(): 0),batchExecuteResult,((System.currentTimeMillis()-startUtc)+".ms"));
            }
        }
        log.info("dealWithById Method End, totalCount: {} , runOkCount: {} , total cost: {} ",maxCount,runOkCount,(System.currentTimeMillis()-star)+".ms");
        return "dealWith byId OK, totalCount="+maxCount+",runOkCount="+runOkCount;
    }


    private String dealWithByCreatUtc(String nyr){
        return "暂不支持根据created_at操作.";
    }


}
