package cn.quantgroup.qgblservice.config.tidb;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * @Author fengjunkai
 * @Date 2019-08-01 15:18
 */
@Setter
@Getter
@Configuration
public class TidbDataSourceProperties {

    @Value("${tidb.db.driver}")
    private String driverClass;
    @Value("${tidb.db.minPoolSize}")
    private int minPoolSize;
    @Value("${tidb.db.maxPoolSize}")
    private int maxPoolSize;

    @Value("${data.source.tidb.jdbcUrl}")
    private String jdbcUrl;
    @Value("${data.source.tidb.username}")
    private String username;
    @Value("${data.source.tidb.password}")
    private String password;

}
