package cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.*;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: black_grey_list_result表实体 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 20:43 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Data
public class BlackGreyListResult implements Serializable {

    private static final long serialVersionUID = 3504867579864272343L;

    private String rId;
    private String uuid;
    private String name;
    private String phoneNo;
    private String idNo;

    /**phoneNo md5加密*/
    private String phoneNoMd5;
    /**idNo md5加密*/
    private String idNoMd5;

    private String blackType;
    private String types;
    private String reasons;

    @JsonIgnore
    private Timestamp createdAt;
    @JsonIgnore
    private Timestamp updatedAt;



    public static Set<String> typesToSet(String oldTypesStr, String newType){
        Set<String> typesSet = null;
        try {
            if(StringUtils.isEmpty(oldTypesStr)) {
                typesSet = new HashSet<>();
            }else{
                String[] array = oldTypesStr.trim().split("[,]");
                typesSet = new HashSet<>(Arrays.asList(array));
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(typesSet==null){
            typesSet = new HashSet<>();
        }
        typesSet.add(newType);
        return typesSet;
    }

    public static List<ReasonsVo> reasonsToList(String oldJsonStr, String newReason, String newType){
        List<ReasonsVo> reasonList = null;
        try {
            if(StringUtils.isNotEmpty(oldJsonStr)) {
                reasonList = JSONArray.parseArray(oldJsonStr, ReasonsVo.class);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(reasonList==null){
            reasonList = new ArrayList<ReasonsVo>();
        }

        int size = reasonList.size();
        if(size>=2){
            ReasonsVo back1 = reasonList.get(0);
            for(int i=1; i < size; i++){
                ReasonsVo tmp2 = reasonList.get(i);
                if(back1.getUtcTime() <= tmp2.getUtcTime()){
                    back1 = tmp2;
                }
            }
            reasonList = new ArrayList<ReasonsVo>();
            reasonList.add(back1);
        }

        ReasonsVo newObj = new ReasonsVo();
        newObj.setReason(newReason);
        newObj.setType(newType);
        newObj.setUtcTime(System.currentTimeMillis());
        reasonList.add(newObj);
        return reasonList;
    }


    public static List<ReasonsVo> reasonsToList2(String oldJsonStr, String newReason, String newType){
        List<ReasonsVo> reasonList = null;
        try {
            if(StringUtils.isNotEmpty(oldJsonStr)) {
                reasonList = JSONArray.parseArray(oldJsonStr, ReasonsVo.class);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(reasonList==null){
            reasonList = new ArrayList<ReasonsVo>();
        }

        //ReasonsVo数值长度最多保存6条，大于6条的丢弃掉历史最老的
        int maxLeng = 6;
        int size = reasonList.size();
        if(size >= maxLeng){
            //把ReasonsVo按照时间从小到大排列
            Collections.sort(reasonList, new Comparator<ReasonsVo>() {
                @Override
                public int compare(ReasonsVo v1, ReasonsVo v2) {
                    if (v1.getUtcTime() > v2.getUtcTime()) {
                        return 1;
                    }
                    if (v1.getUtcTime() == v2.getUtcTime()) {
                        return 0;
                    }
                    return -1;
                }
            });

            //取时间最近的maxLeng-1条
            List<ReasonsVo> tmpList = new ArrayList<ReasonsVo>();
            for(int i=0; i < maxLeng-1; i++){
                tmpList.add(reasonList.get(size-1-i));
            }
        }

        ReasonsVo newObj = new ReasonsVo();
        newObj.setReason(newReason);
        newObj.setType(newType);
        newObj.setUtcTime(System.currentTimeMillis());
        reasonList.add(newObj);
        return reasonList;
    }





}
