package cn.quantgroup.qgblservice.utils.dingding;


import cn.quantgroup.qgblservice.utils.http.HttpRequestUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 黑灰名单数据插入更新 钉钉提醒 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.29 14:45 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
@Slf4j
public class DingTalk {
    //@Autowired
    //private IHttpService iHttpService;

    @Value("${isDebug}")
    private Boolean isDebug;

    public static final String talkUri = "https://alertserv-dataservice.quantgroup.cn/common/alert/dingtalk";


    //黑灰名单 钉钉机器人
    public static final String WEBHOOK_BLACKGREY = "https://oapi.dingtalk.com/robot/send?access_token=959647751bda08896d69b570393d788d16b2307a50d127d6b6c6e284148aef0f";
    public static final String TITLETAGS_BLACKGREY = "黑灰名单";



    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 正常去情况下钉钉通知 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.29 15:31 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.29 15:31 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    public void talkByWebHook(String webHook, String alarmLevel, String titleTags, String titleMsg, String contentMsg) {
        if (BooleanUtils.isTrue(isDebug)) {
            log.info("测试环境下不钉钉通知, webHook: {} , alarmLevel: {} , titleTags: {} , titleMsg: {} , contentMsg: {} ", webHook, alarmLevel, titleTags, titleMsg, contentMsg);
            return;
        }

        try{
            if(StringUtils.isEmpty(webHook)){
                log.error("钉钉日常通知接口调用失败, webHook参数不能为空！");
                return;
            }
            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", alarmLevel);//"Warn"
            param.put("msgTitle", titleTags + "：" + titleMsg);
            param.put("msgContent", contentMsg);
            //String resp = iHttpService.post(talkUri, param);
            String resp = HttpRequestUtil.doPost(talkUri, param, "dingtalk");
            log.info("钉钉日常通知接口调用结束, resp: {} ", resp);
        }catch (Exception e){
            log.error("钉钉日常通知接口调用异常! ",e);
        }
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 异常情况下钉钉通知 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.29 15:32 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.29 15:32 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    public void talkByWebHook(String webHook, String alarmLevel, String titleTags, String titleMsg, Exception ex) {
        if (BooleanUtils.isTrue(isDebug)) {
            log.info("测试环境下不钉钉通知, webHook: {} , alarmLevel: {} , titleTags: {} , titleMsg: {} , contentMsg: {} ", webHook, alarmLevel, titleTags, titleMsg, ex.toString());
            return;
        }

        try{
            if(StringUtils.isEmpty(webHook)){
                log.error("钉钉日常通知接口调用失败, webHook参数不能为空！");
                return;
            }

            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", alarmLevel);//"Warn"
            param.put("msgTitle", titleTags + "：" + titleMsg);
            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg)){
                msg = ex.toString();
            }
            param.put("msgContent", msg);
            //String resp = iHttpService.post(talkUri, param);
            String resp = HttpRequestUtil.doPost(talkUri, param, "dingtalk");
            log.info("钉钉日常通知接口调用结束, resp: {} ", resp);

        }catch (Exception e){
            log.error("钉钉日常通知接口调用异常! ", e);
        }
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: @某某的通知 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.29 15:36 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.29 15:36 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    public void talk_ToUser(String webHook, String alarmLevel, String titleTags, String titleMsg, String contentMsg) {
        if (BooleanUtils.isTrue(isDebug)) {
            log.info("测试环境下不钉钉通知, webHook: {} , alarmLevel: {} , titleTags: {} , titleMsg: {} , contentMsg: {} ", webHook, alarmLevel, titleTags, titleMsg, contentMsg);
            return;
        }

        try{
            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", alarmLevel);
            param.put("msgTitle", titleTags+ " ："+titleMsg);
            param.put("msgContent", contentMsg);
            param.put("toUsers", "18010105506");
            //String resp = iHttpService.post(talkUri, param);
            String resp = HttpRequestUtil.doPost(talkUri, param, "dingtalk");
            log.info("钉钉报警接口调用结束, resp: {} ", resp);
        }catch (Exception e){
            log.warn("钉钉报警接口调用异常! ",e);
        }
    }


}
