package cn.quantgroup.qgblservice.constant;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 * -----------------------------------------------------------------------------<br>
 * 类描述:  <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.16 10:46 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public class ConstantBlackGrey {

    public static class SQL {

        public static String XYQB_QUERY_XianJinDai_15DAY = "SELECT c.uuid, d.name, d.phone_no, d.id_no, " +
                "now() created_at, now() updated_at, '1' black_type, '1' type, '1' join_black_reason, NULL max_overdue_days, NULL total_overdue_days, NULL remark " +
                "FROM repayment_plan a " +
                " LEFT JOIN loan_application_manifest_history b ON a.loan_application_history_id = b.loan_application_history_id " +
                " LEFT JOIN `user` c ON a.user_id = c.id " +
                " LEFT JOIN user_detail d ON a.user_id = d.user_id " +
                " WHERE a.deadline <= DATE_SUB(CURDATE(), INTERVAL 15 DAY) " +
                " AND a.deadline > DATE_SUB(CURDATE(), INTERVAL 20 DAY) " +
                " AND a.repayment_status NOT IN (3, 4) " +
                " AND b.transaction_status IN (2, 5) " +
                " GROUP BY c.uuid;";

        public static String ACSDB_QUERY_VCC_15DAY = "SELECT distinct a.user_id " +
                " FROM acs_plan a " +
                " LEFT JOIN acs_trans b on a.trans_id = b.id " +
                "WHERE a.plan_status ='Overdue' " +
                "AND b.trans_type in ('Shop','Loan') " +
                "AND b.trans_status = 'Complete' " +
                "AND a.repay_date<DATE_SUB(CURDATE(),INTERVAL 15 day) " +
                "AND a.repay_date>DATE_SUB(CURDATE(),INTERVAL 20 day);";

        public static String XYQBUSER_QUERY_VCC_15DAY = "SELECT c.uuid, d.name, d.phone_no, d.id_no, " +
                " now() created_at, now() updated_at, '1' black_type, '10' type, '2' join_black_reason, NULL max_overdue_days, NULL total_overdue_days, NULL remark " +
                " FROM `user` c " +
                " LEFT JOIN user_detail d ON c.id = d.user_id " +
                "WHERE c.id IN (##IN_USER_ID##);";

        //分页查询结果表黑名单
        public static String BL_QUERY_BLACKLIST_RESULT_BY_LIMIT = "SELECT r.* " +
                " FROM black_grey_list_result r " +
                " INNER JOIN ( " +
                "    SELECT br.r_id FROM black_grey_list_result br " +
                "    where br.black_type='1' " +
                "    ORDER BY br.r_id LIMIT ?, ? " +
                ") AS page USING(r_id); ";
        public static String BL_QUERY_BLACKLIST_RESULT_MAX_ID = " SELECT max(id) as 'maxId' FROM black_grey_list_result r WHERE r.black_type='1';";
        public static String BL_QUERY_BLACKLIST_RESULT_BY_LIMIT_ID = " SELECT ##r.*## " +
                " FROM black_grey_list_result r " +
                " WHERE r.black_type='1' AND id >? AND id<=?; ";


        //现金分期在逾转已还清
        public static String XYQB_QUERY_XIANJINDAI_IS_PAYOFF = "select count(distinct a.user_id) in_overdue " +
                " from repayment_plan a " +
                " left join loan_application_manifest_history b " +
                " on a.loan_application_history_id=b.loan_application_history_id " +
                " left join user c on a.user_id=c.id " +
                " where c.uuid=? " +
                " and b.transaction_status in (2,5) " +
                " and a.repayment_status not in (3,4) and a.deadline<=CURDATE(); ";

        //白条在逾转已还清
        public static String XYQB_QUERY_BAITIAO_IS_PAYOFF = "select count(distinct a.user_id) in_overdue " +
                " from baitiao_repayment_plan a " +
                " left join baitiao_order b on a.order_id=b.id " +
                " left join user c on a.user_id=c.id " +
                " where c.uuid=? " +
                " and b.status=1 " +
                " and a.repayment_status not in (3,4) and a.deadline<CURDATE(); ";

        //VCC在逾转已还清
        public static String XYQB_QUERY_VCC_IS_PAYOFF = "select count(distinct a.user_id) in_overdue " +
                " from acs_plan a " +
                " left join acs_trans b on a.trans_id = b.id " +
                " where a.plan_status ='Overdue' " +
                " and b.trans_type in ('Shop','Loan') " +
                " and b.trans_status = 'Complete' " +
                " and a.user_id=?;";

        //查询黑名单-现金分期-最大逾期天数
        public static String XYQB_QUERY_XIANJINDAI_OVERDUE_DAYS = " select max(if(repayment_status=3,DATEDIFF(repaid_at,deadline)+1,DATEDIFF(CURDATE(),deadline)+1)) max_overdue_days " +
                " ,sum(if(repayment_status=3,DATEDIFF(repaid_at,deadline)+1,DATEDIFF(CURDATE(),deadline)+1)) total_overdue_days " +
                " from repayment_plan a " +
                " left join user b on a.user_id=b.id " +
                " left join loan_application_manifest_history c on a.loan_application_history_id=c.loan_application_history_id " +
                " where c.transaction_status in (2,5) " +
                " and deadline<=CURDATE() " +
                " and (repayment_status not in (3,4) or (repayment_status=3 and repaid_at>=deadline)) " +
                " and b.uuid =?; ";

        //查询黑名单-白条-最大逾期天数
        public static String XYQB_QUERY_BAITIAO_OVERDUE_DAYS = " select max(if(repayment_status=3,DATEDIFF(repaid_at,deadline),DATEDIFF(CURDATE(),deadline))) max_overdue_days " +
                " ,sum(if(repayment_status=3,DATEDIFF(repaid_at,deadline),DATEDIFF(CURDATE(),deadline))) total_overdue_days " +
                " from baitiao_repayment_plan a " +
                " left join baitiao_order b on a.order_id=b.id " +
                " left join user c on a.user_id=c.id " +
                " where b.status=1 " +
                " and deadline<CURDATE() " +
                " and (repayment_status <>3 or (repayment_status=3 and repaid_at>=deadline)) " +
                " and c.uuid=?;";

        //查询黑名单-VCC-最大逾期天数
        public static String XYQB_QUERY_VCC_OVERDUE_DAYS = "select max(if(plan_status ='Finish',DATEDIFF(paid_off_date,repay_date),DATEDIFF(CURDATE(),repay_date))) max_overdue_days " +
                " ,sum(if(plan_status ='Finish',DATEDIFF(paid_off_date,repay_date),DATEDIFF(CURDATE(),repay_date))) total_overdue_days " +
                " from acs_plan a " +
                " left join acs_trans b on a.trans_id = b.id " +
                " where b.trans_type in ('Shop','Loan') " +
                " and b.trans_status = 'Complete' " +
                " and a.repay_date<CURDATE() " +
                " and (plan_status <>'Finish' or (plan_status ='Finish' and paid_off_date>repay_date)) " +
                " and a.user_id=?; ";

    }


    public static class PARAM {
        public static final String[] BLACK_LIST_TYPES = {"1","2","10"};

        public static final String SEPA = File.separator; //System.getProperty("file.separator");

        public static final DateFormat DF_YMD = new SimpleDateFormat("yyyyMMdd");

        public static final DateFormat DF_YMDHMS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public static final String  SAVELOGPATH = "/home/quant_group/qg-bl-service/logs/";

        /**当前服务器CPU个数*/
        public static final int SYS_CPU_COUNT = Runtime.getRuntime().availableProcessors();
    }

    public static class DAYE_FORMAT{
        public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
        public static final String YYYYMMDD = "yyyyMMdd";
    }

    public static class REDIS_KEY{
        public static final String JOB_ADD_BLACK_LIST_INCREMENT_KEY = "JOB_ADD_BLACK_LIST_INCREMENT_KEY";

        public static final String SIGN_IS_RUN_BLACK_TO_GREY_KEY = "SIGN_IS_RUN_BLACK_TO_GREY_KEY";
        public static final String JOB_REMOVE_BLACK_TO_GREY_INCREMENT_KEY = "JOB_REMOVE_BLACK_TO_GREY_INCREMENT_KEY";


        public static final String SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY = "SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY";
        public static final String JOB_UPDATE_BLACK_OVERDUEDAY_INCREMENT_KEY = "JOB_UPDATE_BLACK_OVERDUEDAY_INCREMENT_KEY";


    }

}
