package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.ConstantBlackGrey;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.*;
import cn.quantgroup.qgblservice.repository.mybatis.entity.xyqbuser.XyqbUser;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputing;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputingProcess;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 逾期已还清黑名单>>转灰名单-并行框架 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.16 21:12 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class UpdateBlackListOverdueDayParallel implements ParallelComputingProcess<BlackGreyListResult, Set<String>> {

    private final String log_inf = "BlackToGreyListParallel";

    private final String sepa = File.separator; //System.getProperty("file.separator");
    private final DateFormat df = new SimpleDateFormat(ConstantBlackGrey.DAYE_FORMAT.YYYYMMDD);
    private final String  saveLogPath = "/home/quant_group/qg-bl-service/logs/";


    //并行处理框架
    private ParallelComputing<BlackGreyListResult, Set<String>> p = new ParallelComputing<BlackGreyListResult, Set<String>>("BlackToGreyListParallel");
    /**
     * 当前服务器CPU个数
     */
    private static int SYS_CPU_COUNT = Runtime.getRuntime().availableProcessors();//4
    //private static int SYS_CPU_COUNT = 1;

    @Autowired
    private BlackGreyListMapper blackGreyListMapper;

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate acsdbJdbcTemplate;

    //@Autowired
    //private JdbcTemplate blackListJdbcTemplate;

    public String runMain(List<BlackGreyListResult> tmpQueryList) {
        long startProcess = System.currentTimeMillis();
        int listSize = tmpQueryList.size();
        log.info(log_inf+"-runMain更新逾期天数开始执行, listSize: {} , SYS_CPU_COUNT: {} ", listSize, SYS_CPU_COUNT);

        try {
            //并行框架---执行
            Set<String> optSet = Collections.synchronizedSet(new HashSet<>());
            p.processForThread(tmpQueryList, this, SYS_CPU_COUNT, optSet);

            //并行框架执行结果
            if (optSet.size() > 0) {//并行框架执行异常
                log.error("黑名单转灰名单runMain() ERROR! >> optSet size:{} , Json:{} ", optSet.size(), JSONObject.toJSONString(optSet));
            } else {
                //执行成功
                log.info(log_inf + " >> to process() is OK!");
            }
            log.info(log_inf +"-runMain更新逾期天数执行结束, cost:" + (System.currentTimeMillis() - startProcess) + "ms.");

            String resMsgTemp = "更新逾期天数总共 %d条, 执行成功 %d条, 失败 %d条;";
            return String.format(resMsgTemp, listSize, listSize-optSet.size(), optSet.size());
        } catch (Exception e) {
            log.error(log_inf +"-runMain更新逾期天数执行异常.", e);
        }
        return "更新逾期天数执行异常";
    }


    @Override
    public void process(int threadId, List<BlackGreyListResult> blackResultList, Set<String> optSet) {
        AtomicInteger update_count = new AtomicInteger();
        AtomicInteger err_count = new AtomicInteger();
        AtomicInteger type_11 = new AtomicInteger();
        int list_size = blackResultList.size();
        //yyyyMMdd
        Calendar calendar = Calendar.getInstance();
        String dateName = df.format(calendar.getTime());
        int index = 0;

        for (BlackGreyListResult blackResult : blackResultList) {
            //blackResult>>r_id,uuid,black_type
            log.info("threadId_{}: 开始执行修改逾期天数list_size: {} , this: {} ", threadId , list_size, (++index));

            String rId = blackResult.getRId();
            String uuid = blackResult.getUuid();

            if(StringUtils.isNotEmpty(uuid)){
                try {
                    BlackGreyListQueryVo queryParam = BlackGreyListQueryVo.builder().rId(rId).status(0).build();
                    List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryParam);
                    boolean details_is_update= false; //用于标记修改结果表修改时间

                    if (detailsList!=null && detailsList.size()>0) {
                        boolean is_type_11 = false;
                        for(BlackGreyListDetails detailsVo : detailsList){
                            //type=11, 恶意投诉客服，一直在黑名单
                            if("11".equals(detailsVo.getType())){
                                type_11.getAndIncrement();
                                continue;
                            }
                            //现金贷
                            else if("1".equals(detailsVo.getType()) && detailsVo.getStatus()==0){
                                //查询现金贷逾期，是否逾期已还清
                                OverdueDaysVo overdueDays = null;
                                try {
                                    overdueDays = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_XIANJINDAI_OVERDUE_DAYS, new Object[]{uuid}, new RowMapper<OverdueDaysVo>() {
                                        @Override
                                        public OverdueDaysVo mapRow(ResultSet rs, int rowNum) throws SQLException {
                                            OverdueDaysVo bean = new OverdueDaysVo();
                                            bean.setMaxOverdueDays(rs.getString("max_overdue_days"));
                                            bean.setTotalOverdueDays(rs.getString("total_overdue_days"));
                                            return null;
                                        }
                                    });
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询[现金贷]黑名单逾期天数-查询xyqb异常, r_Id: {} , uuid: {} , id: {}  e: {} ", rId, uuid, detailsVo.getId(), e.toString());
                                }finally {
                                    log.info("查询[现金贷]黑名单逾期天数-结束, r_Id: {} , uuid: {} , id: {} , overdueDays : {} ", rId, uuid, detailsVo.getId(), overdueDays!=null ? JSON.toJSONString(overdueDays):"null");
                                }

                                //修改逾期天数
                                int update = updateOverdueDay(overdueDays, detailsVo, "现金贷");
                                if(update>0){
                                    details_is_update = true;
                                }
                            }

                            //白条
                            else if("2".equals(detailsVo.getType()) && detailsVo.getStatus()==0){
                                OverdueDaysVo overdueDays = null;
                                try {
                                    overdueDays = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_BAITIAO_OVERDUE_DAYS, new Object[]{uuid}, new RowMapper<OverdueDaysVo>() {
                                        @Override
                                        public OverdueDaysVo mapRow(ResultSet rs, int rowNum) throws SQLException {
                                            OverdueDaysVo bean = new OverdueDaysVo();
                                            bean.setMaxOverdueDays(rs.getString("max_overdue_days"));
                                            bean.setTotalOverdueDays(rs.getString("total_overdue_days"));
                                            return null;
                                        }
                                    });
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询[白条]黑名单逾期天数-查询xyqb异常, r_Id: {} , uuid: {} , id: {}  e: {} ", rId, uuid, detailsVo.getId(), e.toString());
                                }finally {
                                    log.info("查询[白条]黑名单逾期天数-结束, r_Id: {} , uuid: {} , id: {} , overdueDays : {} ", rId, uuid, detailsVo.getId(), overdueDays!=null ? JSON.toJSONString(overdueDays):"null");
                                }

                                //修改逾期天数
                                int update = updateOverdueDay(overdueDays, detailsVo, "白条");
                                if(update>0){
                                    details_is_update = true;
                                }
                            }

                            //Vcc
                            else if("10".equals(detailsVo.getType()) && detailsVo.getStatus()==0){
                                OverdueDaysVo overdueDays = null;
                                //查询user_id
                                XyqbUser xyqbUser = queryXyqbUserByUuid(uuid);
                                if(xyqbUser!=null && xyqbUser.getId()!=0L){
                                    try {
                                        overdueDays = acsdbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_VCC_OVERDUE_DAYS, new Object[]{xyqbUser.getId()}, new RowMapper<OverdueDaysVo>() {
                                            @Override
                                            public OverdueDaysVo mapRow(ResultSet rs, int rowNum) throws SQLException {
                                                OverdueDaysVo bean = new OverdueDaysVo();
                                                bean.setMaxOverdueDays(rs.getString("max_overdue_days"));
                                                bean.setTotalOverdueDays(rs.getString("total_overdue_days"));
                                                return null;
                                            }
                                        });
                                    }catch (EmptyResultDataAccessException e){
                                        log.error("查询[VCC]黑名单逾期天数-查询xyqb异常, r_Id: {} , uuid: {} , id: {}  e: {} ", rId, uuid, detailsVo.getId(), e.toString());
                                    }finally {
                                        log.info("查询[VCC]黑名单逾期天数-结束, r_Id: {} , uuid: {} , id: {} , overdueDays : {} ", rId, uuid, detailsVo.getId(), overdueDays!=null ? JSON.toJSONString(overdueDays):"null");
                                    }

                                    //修改逾期天数
                                    int update = updateOverdueDay(overdueDays, detailsVo, "白条");
                                    if(update>0){
                                        details_is_update = true;
                                    }
                                }
                            }else{
                                err_count.getAndIncrement();
                                optSet.add("otherType:"+blackResult.getRId());
                                writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                            }
                        }

                        //如果明细表有修改，更新一下结果表修改时间
                        if(details_is_update){
                            //更新结果表
                            BlackGreyListResult updateResult = new BlackGreyListResult();
                            updateResult.setRId(blackResult.getRId());//条件
                            updateResult.setUpdatedAt(new Timestamp(System.currentTimeMillis()));//结果
                            int update_r = blackGreyListMapper.updateBlackGreyListResult(updateResult);
                            update_count.getAndIncrement();
                        }

                    }else {
                        err_count.getAndIncrement();
                        optSet.add("notFind:"+blackResult.getRId());
                        writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                    }

                } catch (Exception e) {
                    optSet.add("ERR:" + blackResult.getRId());
                    log.error(log_inf + "process() threadId:" + threadId + ",ERROR!", e);
                }
            }else {
                log.error("查询黑名单逾期天-发现uuid为空, threadId_{} , r_Id: {} , uuid: {} , blackType: {} ", threadId, rId, uuid, blackResult.getBlackType());
            }

        }
        log.info(log_inf + "处理结束 CPU_{} , update_count:{} , type_11: {} , err_count:{} , this_list_size: {} ", threadId, update_count.get(), type_11.get(), err_count.get(), list_size);
    }





    //-------------------------------------------------------------------------

    private static void writeLogByName(String fileName, String msg) {
        try {
            FileUtils.write(new File(fileName), msg + "\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error," + msg + "," + e.toString());
        }
    }


    private XyqbUser queryXyqbUserByUuid(String uuid) {
        String sql_byUUid = "select u.id, u.uuid, u.phone_no from `user` u where u.uuid=? AND u.`enable`=1 ";
        List<XyqbUser> xyqbUserList = null;
        try {
            xyqbUserList = xyqbUserJdbcTemplate.query(sql_byUUid, new Object[]{uuid}, new RowMapper<XyqbUser>() {
                @Override
                public XyqbUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                    XyqbUser bean = new XyqbUser();
                    bean.setId(rs.getLong("id"));
                    bean.setUuid(rs.getString("uuid"));
                    bean.setPhoneNo(rs.getString("phone_no"));
                    return bean;
                }
            });


        } catch (Exception e) {
            log.error("根据uuid查询xyqb用户异常, uuid: {} ", uuid, e);
        }

        if(xyqbUserList!=null && xyqbUserList.size()>0){
            return xyqbUserList.get(0);
        }
        return null;
    }

    //更新黑名单明细表-逾期天数
    private int updateOverdueDay(OverdueDaysVo overdueDays, BlackGreyListDetails detailsVo, String log_inf) {
        try {
            if (overdueDays != null) {
                DetailsUpdate detailUpdateParam = new DetailsUpdate();
                detailUpdateParam.setMaxOverdueDays(overdueDays.getMaxOverdueDays());
                detailUpdateParam.setTotalOverdueDays(overdueDays.getTotalOverdueDays());
                detailUpdateParam.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                //条件
                detailUpdateParam.setId(detailsVo.getId());
                //detailUpdateParam.setRId(detailsVo.getRId());
                //detailUpdateParam.setWEqType(detailsVo.getType());
                //detailUpdateParam.setWEqStatus(0);
                int update = blackGreyListMapper.updateDetailOverdueDayById(detailUpdateParam);
                return update;

            }
        } catch (Exception e) {
            log.error("修改[" + log_inf + "]黑名单逾期天数-异常, r_Id: {} , id: {} , overdueDays: {} ", detailsVo.getRId(), detailsVo.getId(), overdueDays!=null?JSONObject.toJSONString(overdueDays):"null", e);
        }
        return 0;
    }



}
