package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.ConstantBlackGrey;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.*;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyList;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyListRowMapper;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.service.IBlackGreyListService;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.blacklist.BlackListUtils;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

import java.sql.*;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;


@Slf4j
@Service
public class BlackGreyListServiceImpl implements IBlackGreyListService {

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;

    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;

    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    @Autowired
    private JdbcTemplate acsdbJdbcTemplate;

    @Autowired
    private BlackGreyListMapper blackGreyListMapper;

    @Autowired
    private BlackToGreyListParallel blackToGreyListParallel;

    @Autowired
    private UpdateBlackListOverdueDayParallel updateBlackListOverdueDayParallel;

    //private static int pageSize = 10000;
    private static int pageSize = 5000;

    //private static Map<String, Integer> channelBlackListExpireConfigMap = new ConcurrentHashMap<>();
    /*@PostConstruct
    public void initChannelBlackListExpireConfig() {
        List<BlackListChannelExpireConfigVo0> queryBlackListChannelExpireConfigVo0List = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_CHANNEL_BLACK_LIST_EXPIRE_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackListChannelExpireConfigVo0.class));
        channelBlackListExpireConfigMap = queryBlackListChannelExpireConfigVo0List.stream().collect(Collectors.toMap(BlackListChannelExpireConfigVo0::getType, BlackListChannelExpireConfigVo0::getExpireTime));
        log.info("加载渠道黑名单有效期配置完成, result: {} ", JSON.toJSONString(channelBlackListExpireConfigMap));
    }*/

    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: 往black_grey_list_result表及black_grey_list_details表插入<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.02 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     *
     * @param blackGreyObj
     */
    @Override
    public int saveBlackGreyList(TmpBlackGreyList blackGreyObj) {
        try {
            BlackGreyListQueryVo queryResultParam = BlackGreyListQueryVo.builder().name(blackGreyObj.getName()).idNo(blackGreyObj.getIdNo()).phoneNo(blackGreyObj.getPhoneNo()).build();
            List<BlackGreyListResult> blackGreyResultList = blackGreyListMapper.findBlackGreyListResultBy3YS(queryResultParam);

            BlackGreyListResult oldResult = null;
            BlackGreyListDetails details = new BlackGreyListDetails();

            //结果中没有，新增
            if(blackGreyResultList==null || blackGreyResultList.size()==0){
                String rId = UUID.randomUUID().toString().replaceAll("-", "");
                oldResult = new BlackGreyListResult();
                oldResult.setRId(rId);
                oldResult.setUuid(blackGreyObj.getUuid()!=null ? blackGreyObj.getUuid().trim() : null);
                oldResult.setName(blackGreyObj.getName()!=null ? blackGreyObj.getName().trim() : null);
                oldResult.setPhoneNo(blackGreyObj.getPhoneNo()!=null ? blackGreyObj.getPhoneNo().trim() : null);
                oldResult.setIdNo(blackGreyObj.getIdNo()!=null ? blackGreyObj.getIdNo().trim().toUpperCase() : null);
                if(StringUtils.isNotEmpty(oldResult.getPhoneNo())){
                    oldResult.setPhoneNoMd5(MD5Util.getMD5Digest(oldResult.getPhoneNo()));
                }
                if(StringUtils.isNotEmpty(oldResult.getIdNo())){
                    oldResult.setIdNoMd5(MD5Util.getMD5Digest(oldResult.getIdNo()));
                }
                oldResult.setBlackType(blackGreyObj.getBlackType());
                oldResult.setTypes(blackGreyObj.getType());
                List<ReasonsVo> reasonsList = BlackGreyListResult.reasonsToList(null, blackGreyObj.getJoinBlackReason(), blackGreyObj.getType());
                oldResult.setReasons(JSON.toJSONString(reasonsList));
                oldResult.setCreatedAt(blackGreyObj.getCreatedAt());
                oldResult.setUpdatedAt(blackGreyObj.getUpdatedAt());

                details.setRId(rId);
                details.setName(oldResult.getName());
                details.setPhoneNo(oldResult.getPhoneNo());
                details.setIdNo(oldResult.getIdNo());
                details.setType(blackGreyObj.getType());
                details.setReasonCode(blackGreyObj.getJoinBlackReason());
                details.setMaxOverdueDays(blackGreyObj.getMaxOverdueDays());
                details.setTotalOverdueDays(blackGreyObj.getTotalOverdueDays());
                details.setStatus(0);//状态 0:正常有效的； -1:由灰名单进入黑名单(无效，逻辑删除的)； -2:由黑名单进入灰名单(无效，逻辑删除的)；-3:在插入灰名单时，已经是黑名单 10：当前在黑名单，并且该条数据逾期已还清的
                details.setRemark(blackGreyObj.getRemark());
                details.setCreatedAt(blackGreyObj.getCreatedAt());
                details.setUpdatedAt(blackGreyObj.getUpdatedAt());

                int insert_result = blackGreyListMapper.insertBlackGreyListResult(oldResult);

                int insert_details =blackGreyListMapper.insertBlackGreyListDetails(details);

                log.info("黑灰名单增加结束-结果表插入: {} , 明细表插入: {} , blackGreyObj : {} ", insert_result, insert_details, blackGreyObj.toString());
                return 1;
            }else{

                if(blackGreyResultList.size()!=1){
                    log.error("通过三要素正常查询结果表只有一条数据, 此时存在 "+blackGreyResultList.size()+" 条, blackGreyObj: {} ", blackGreyObj.toString());
                    throw new SQLException("通过三要素正常查询结果表只有一条数据, 此时存在 "+blackGreyResultList.size()+" 条, id="+blackGreyObj.getId());
                }
                oldResult = blackGreyResultList.get(0);
                BlackGreyListResult updateResult = new BlackGreyListResult();
                DetailsUpdate detailUpdateParam= null;
                //updateParams.setUpdatedAt("")
                //updateParams.setBlackType("");
                //updateParams.setTypes("");
                //updateParams.setReasons("");

                updateResult.setRId(oldResult.getRId());
                if(oldResult.getUpdatedAt().getTime() >= blackGreyObj.getUpdatedAt().getTime()){
                    updateResult.setUpdatedAt(oldResult.getUpdatedAt());
                }else{
                    updateResult.setUpdatedAt(blackGreyObj.getUpdatedAt());
                }

                Set<String> typeSet = BlackGreyListResult.typesToSet(oldResult.getTypes(), blackGreyObj.getType());
                List<ReasonsVo> reasonsList = BlackGreyListResult.reasonsToList(oldResult.getReasons(), blackGreyObj.getJoinBlackReason(), blackGreyObj.getType());
                /* 状态 status
                  0:正常有效的；
                 -1:由灰名单进入黑名单(无效，逻辑删除的)；
                 -2:由黑名单进入灰名单(无效，逻辑删除的)；
                 -3:在插入灰名单时，已经是黑名单
                 10：当前在黑名单，并且该条数据逾期已还清的
                 */
                int details_status = 0;

                if("1".equals(oldResult.getBlackType()) && "1".equals(blackGreyObj.getBlackType())){
                    updateResult.setBlackType("1");
                    updateResult.setTypes(String.join(",", typeSet));
                    updateResult.setReasons(JSON.toJSONString(reasonsList));
                }
                else if("2".equals(oldResult.getBlackType()) && "2".equals(blackGreyObj.getBlackType())){
                    updateResult.setBlackType("2");
                    updateResult.setTypes(String.join(",", typeSet));
                    updateResult.setReasons(JSON.toJSONString(reasonsList));
                }
                //黑名单，不能转灰
                else if("1".equals(oldResult.getBlackType()) && "2".equals(blackGreyObj.getBlackType())){
                    updateResult.setBlackType("1");
                    updateResult.setTypes(String.join(",", typeSet));
                    updateResult.setReasons(JSON.toJSONString(reasonsList));
                    details_status = -3; // -3:在插入灰名单时，已经是黑名单
                }
                //由灰名单 转 黑名单
                else if("2".equals(oldResult.getBlackType()) && "1".equals(blackGreyObj.getBlackType())){
                    updateResult.setBlackType("1");
                    updateResult.setTypes(String.join(",", typeSet));
                    updateResult.setReasons(JSON.toJSONString(reasonsList));

                    detailUpdateParam = new DetailsUpdate();
                    detailUpdateParam.setStatus(-1);//-1:由灰名单进入黑名单(无效，逻辑删除的)
                    detailUpdateParam.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                    //条件
                    detailUpdateParam.setRId(oldResult.getRId());
                    detailUpdateParam.setWEqStatus(0);
                }
                else{
                    log.error("黑灰名单新增发现其他类别BlackType, oldResult : {} , blackGrey : {} ", oldResult.toString(), blackGreyObj.toString());
                    throw new SQLException("黑灰名单新增发现其他类别BlackType, oldResult:"+oldResult.getBlackType()+", blackGrey:"+blackGreyObj.getBlackType());
                }

                details.setRId(oldResult.getRId());
                details.setName(oldResult.getName());
                details.setPhoneNo(oldResult.getPhoneNo());
                details.setIdNo(oldResult.getIdNo());
                details.setType(blackGreyObj.getType());
                details.setReasonCode(blackGreyObj.getJoinBlackReason());
                details.setMaxOverdueDays(blackGreyObj.getMaxOverdueDays());
                details.setTotalOverdueDays(blackGreyObj.getTotalOverdueDays());
                details.setStatus(details_status);
                details.setRemark(blackGreyObj.getRemark());
                details.setCreatedAt(blackGreyObj.getCreatedAt());
                details.setUpdatedAt(blackGreyObj.getUpdatedAt());

                int delete_details = 0;
                if(detailUpdateParam!=null){
                    delete_details = blackGreyListMapper.updateDetailsStatusByparams(detailUpdateParam);
                }

                int insert_details = blackGreyListMapper.insertBlackGreyListDetails(details);

                int update_result = blackGreyListMapper.updateBlackGreyListResult(updateResult);

                log.info("黑灰名单增加结束-结果表修改: {} , 明细表插入: {} ,  明细表修改: {} , blackGreyObj : {} ", update_result, insert_details, delete_details, blackGreyObj.toString());

                return 1;
            }

        }catch (Exception e){
            log.error("黑灰名单增加数据异常, bean: {} ", blackGreyObj.toString(), e);
        }
        return 0;
    }

    @Override
    public int saveBlackGreyListByJdbc(List<TmpBlackGreyList> tmpQueryList) throws SQLException {
        /*String sql_insert_result = " insert ignore into black_grey_list_result (`r_id`, `uuid`, `name`, `phone_no`, `id_no`, `phone_no_md5`, `id_no_md5`, `black_type`, `types`, `reasons`, `created_at`, `updated_at`) " +
                " values (?,?,?,?,?,?,?,?,?,?,?,?) ;";
        String sql_insert_details = "  insert ignore into black_grey_list_details (`r_id`, `name`, `phone_no`, `id_no`, `type`, `reason_code`, `max_overdue_days`, `total_overdue_days`, `status`, `remark`, `created_at`, `updated_at`) " +
                " values (?,?,?,?,?,?,?,?,?,?,?,?) ;";
        String sql_update_result = "UPDATE black_grey_list_result set black_type=?, types=?, reasons=?, updated_at=? WHERE r_id=? ;";
        String sql_update_details = "UPDATE black_grey_list_details set status=?, updated_at=? WHERE r_id=? AND status=0;";*/

        AtomicInteger atomicInteger = new AtomicInteger();
        Connection conn = null;
        Statement statement = null;
        Boolean ac = null;
        try {
            conn = blackListJdbcTemplate.getDataSource().getConnection();
            statement = conn.createStatement();
            // 获取到原本的自动提交状态
            ac = conn.getAutoCommit();

            for(TmpBlackGreyList blackGreyObj : tmpQueryList){
                BlackGreyListResult insertResult = null;
                BlackGreyListResult updateResult = null;
                BlackGreyListDetails insertdetails = null;
                BlackGreyListDetails deleteDetails = null;

                try {
                    BlackGreyListQueryVo queryResultParam = BlackGreyListQueryVo.builder().name(blackGreyObj.getName()).idNo(blackGreyObj.getIdNo()).phoneNo(blackGreyObj.getPhoneNo()).build();
                    List<BlackGreyListResult> blackGreyResultList = blackGreyListMapper.findBlackGreyListResultBy3YS(queryResultParam);

                    //结果中没有，新增
                    if(blackGreyResultList==null || blackGreyResultList.size()==0){
                        String rId = UUID.randomUUID().toString().replaceAll("-", "");
                        insertResult = new BlackGreyListResult();
                        insertResult.setRId(rId);
                        insertResult.setUuid(blackGreyObj.getUuid()!=null ? blackGreyObj.getUuid().trim() : null);
                        insertResult.setName(blackGreyObj.getName()!=null ? blackGreyObj.getName().trim() : null);
                        insertResult.setPhoneNo(blackGreyObj.getPhoneNo()!=null ? blackGreyObj.getPhoneNo().trim() : null);
                        insertResult.setIdNo(blackGreyObj.getIdNo()!=null ? blackGreyObj.getIdNo().trim().toUpperCase() : null);
                        if(StringUtils.isNotEmpty(insertResult.getPhoneNo())){
                            insertResult.setPhoneNoMd5(MD5Util.getMD5Digest(insertResult.getPhoneNo()));
                        }
                        if(StringUtils.isNotEmpty(insertResult.getIdNo())){
                            insertResult.setIdNoMd5(MD5Util.getMD5Digest(insertResult.getIdNo()));
                        }
                        insertResult.setBlackType(blackGreyObj.getBlackType());
                        insertResult.setTypes(blackGreyObj.getType());
                        List<ReasonsVo> reasonsList = BlackGreyListResult.reasonsToList(null, blackGreyObj.getJoinBlackReason(), blackGreyObj.getType());
                        insertResult.setReasons(JSON.toJSONString(reasonsList));
                        insertResult.setCreatedAt(blackGreyObj.getCreatedAt());
                        insertResult.setUpdatedAt(blackGreyObj.getUpdatedAt());

                        insertdetails = new BlackGreyListDetails();
                        insertdetails.setRId(rId);
                        insertdetails.setName(insertResult.getName());
                        insertdetails.setPhoneNo(insertResult.getPhoneNo());
                        insertdetails.setIdNo(insertResult.getIdNo());
                        insertdetails.setType(blackGreyObj.getType());
                        insertdetails.setReasonCode(blackGreyObj.getJoinBlackReason());
                        insertdetails.setMaxOverdueDays(blackGreyObj.getMaxOverdueDays());
                        insertdetails.setTotalOverdueDays(blackGreyObj.getTotalOverdueDays());
                        insertdetails.setStatus(0);//状态 0:正常有效的； -1:由灰名单进入黑名单(无效，逻辑删除的)； -2:由黑名单进入灰名单(无效，逻辑删除的)；-3:在插入灰名单时，已经是黑名单 10：当前在黑名单，并且该条数据逾期已还清的
                        insertdetails.setRemark(blackGreyObj.getRemark());
                        insertdetails.setCreatedAt(blackGreyObj.getCreatedAt());
                        insertdetails.setUpdatedAt(blackGreyObj.getUpdatedAt());

                       log.info("黑灰名单增加结束-结果表插入: {} , 明细表插入: {} ", insertResult.toString(), insertdetails.toString());
                    }else{

                        if(blackGreyResultList.size()!=1){
                            log.error("通过三要素正常查询结果表只有一条数据, 此时存在 "+blackGreyResultList.size()+" 条, blackGreyObj: {} ", blackGreyObj.toString());
                            throw new SQLException("通过三要素正常查询结果表只有一条数据, 此时存在 "+blackGreyResultList.size()+" 条, id="+blackGreyObj.getId());
                        }
                        BlackGreyListResult oldResult = blackGreyResultList.get(0);

                        updateResult = new BlackGreyListResult();
                        //UpdatedAt BlackType Types Reasons
                        updateResult.setRId(oldResult.getRId());
                        if(oldResult.getUpdatedAt().getTime() >= blackGreyObj.getUpdatedAt().getTime()){
                            updateResult.setUpdatedAt(oldResult.getUpdatedAt());
                        }else{
                            updateResult.setUpdatedAt(blackGreyObj.getUpdatedAt());
                        }

                        Set<String> typeSet = BlackGreyListResult.typesToSet(oldResult.getTypes(), blackGreyObj.getType());
                        List<ReasonsVo> reasonsList = BlackGreyListResult.reasonsToList(oldResult.getReasons(), blackGreyObj.getJoinBlackReason(), blackGreyObj.getType());
                        /* 状态 status
                          0:正常有效的；
                         -1:由灰名单进入黑名单(无效，逻辑删除的)；
                         -2:由黑名单进入灰名单(无效，逻辑删除的)；
                         -3:在插入灰名单时，已经是黑名单
                         10：当前在黑名单，并且该条数据逾期已还清的
                         */
                        int details_status = 0;

                        if("1".equals(oldResult.getBlackType()) && "1".equals(blackGreyObj.getBlackType())){
                            updateResult.setBlackType("1");
                            updateResult.setTypes(String.join(",", typeSet));
                            updateResult.setReasons(JSON.toJSONString(reasonsList));
                        }
                        else if("2".equals(oldResult.getBlackType()) && "2".equals(blackGreyObj.getBlackType())){
                            updateResult.setBlackType("2");
                            updateResult.setTypes(String.join(",", typeSet));
                            updateResult.setReasons(JSON.toJSONString(reasonsList));
                        }
                        //黑名单，不能转灰
                        else if("1".equals(oldResult.getBlackType()) && "2".equals(blackGreyObj.getBlackType())){
                            updateResult.setBlackType("1");
                            updateResult.setTypes(String.join(",", typeSet));
                            updateResult.setReasons(JSON.toJSONString(reasonsList));
                            details_status = -3; // -3:在插入灰名单时，已经是黑名单
                        }
                        //由灰名单 转 黑名单 >> 需要将明细表里之前的灰名单明细逻辑删除
                        else if("2".equals(oldResult.getBlackType()) && "1".equals(blackGreyObj.getBlackType())){
                            updateResult.setBlackType("1");
                            updateResult.setTypes(String.join(",", typeSet));
                            updateResult.setReasons(JSON.toJSONString(reasonsList));

                            deleteDetails = new BlackGreyListDetails();
                            deleteDetails.setRId(oldResult.getRId());
                            deleteDetails.setStatus(-1);//-1:由灰名单进入黑名单(无效，逻辑删除的)
                            Timestamp newTime = new Timestamp(System.currentTimeMillis());
                            deleteDetails.setUpdatedAt(newTime);
                        }
                        else{
                            log.error("黑灰名单新增发现其他类别BlackType, oldResult : {} , blackGrey : {} ", oldResult.toString(), blackGreyObj.toString());
                            throw new SQLException("黑灰名单新增发现其他类别BlackType, oldResult:"+oldResult.getBlackType()+", blackGrey:"+blackGreyObj.getBlackType());
                        }

                        insertdetails = new BlackGreyListDetails();
                        insertdetails.setRId(oldResult.getRId());
                        insertdetails.setName(oldResult.getName());
                        insertdetails.setPhoneNo(oldResult.getPhoneNo());
                        insertdetails.setIdNo(oldResult.getIdNo());
                        insertdetails.setType(blackGreyObj.getType());
                        insertdetails.setReasonCode(blackGreyObj.getJoinBlackReason());
                        insertdetails.setMaxOverdueDays(blackGreyObj.getMaxOverdueDays());
                        insertdetails.setTotalOverdueDays(blackGreyObj.getTotalOverdueDays());
                        insertdetails.setStatus(details_status);
                        insertdetails.setRemark(blackGreyObj.getRemark());
                        insertdetails.setCreatedAt(blackGreyObj.getCreatedAt());
                        insertdetails.setUpdatedAt(blackGreyObj.getUpdatedAt());

                       log.info("黑灰名单增加结束-结果表修改: {} , 明细表插入: {} ,  明细表修改: {} , blackGreyObj : {} ", updateResult.toString(), insertdetails.toString(), deleteDetails, blackGreyObj.toString());
                    }

                }catch (Exception e){
                    log.error("黑灰名单增加筛选结果异常, blackGreyObj : {}", blackGreyObj.toString(), e);
                    insertResult = null; updateResult = null; insertdetails = null; deleteDetails = null;
                    continue;
                }

                if(deleteDetails!=null){
                    StringBuffer sql_buff = new StringBuffer("UPDATE black_grey_list_details set ");
                    sql_buff.append(" status=").append(deleteDetails.getStatus()).append(", ");
                    sql_buff.append(" updated_at=").append(getValue(deleteDetails.getUpdatedAt().toString()));
                    sql_buff.append(" where ");
                    sql_buff.append(" r_id=").append(getValue(deleteDetails.getRId()));
                    sql_buff.append("AND status=0 ");
                    // 防止把当前insert的这一条status也修改了
                    if(insertdetails!=null){
                        sql_buff.append(" AND type!=").append(getValue(insertdetails.getType()));
                    }
                    sql_buff.append(";");
                    // 批处理多条sql操作
                    statement.addBatch(sql_buff.toString());
                }
                if(updateResult!=null){
                    StringBuffer sql_buff = new StringBuffer("UPDATE black_grey_list_result set ");
                    sql_buff.append(" black_type=").append(getValue(updateResult.getBlackType())).append(", ");
                    sql_buff.append(" types=").append(getValue(updateResult.getTypes())).append(", ");
                    sql_buff.append(" reasons=").append(getValue(updateResult.getReasons())).append(", ");
                    sql_buff.append(" updated_at=").append(getValue(updateResult.getUpdatedAt().toString()));
                    sql_buff.append(" where ");
                    sql_buff.append(" r_id=").append(getValue(updateResult.getRId()));
                    sql_buff.append(";");
                    // 批处理多条sql操作
                    statement.addBatch(sql_buff.toString());
                }
                if(insertResult!=null){
                    StringBuffer sql_buff = new StringBuffer("insert ignore into black_grey_list_result (`r_id`, `uuid`, `name`, `phone_no`, `id_no`, `phone_no_md5`, `id_no_md5`, `black_type`, `types`, `reasons`, `created_at`, `updated_at`) ");
                    sql_buff.append(" values (");
                    sql_buff.append(getValue(insertResult.getRId())).append(", ");
                    sql_buff.append(getValue(insertResult.getUuid())).append(", ");
                    sql_buff.append(getValue(insertResult.getName())).append(", ");
                    sql_buff.append(getValue(insertResult.getPhoneNo())).append(", ");
                    sql_buff.append(getValue(insertResult.getIdNo())).append(", ");
                    sql_buff.append(getValue(insertResult.getPhoneNoMd5())).append(", ");
                    sql_buff.append(getValue(insertResult.getIdNoMd5())).append(", ");
                    sql_buff.append(getValue(insertResult.getBlackType())).append(", ");
                    sql_buff.append(getValue(insertResult.getTypes())).append(", ");
                    sql_buff.append(getValue(insertResult.getReasons())).append(", ");
                    sql_buff.append(getValue(insertResult.getCreatedAt().toString())).append(", ");
                    sql_buff.append(getValue(insertResult.getUpdatedAt().toString()));
                    sql_buff.append(") ;");
                    statement.addBatch(sql_buff.toString());
                }
                if(insertdetails!=null){
                    StringBuffer sql_buff = new StringBuffer("insert ignore into black_grey_list_details (`r_id`, `name`, `phone_no`, `id_no`, `type`, `reason_code`, `max_overdue_days`, `total_overdue_days`, `status`, `remark`, `created_at`, `updated_at`) ");
                    sql_buff.append(" values (");
                    sql_buff.append(getValue(insertdetails.getRId())).append(", ");
                    sql_buff.append(getValue(insertdetails.getName())).append(", ");
                    sql_buff.append(getValue(insertdetails.getPhoneNo())).append(", ");
                    sql_buff.append(getValue(insertdetails.getIdNo())).append(", ");
                    sql_buff.append(getValue(insertdetails.getType())).append(", ");
                    sql_buff.append(getValue(insertdetails.getReasonCode())).append(", ");
                    sql_buff.append(getValue(insertdetails.getMaxOverdueDays())).append(", ");
                    sql_buff.append(getValue(insertdetails.getTotalOverdueDays())).append(", ");
                    sql_buff.append(insertdetails.getStatus()).append(", ");
                    sql_buff.append(getValue(insertdetails.getRemark())).append(", ");
                    sql_buff.append(getValue(insertdetails.getCreatedAt().toString())).append(", ");
                    sql_buff.append(getValue(insertdetails.getUpdatedAt().toString()));
                    sql_buff.append(") ;");
                    // 批处理多条sql操作
                    statement.addBatch(sql_buff.toString());
                }

                // 关闭自动提交
                conn.setAutoCommit(false);
                try {
                    // 提交批处理
                    statement.executeBatch();
                    // 若批处理无异常，则准备手动commit
                    conn.commit();
                    atomicInteger.getAndIncrement();
                    statement.clearBatch();
                } catch (Exception e) {
                    log.error("黑灰名单增加数据提交异常, blackGreyObj: {} , insertResult: {} , insertdetails: {} , updateResult: {} , updatedetails: {} ",
                            blackGreyObj.toString(), insertResult!=null? insertResult.toString(): null, insertdetails!=null? insertdetails.toString(): null, updateResult!=null? updateResult.toString(): null, deleteDetails!=null? deleteDetails.toString(): null, e);
                    // 批处理抛异常，则rollback
                    try {
                        conn.rollback();
                    } catch (SQLException ex) {
                        ex.printStackTrace();
                        log.error("黑灰名单增加数据回滚异常, blackGreyObj: {} ", blackGreyObj.toString(),e);
                    }
                }
            }

        }catch (Exception e){
            log.error("黑灰名单增加数据异常", e);
        }finally {
            // 恢复到原本的自动提交状态
            if(ac!=null){
                conn.setAutoCommit(ac);
            }
            if (statement != null) {
                try {
                    statement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return atomicInteger.get();
    }


    private String getValue(String value){
        if(value==null){
            return null;
        }else{
            return "'"+value+"'";
        }
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 现金分期，每日逾期15+用户 每日执行导入新的黑名单表 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 11:08 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 11:08 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Override
    public String importXianJinDaiBlackGreyList() {
        Stopwatch queryStopwatch = Stopwatch.createStarted();
        List<TmpBlackGreyList> xjdBlackGreyList = xyqbJdbcTemplate.query(ConstantBlackGrey.SQL.XYQB_QUERY_XianJinDai_15DAY, new BeanPropertyRowMapper<>(TmpBlackGreyList.class));
        log.info("每天执行-现金分期15+逾期用户黑名单-查询结束, listSize: {} , 耗时: {} ", xjdBlackGreyList.size(), queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        Stopwatch checkStopwatch = Stopwatch.createStarted();
        List<TmpBlackGreyList> newIncreasedList = new ArrayList<>();
        AtomicInteger details_haveCount = new AtomicInteger();
        int saveOkCount = 0;
        TmpBlackGreyList blackGreyVo = null;
        BlackGreyListQueryVo queryParams = null;
        for (int i = 0; i < xjdBlackGreyList.size(); i++) {

            try {
                blackGreyVo = xjdBlackGreyList.get(i);
                queryParams = BlackGreyListQueryVo.builder().name(blackGreyVo.getName()).idNo(blackGreyVo.getIdNo()).phoneNo(blackGreyVo.getPhoneNo())
                        .type(blackGreyVo.getType()).status(0).build();

                //List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryParams);
                List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetailsBy3YS(queryParams);

                if(detailsList!=null && detailsList.size()>0){
                    details_haveCount.incrementAndGet();
                }else {
                    newIncreasedList.add(blackGreyVo);
                }
            }catch (Exception e){
                log.error("每天执行-现金分期15+逾期用户黑名单-检测明细表是否存在异常, queryParams: {} ", JSON.toJSONString(queryParams), e);
            }
        }
        log.info("每天执行-现金分期15+逾期用户黑名单-检测结束, listSize: {} , details_haveCount: {} , newIncreasedList: {} , 耗时: {} ", xjdBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), checkStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        Stopwatch saveStopwatch = Stopwatch.createStarted();
        if(newIncreasedList!=null && newIncreasedList.size()> 0){
            try {
                saveOkCount  = this.saveBlackGreyListByJdbc(newIncreasedList);
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        log.info("每天执行-现金分期15+逾期用户黑名单-插入结束, listSize: {} , details_haveCount: {} , newIncreasedList: {} , saveOkCount: {} , 耗时: {} ", xjdBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), saveOkCount, saveStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        String resMsgTemp = "新增黑名单(现金分期15+逾期) 查询 %d条, 明细表已存在 %d条, 需要插入 %d条, 插入成功 %d条;";
        return String.format(resMsgTemp, xjdBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), saveOkCount);
    }

    @Override
    public String importVccBlackGreyList() {
        Stopwatch queryStopwatch1 = Stopwatch.createStarted();
        List<Integer> vccUserIdList = null;
        try{
            vccUserIdList = acsdbJdbcTemplate.queryForList(ConstantBlackGrey.SQL.ACSDB_QUERY_VCC_15DAY, Integer.class);
        }catch (Exception e){
            log.error("每天执行-vcc逾期15+用户黑名单-查询acsdb用户userId异常!", e);
        }
        log.info("每天执行-vcc逾期15+用户黑名单-查询acsdb用户userId结束, vccUserIdList: {} , 耗时: {} ", (vccUserIdList!=null ? vccUserIdList.size(): "null"), queryStopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));

        Stopwatch queryStopwatch2 = Stopwatch.createStarted();
        List<TmpBlackGreyList> vccBlackGreyList = new ArrayList<TmpBlackGreyList>();

        if(vccUserIdList!=null && vccUserIdList.size()>0){
            int inCount=0;
            StringBuffer userIds = new StringBuffer();
            for(int i=0; i<vccUserIdList.size(); i++){

                if(userIds.length()==0){
                    userIds.append(""+vccUserIdList.get(i));
                }else {
                    userIds.append(",").append(""+vccUserIdList.get(i));
                }
                inCount++;

                if(inCount>=1000){
                    try{
                        String sql = ConstantBlackGrey.SQL.XYQBUSER_QUERY_VCC_15DAY;
                        sql = sql.replace("##IN_USER_ID##",userIds.toString());
                        List<TmpBlackGreyList> tmpVccList = xyqbUserJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(TmpBlackGreyList.class));
                        if(tmpVccList!=null && tmpVccList.size()>0){
                            vccBlackGreyList.addAll(tmpVccList);
                        }
                    }catch (Exception e){
                        log.error("每天执行-vcc逾期15+用户黑名单-查询acsdb用户userId异常, IN_USER_ID: {} ", userIds.toString(), e);
                    }finally {
                        inCount = 0;
                        userIds = new StringBuffer();
                    }
                }
            }
            if(inCount>0 && userIds.length()>0){
                try{
                    String sql = ConstantBlackGrey.SQL.XYQBUSER_QUERY_VCC_15DAY;
                    sql = sql.replace("##IN_USER_ID##",userIds.toString());
                    List<TmpBlackGreyList> tmpVccList = xyqbUserJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(TmpBlackGreyList.class));
                    if(tmpVccList!=null && tmpVccList.size()>0){
                        vccBlackGreyList.addAll(tmpVccList);
                    }
                }catch (Exception e){
                    log.error("每天执行-vcc逾期15+用户黑名单-查询acsdb用户userId异常, IN_USER_ID: {} ", userIds.toString(), e);
                }
            }
        }
        log.info("每天执行-vcc逾期15+用户黑名单-查询Vcc用户结束, vccUserIdList: {} , vccBlackGreyList: {} , 耗时: {} ", (vccUserIdList!=null ? vccUserIdList.size(): "null"), (vccUserIdList!=null ? vccUserIdList.size(): "null"), (vccBlackGreyList!=null ? vccBlackGreyList.size(): "null"), queryStopwatch2.stop().elapsed(TimeUnit.MILLISECONDS));


        List<TmpBlackGreyList> newIncreasedList = new ArrayList<>();
        Stopwatch checkStopwatch = Stopwatch.createStarted();
        AtomicInteger details_haveCount = new AtomicInteger();
        int saveOkCount = 0;
        TmpBlackGreyList blackGreyVo = null;
        BlackGreyListQueryVo queryParams = null;
        for (int i = 0; i < vccBlackGreyList.size(); i++) {

            try {
                blackGreyVo = vccBlackGreyList.get(i);
                queryParams = BlackGreyListQueryVo.builder().name(blackGreyVo.getName()).idNo(blackGreyVo.getIdNo()).phoneNo(blackGreyVo.getPhoneNo())
                        .type(blackGreyVo.getType()).status(0).build();

                //List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryParams);
                List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetailsBy3YS(queryParams);
                if(detailsList!=null && detailsList.size()>0){
                    details_haveCount.incrementAndGet();
                }else {
                    newIncreasedList.add(blackGreyVo);
                }
            }catch (Exception e){
                log.error("每天执行-vcc逾期15+用户黑名单-检测明细表是否存在异常, queryParams: {} ", JSON.toJSONString(queryParams), e);
            }
        }
        log.info("每天执行-vcc逾期15+用户黑名单-检测结束, vccBlackGreyList: {} , details_haveCount: {} , newIncreasedList: {} , 耗时: {} ", vccBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), checkStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        Stopwatch saveStopwatch = Stopwatch.createStarted();
        if(newIncreasedList!=null && newIncreasedList.size()> 0){
            try {
                saveOkCount  = this.saveBlackGreyListByJdbc(newIncreasedList);
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        log.info("每天执行-vcc逾期15+用户黑名单-插入结束, vccBlackGreyList: {} , details_haveCount: {} , newIncreasedList: {} , saveOkCount: {} , 耗时: {} ", vccBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), saveOkCount, saveStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        String resMsgTemp = "新增黑名单(vcc逾期15+逾期) 查询 %d条, 明细表已存在 %d条, 需要插入 %d条, 插入成功 %d条;";
        return String.format(resMsgTemp, vccBlackGreyList.size(), details_haveCount.get(), newIncreasedList.size(), saveOkCount);
    }

    /*@Override
    public String removeBlackToGreyList() {
        long startTime = System.currentTimeMillis();
        List<BlackGreyListResult> blackListResults = new ArrayList<>();
        int pageSize = 2000;
        int offset = 0;
        String sql_tmp = ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_BY_LIMIT;
        sql_tmp = sql_tmp.replace("r.*"," r.r_id, r.uuid, r.black_type, r.types, r.reasons ");
        //查询黑名单集合
        while (true) {
            try{
                List<BlackGreyListResult> tmpQueryList = blackListJdbcTemplate.query(sql_tmp, new Object[]{offset, pageSize}, new RowMapper<BlackGreyListResult>() {
                    @Override
                    public BlackGreyListResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                        BlackGreyListResult bean = new BlackGreyListResult();
                        bean.setRId(rs.getString("r_id"));
                        bean.setUuid(rs.getString("uuid"));
                        //bean.setName(rs.getString("name"));
                        //bean.setPhoneNo(rs.getString("phone_no"));
                        //bean.setIdNo(rs.getString("id_no"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setTypes(rs.getString("types"));
                        bean.setReasons(rs.getString("reasons"));
                        //bean.setCreatedAt(rs.getTimestamp("created_at"));
                        //bean.setUpdatedAt(rs.getTimestamp("updated_at"));
                        return bean;
                    }
                });
                if(tmpQueryList!=null && tmpQueryList.size() >0){
                    blackListResults.addAll(tmpQueryList);
                }else {
                    break;
                }
            }catch (Exception e){
                log.error("黑转灰-查询黑灰名单结果表异常, offset: {} , pageSize: {} ", offset, pageSize, e);
            }finally {
                offset=offset + pageSize;
            }
        }

        log.info("黑转灰-查询黑灰名单结果表结束, list大小: {} , 耗时: {} ", blackListResults!=null?blackListResults.size():"null", (System.currentTimeMillis()-startTime));

        //批量 逾期已还清黑名单>>转灰名单
        if(blackListResults!=null && blackListResults.size() >0 ){
            return blackToGreyListParallel.runMain(blackListResults);
        }
        return null;
    }*/

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 逾期已还清黑名单>>转灰名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 21:12 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 21:12 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Override
    public String removeBlackToGreyList() {
        long startTime = System.currentTimeMillis();

        Integer maxId = 0;
        try {
            maxId = blackListJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_MAX_ID, Integer.class);
        }catch (EmptyResultDataAccessException e){
            log.error("查询结果表-黑名单最大Id异常, sql: {} ", ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_MAX_ID, e);
        }
        if(maxId==null || maxId.intValue() <=0){
            return "查询结果表-黑名单最大Id异常";
        }

        int totalPage = maxId / pageSize;
        if((maxId % pageSize)!=0){
            totalPage+=1;
        }

        String sql_query_tmp = ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_BY_LIMIT_ID;
        sql_query_tmp = sql_query_tmp.replace("##r.*##", " r.r_id, r.uuid, r.black_type, r.types, r.reasons ");

        List<BlackGreyListResult> blackListResults = new ArrayList<>();
        int count_black = 0, count_type_11=0;
        int startId = 0,endId = 0;
        for (int page = 1; page <= totalPage; page++) {
            long thisPageStart = System.currentTimeMillis();
            startId = (page-1) * pageSize;
            endId = startId + pageSize;
            List<BlackGreyListResult> tmpQueryList = null;
            try{
                tmpQueryList = blackListJdbcTemplate.query(sql_query_tmp, new Object[]{startId, endId}, new RowMapper<BlackGreyListResult>() {
                    @Override
                    public BlackGreyListResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                        BlackGreyListResult bean = new BlackGreyListResult();
                        bean.setRId(rs.getString("r_id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setTypes(rs.getString("types"));
                        bean.setReasons(rs.getString("reasons"));
                        return bean;
                    }
                });

                if(tmpQueryList!=null && tmpQueryList.size() >0){
                    count_black+=tmpQueryList.size();
                    //blackListResults.addAll(tmpQueryList);

                    for (BlackGreyListResult result: tmpQueryList){
                        String types = ","+result.getTypes().trim()+",";
                        if(!types.contains(",11,")){
                            blackListResults.add(result);
                        }else {
                            count_type_11++;
                        }
                    }
                }
            }catch (Exception e){
                e.printStackTrace();
                log.error("查询结果表-黑名单列表异常, totalPage: {} , page: {} , startId: {} , endId: {} , 耗时: {} ", totalPage, page, startId, endId, (System.currentTimeMillis()-thisPageStart), e);
            }/*finally {
                log.error("查询结果表-黑名单列表结束, totalPage: {} , page: {} , startId: {} , endId: {} , 大小: {} , 耗时: {} ", totalPage, page, startId, endId, tmpQueryList!=null?tmpQueryList.size():"null", (System.currentTimeMillis()-thisPageStart));
            }*/
        }

        log.info("黑转灰-查询黑灰名单结果表结束, 查询大小: {} , type11大小: {} , list大小: {} , 总查询耗时: {} ", count_black, count_type_11, blackListResults!=null?blackListResults.size():"null", (System.currentTimeMillis()-startTime));

        //批量 逾期已还清黑名单>>转灰名单
        if(blackListResults!=null && blackListResults.size() >0 ){
            return blackToGreyListParallel.runMain(blackListResults);
        }
        return null;
    }


    /*@Override
    public String updateBlackListOverdueDay() {
        long startTime = System.currentTimeMillis();
        List<BlackGreyListResult> blackListResults = new ArrayList<>();
        int pageSize = 2000;
        int offset = 0;
        String sql_tmp = ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_BY_LIMIT;
        sql_tmp = sql_tmp.replace("r.*","r.r_id, r.uuid, r.black_type");
        //查询黑名单集合
        while (true) {
            try{
                List<BlackGreyListResult> tmpQueryList = blackListJdbcTemplate.query(sql_tmp, new Object[]{offset, pageSize}, new RowMapper<BlackGreyListResult>() {
                    @Override
                    public BlackGreyListResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                        BlackGreyListResult bean = new BlackGreyListResult();
                        bean.setRId(rs.getString("r_id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setBlackType(rs.getString("black_type"));
                        return bean;
                    }
                });
                if(tmpQueryList!=null && tmpQueryList.size() >0){
                    blackListResults.addAll(tmpQueryList);
                }else {
                    break;
                }
            }catch (Exception e){
                log.error("更新黑名单逾期天数-查询黑灰名单结果表异常, offset: {} , pageSize: {} ", offset, pageSize, e);
            }finally {
                offset=offset + pageSize;
            }
        }
        log.info("更新黑名单逾期天数-查询黑灰名单结果表结束, list大小: {} , 耗时: {} ", blackListResults!=null?blackListResults.size():"null", (System.currentTimeMillis()-startTime));

        //批量更新黑名单>>逾期天数
        if(blackListResults!=null && blackListResults.size() >0 ){
            return updateBlackListOverdueDayParallel.runMain(blackListResults);
        }
        return null;
    }*/

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 更新黑名单>>逾期天数 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 21:13 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 21:13 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Override
    public String updateBlackListOverdueDay() {
        long startTime = System.currentTimeMillis();

        Integer maxId = 0;
        try {
            maxId = blackListJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_MAX_ID, Integer.class);
        }catch (EmptyResultDataAccessException e){
            log.error("查询结果表-黑名单最大Id异常, sql: {} ", ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_MAX_ID, e);
        }
        if(maxId==null || maxId.intValue() <=0){
            return "查询结果表-黑名单最大Id异常";
        }

        int totalPage = maxId / pageSize;
        if((maxId % pageSize)!=0){
            totalPage+=1;
        }

        String sql_query_tmp = ConstantBlackGrey.SQL.BL_QUERY_BLACKLIST_RESULT_BY_LIMIT_ID;
        sql_query_tmp = sql_query_tmp.replace("##r.*##","r.r_id, r.uuid, r.black_type");

        List<BlackGreyListResult> blackListResults = new ArrayList<>();
        int startId = 0,endId = 0;
        for (int page = 1; page <= totalPage; page++) {
            long thisPageStart = System.currentTimeMillis();
            startId = (page-1) * pageSize;
            endId = startId + pageSize;
            List<BlackGreyListResult> tmpQueryList = null;
            try{
                tmpQueryList = blackListJdbcTemplate.query(sql_query_tmp, new Object[]{startId, endId}, new RowMapper<BlackGreyListResult>() {
                    @Override
                    public BlackGreyListResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                        BlackGreyListResult bean = new BlackGreyListResult();
                        bean.setRId(rs.getString("r_id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setBlackType(rs.getString("black_type"));
                        return bean;
                    }
                });

                if(tmpQueryList!=null && tmpQueryList.size() >0){
                    blackListResults.addAll(tmpQueryList);
                }
            }catch (Exception e){
                e.printStackTrace();
                log.error("查询结果表-黑名单列表异常, totalPage: {} , page: {} , startId: {} , endId: {} , 耗时: {} ", totalPage, page, startId, endId, (System.currentTimeMillis()-thisPageStart), e);
            }/*finally {
                log.error("查询结果表-黑名单列表结束, totalPage: {} , page: {} , startId: {} , endId: {} , 大小: {} , 耗时: {} ", totalPage, page, startId, endId, tmpQueryList!=null?tmpQueryList.size():"null", (System.currentTimeMillis()-thisPageStart));
            }*/
        }

        log.info("更新黑名单逾期天数-查询黑灰名单结果表结束, list大小: {} , 总查询耗时: {} ", blackListResults!=null?blackListResults.size():"null", (System.currentTimeMillis()-startTime));

        //批量更新黑名单>>逾期天数
        if(blackListResults!=null && blackListResults.size() >0 ){
            return updateBlackListOverdueDayParallel.runUpdate(blackListResults);
        }
        return null;
    }

}
