package cn.quantgroup.qgblservice.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {

    private static ThreadLocal<MessageDigest> messageDigestHolder = new ThreadLocal();

    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public MD5Util() {
    }

    public static String getMd5(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte b[] = md.digest();

            int i;

            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0)
                    i += 256;
                if (i < 16)
                    buf.append("0");
                buf.append(Integer.toHexString(i));
            }
            // 32位加密
            return buf.toString();
            // 16位的加密
            // return buf.toString().substring(8, 24);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static String getMD5Format(String data) {
        try {
            MessageDigest e = (MessageDigest) messageDigestHolder.get();
            if (e == null) {
                e = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(e);
            }

            e.update(data.getBytes());
            byte[] b = e.digest();
            String digestHexStr = "";

            for (int i = 0; i < 16; ++i) {
                digestHexStr = digestHexStr + byteHEX(b[i]);
            }

            return digestHexStr;
        } catch (Exception var5) {
            System.out.println(var5);
            return null;
        }
    }

    public static String getMD5Format(byte[] data) {
        try {
            MessageDigest e = (MessageDigest) messageDigestHolder.get();
            if (e == null) {
                e = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(e);
            }

            e.update(data);
            byte[] b = e.digest();
            String digestHexStr = "";

            for (int i = 0; i < 16; ++i) {
                digestHexStr = digestHexStr + byteHEX(b[i]);
            }

            return digestHexStr;
        } catch (Exception var5) {
            return null;
        }
    }

    private static String byteHEX(byte ib) {
        char[] ob = new char[]{hexDigits[ib >>> 4 & 15], hexDigits[ib & 15]};
        String s = new String(ob);
        return s;
    }

    static {
        try {
            MessageDigest e = MessageDigest.getInstance("MD5");
            messageDigestHolder.set(e);
        } catch (NoSuchAlgorithmException var1) {
            System.out.println(var1);
        }
    }
    
    public static String getMD5Digest(String msg) {
        try {
            MessageDigest md5 = (MessageDigest) messageDigestHolder.get();
            if (md5 == null) {
            	md5 = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(md5);
            }
            byte[] byteArray=null;
            byteArray=msg.getBytes(); 
            byte[] md5Bytes=md5.digest(byteArray);
            StringBuffer hexValue=new StringBuffer();
            for(int i=0; i < md5Bytes.length; i++) {
                int val=((int)md5Bytes[i]) & 0xff;
                if(val < 16)
                    hexValue.append("0");
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        } catch (Exception var5) {
            System.out.println(var5);
            return null;
        }
    }
    
}
