package cn.quantgroup.qgblservice.utils.parallel;

import java.util.List;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 并行处理-业务执行接口 <br>
 * 参数: ListType 需并行处理的List中的泛型 <br>
 * 		ParameterType 业务处理时传入的参数类型
 * 作者：yanhui.Hao <br>
 * 时间：2020.01.15 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public interface ParallelComputingProcess<ListType, ParameterType> {

	/***
	 * 具体的业务实现在该方法中编写
	 * @param threadId 线程ID
	 * @param list 切分后的小List集合
	 * @param obj 外部传入数据，为业务实现提供数据支持
	 */
	public void process(int threadId, List<ListType> list, ParameterType obj);
}
