package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.xyqbuser.XyqbUser;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb.BlackListQueryTidbMapper;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.service.IBlackListUpdateThreeEleService;
import cn.quantgroup.qgblservice.utils.ExcelUtil;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-05 16:43
 */
@Slf4j
@Service
public class BlackListManagerServiceImpl implements IBlackListManagerService {

    @Autowired
    private BlackListQueryTidbMapper blackListQueryTidbMapper;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private IBlackListUpdateThreeEleService iBlackListUpdateThreeEleService;
    @Autowired
    private BlackListQueryTidbMapper blackListQueryMapper;

    @Autowired
    private ExcelUtil excelUtil;
    @Async
    @Override
    public void blackListRealTimeManagerByDay() {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = new ArrayList<>();
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<BlackListQueryTidbVo0> userLoanOverdue15DaysLists = xyqbJdbcTemplate.query(Constant.SQL.XYQB_QUERY_USER_LOAN_OVERDUE_15DAY_SQL, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
        log.info("每天执行查询15+逾期用户黑名单, resultSize: {} , 耗时: {} ", userLoanOverdue15DaysLists.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        for (int i = 0; i < userLoanOverdue15DaysLists.size(); i++) {

            BlackListQueryTidbVo0 blackListQueryTidbVo0 = userLoanOverdue15DaysLists.get(i);

            List<XyqbUser> queryXyqbUserInfos = xyqbUserJdbcTemplate.query(String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_INFO_SQL, blackListQueryTidbVo0.getId()), new BeanPropertyRowMapper<>(XyqbUser.class));

            if (CollectionUtils.isNotEmpty(queryXyqbUserInfos)) {

                XyqbUser xyqbUser = queryXyqbUserInfos.get(0);
                blackListQueryTidbVo0.setId(null);
                blackListQueryTidbVo0.setPhoneNo(xyqbUser.getPhoneNo());
                blackListQueryTidbVo0.setName(xyqbUser.getName());
                blackListQueryTidbVo0.setIdNo(xyqbUser.getIdNo());
                blackListQueryTidbVo0.setUuid(xyqbUser.getUuid());
                blackListQueryTidbVo0s.add(blackListQueryTidbVo0);

            }

        }


        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatchInsert = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.blackListImportBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_IDCARDS_MONTH);
            log.info("每日定时导入近5天逾期15+的用户黑名单完成, 查询大小: {} , 入库大小: {} , 耗时: {} ", userLoanOverdue15DaysLists.size(), batchExecuteResult, stopwatchInsert.stop().elapsed(TimeUnit.MILLISECONDS));
            iBlackListUpdateThreeEleService.updateOrNoThreeElementsById(blackListQueryTidbVo0s, Constant.PARAM.BLACK_LIST_INNER_PART);
        }
    }

    /**
     * @param sourcePath 读取的源文件
     * @return
     */
    @Async
    @Override
    public GlobalResponse manualImportBlackList(String sourcePath) {
        String insertBlackListSql = "INSERT INTO `black_list_new` (`uuid`, `name`, `phone_no`, `id_no`, `major_type`, `type`, `black_level`, `join_black_reason`, `phone_no_md5`, `id_no_md5`) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s');";
        String updateBlackListSql = "UPDATE black_list_new SET major_type = '%s', type = '%s', black_level = '%s', join_black_reason = '%s' WHERE id = '%s';";
        List<String> insertList = new ArrayList<>();
        List<String> updateList = new ArrayList<>();

        List<String> errorInsertList = new ArrayList<>();
        List<String> errorUpdateList = new ArrayList<>();
        //uuid@@@@@@name@@@@@@phone_no@@@@@@id_no@@@@@@major_type@@@@@@type@@@@@@black_level@@@@@@join_black_reason
        try {
            List<String> list = FileUtils.readLines(new File(sourcePath), "utf-8");
//            `name`,`phone_no`,`id_no`,`type`  唯一索引
            for (int i = 0; i < list.size(); i++) {
                String blackListRecord = list.get(i);
                String[] split = blackListRecord.split("@@@@@@");
                String sql = "SELECT * FROM black_list_new WHERE name = '%s' AND phone_no = '%s' AND id_no = '%s' AND type = '%s';";
                String format = String.format(sql, split[1], split[2], split[3], split[5]);
                List<BlackListQueryTidbVo0> queryResult = blackListJdbcTemplate.query(format, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                if (CollectionUtils.isNotEmpty(queryResult)) { //为空的直接插入，说明是新黑名单用户
                    BlackListQueryTidbVo0 blackListQueryTidbVo0 = queryResult.get(0);
                    String blackLevel = blackListQueryTidbVo0.getBlackLevel();
                    if (StringUtils.isBlank(blackLevel) || !blackLevel.startsWith("A")) { // 全字段更新 包括创建黑名单时间和更新时间？还是才用原来的时间？我理解应该更新updated_at时间
                        String updateSql = String.format(updateBlackListSql, split[4], split[5], split[6], split[7], blackListQueryTidbVo0.getId());
                        updateList.add(updateSql);
                        log.info("历史黑名单导入发现已存在, 并且不是内部黑名单需要更新, id: {} , blackLevel: {} ", blackListQueryTidbVo0.getId(), blackLevel);
                    }else{
                        log.info("历史黑名单导入发现已存在, name: {} , phone_no: {} , id_no: {}, type: {} ", split[1], split[2], split[3], split[5]);
                    }
                }else{
                    String insertSql = String.format(insertBlackListSql, split[0], split[1], split[2], split[3], split[4], split[5], split[6], split[7], MD5Util.getMd5(split[2]), MD5Util.getMd5(split[3]));
                    insertList.add(insertSql);
                }
            }

            for (int i = 0; i < insertList.size(); i++) {
                String insertSql = insertList.get(i);
                try {
                    blackListJdbcTemplate.execute(insertSql);
                } catch (Exception e) {
                    errorInsertList.add(insertSql);
                    log.error("手动执行插入黑名单异常", e);
                }
            }

            for (int i = 0; i < updateList.size(); i++) {
                String updateSql = updateList.get(i);
                try {
                    blackListJdbcTemplate.update(updateSql);
                }catch(Exception e){
                    errorUpdateList.add(updateSql);
                    log.error("手动执行更新黑名单异常", e);
                }
            }

            log.info("执行完成, 插入异常: {} , 更新异常: {} , 插入条数: {} , 更新条数: {} ", errorInsertList, errorUpdateList, insertList.size(), updateList.size());
            return GlobalResponse.success("手动插入成功");

        } catch (Exception e) {
            log.error("手动导入黑名单异常", e);
        }
        return GlobalResponse.error("手动导入发生异常");
    }

    /**
     * 黑名单导入添加更新逻辑暂时先不使用该方法
     * @param startTime
     * @param endTime
     */
//    @Override
//    public Map<String,Object> importBlacklistByExcel(MultipartFile file) throws IOException {
//        Map<String,Object> result = new HashMap<>();
//        List<BlackListQueryTidbVo0> failes = new ArrayList<>();
//        Map<String,Object> errMap = new HashMap<>();
//        List<BlackListQueryTidbVo0> read = excelUtil.read(file.getOriginalFilename(), file.getInputStream(), BlackListQueryTidbVo0.class);
//        for (BlackListQueryTidbVo0 blackListQueryTidbVo0 : read) {
//            int i = blackListQueryMapper.insertIgnore(blackListQueryTidbVo0);
//            if(i<=0){
//                failes.add(blackListQueryTidbVo0);
//            }
//        }
//        errMap.put("条数",failes.size());
//        errMap.put("未导入的数据",failes);
//        result.put("总条数",read.size());
//        result.put("导入成功条数",read.size()-failes.size());
//        result.put("未导入黑名单:",errMap);
//        return result;
//    }

    @Override
    public void blackListPhoneHistoryManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.blackListImportBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONES_MONTH);
            log.info("{} - {} 手机号黑名单(month)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    @Override
    public void blackListIdCardHistoryManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.blackListImportBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_IDCARDS_MONTH);
            log.info("{} - {} 身份证号黑名单(month)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    @Override
    public void blackListPhoneManagerByDay(String startTime, String endTime) {
//        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
//
//        for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {
//
//            BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
//            List<BlackListQueryTidbVo0> blackListByPhones = blackListQueryMapper.findBlackListByPhone(BlackListQueryByThreeEleParam0.builder().phone(blackListQueryTidbVo0.getPhoneNo()).build());
//
//            updateOrNo(blackListByPhones, blackListQueryTidbVo0, Constant.BATCH_TYPE.BATCH_PHONES_DAYS);
//
//        }
//
//        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
//            Stopwatch stopwatch = Stopwatch.createStarted();
//            int batchExecuteResult = JdbcExecuters.blackListImportBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONES_DAYS);
//            log.info("{} - {} 手机号黑名单(day)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
//        }

    }

    @Override
    public void blackListIdCardManagerByDay(String startTime, String endTime) {

//        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
//
//        for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {
//
//            BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
//            List<BlackListQueryTidbVo0> blackListByIdcards = blackListQueryMapper.findBlackListByIdcard(BlackListQueryByThreeEleParam0.builder().phone(blackListQueryTidbVo0.getIdNo()).build());
//
//            updateOrNo(blackListByIdcards, blackListQueryTidbVo0, Constant.BATCH_TYPE.BATCH_IDCARDS_DAYS);
//
//        }
//
//        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
//            Stopwatch stopwatch = Stopwatch.createStarted();
//            int batchExecuteResult = JdbcExecuters.blackListImportBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_IDCARDS_DAYS);
//            log.info("{} - {} 身份证号黑名单(day)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
//        }

    }

//    public void updateOrNo(List<BlackListQueryTidbVo0> blackListByPhones, BlackListQueryTidbVo0 blackListQueryTidbVo0, String type) {
//
//        for (int j = 0; j < blackListByPhones.size(); j++) {
//
//            try {
//                BlackListQueryTidbVo0 blackListByPhone = blackListByPhones.get(j);
//                String name = blackListByPhone.getName();
//                String idNo = blackListByPhone.getIdNo();
//                String uuid = blackListByPhone.getUuid();
//                String phoneNo = blackListByPhone.getPhoneNo();
//
//                if (StringUtils.isAnyBlank(name, idNo, uuid, phoneNo)
//                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())
//                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())
//                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())
//                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())) {
//
//                    if (StringUtils.isBlank(phoneNo) && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())) {
//                        blackListByPhone.setPhoneNo(blackListQueryTidbVo0.getPhoneNo());
//                    }
//
//                    if (StringUtils.isBlank(name) && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())) {
//                        blackListByPhone.setName(blackListQueryTidbVo0.getName());
//                    }
//
//                    if (StringUtils.isBlank(idNo) && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())) {
//                        blackListByPhone.setIdNo(blackListQueryTidbVo0.getIdNo());
//                    }
//
//                    if (StringUtils.isBlank(uuid) && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())) {
//                        blackListByPhone.setUuid(blackListQueryTidbVo0.getUuid());
//                    }
//
//                    List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UNIQUE_KEY_SQL,
//                            blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo0.getType()), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
//
//                    if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
//                        blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_DISABLE_BY_RECORD_ID_SQL, blackListByPhone.getUpdatedAt(), blackListByPhone.getId()));
//                        log.info("{} 黑名单禁用", type);
//                    } else {
//                        blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_THREE_ELE_SQL, blackListByPhone.getUuid(), blackListByPhone.getName(), blackListByPhone.getPhoneNo(), blackListByPhone.getIdNo(), blackListByPhone.getId()));
//                        log.info("{} 黑名单更新缺失三要素", type);
//                    }
//
//                }
//            } catch (Exception e) {
//                log.error("{} 黑名单单条更新异常", type, e);
//            }
//
//        }
//
//    }

}
