package cn.quantgroup.qgblservice.repository.mybatis.entity.tidb;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: tmp_black_grey_list表对应实体<br>
 * 作者：yanhui.Hao <br>
 * 时间：2020.04.02 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */

public class TmpBlackGreyListRowMapper implements RowMapper<TmpBlackGreyList> {

    /**
     * Implementations must implement this method to map each row of data
     * in the ResultSet. This method should not call {@code next()} on
     * the ResultSet; it is only supposed to map values of the current row.
     *
     * @param rs     the ResultSet to map (pre-initialized for the current row)
     * @param rowNum the number of the current row
     * @return the result object for the current row
     * @throws SQLException if a SQLException is encountered getting
     *                      column values (that is, there's no need to catch SQLException)
     */
    @Override
    public TmpBlackGreyList mapRow(ResultSet rs, int rowNum) throws SQLException {
        TmpBlackGreyList bean = new TmpBlackGreyList();
        bean.setId(rs.getLong("id"));
        bean.setUuid(rs.getString("uuid"));
        bean.setName(rs.getString("name"));
        bean.setPhoneNo(rs.getString("phone_no"));
        bean.setIdNo(rs.getString("id_no"));
        bean.setBlackType(rs.getString("black_type"));
        bean.setType(rs.getString("type"));
        bean.setReasonCode(rs.getString("reason_code"));
        bean.setMaxOverdueDays(rs.getString("max_overdue_days"));
        bean.setTotalOverdueDays(rs.getString("total_overdue_days"));
        bean.setCreatedAt(rs.getTimestamp("created_at"));
        bean.setUpdatedAt(rs.getTimestamp("updated_at"));
        return bean;
    }
}
