package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListImportService;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @Author fengjunkai
 * @Date 2019-08-01 17:51
 */
@Slf4j
@Service
public class BlackListImportServiceImpl implements IBlackListImportService {

    private static String ERLY_DATE = "2015-08-01T00:00:00";
    private static String PHONE_BREAK_DATE = "2019-09-01T00:00:00";

    @Autowired
    private IBlackListManagerService iBlackListManagerService;

    /**
     * 手机关联三要素黑名单导入新表
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Async
    @Override
    public GlobalResponse blackListPhoneImport(String startTime, String endTime) {

        LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
        String phoneBreakDate = LocalDateTime.parse(PHONE_BREAK_DATE).format(DateTimeFormatter.ISO_DATE);

        for (int i = 0; i < 100; i++) {
            try {

                endTime = erlyDate.plusMonths(i + 1).format(DateTimeFormatter.ISO_DATE);
                startTime = erlyDate.plusMonths(i).format(DateTimeFormatter.ISO_DATE);

                if (phoneBreakDate.equalsIgnoreCase(startTime)) {
                    break;
                }

                iBlackListManagerService.blackListPhoneHistoryManagerByMonth(startTime, endTime);

            } catch (Exception e) {
                log.error("手机号整合导入黑名单新表异常, startTime: {} , endTime: {} ", startTime, endTime, e);
            }
        }

        log.info("手机号整合导入新表完毕");
        return GlobalResponse.success("手机号关联三要素导入黑名单新表完毕");

    }

    /**
     * 身份证关联三要素导入黑名单新表
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Async
    @Override
    public GlobalResponse blackListIdCardImport(String startTime, String endTime) {

        LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
        String phoneBreakDate = LocalDateTime.parse(PHONE_BREAK_DATE).format(DateTimeFormatter.ISO_DATE);

        for (int i = 0; i < 100; i++) {

            try {

                startTime = erlyDate.plusMonths(i).format(DateTimeFormatter.ISO_DATE);
                endTime = erlyDate.plusMonths(i + 1).format(DateTimeFormatter.ISO_DATE);

                if (phoneBreakDate.equalsIgnoreCase(startTime)) {
                    break;
                }

                iBlackListManagerService.blackListIdCardHistoryManagerByMonth(startTime, endTime);

            } catch (Exception e) {
                log.error("身份证号整合导入黑名单新表异常, startTime: {} , endTime: {} ", startTime, endTime, e);
            }

        }

        log.info("身份证号整合导入新表完毕");
        return GlobalResponse.success("身份证号关联三要素导入黑名单新表完毕");

    }


}
