package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb.BlackListQueryTidbMapper;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListImportManagerService;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-01 17:51
 */
@Slf4j
@Service
public class BlackListImportManagerServiceImpl implements IBlackListImportManagerService {

    private static String ERLY_DATE = "2015-08-01T00:00:00";
    private static String PHONE_BREAK_DATE = "2019-09-01T00:00:00";
    private static String IDCARD_BREAK_DATE = "2019-10-01T00:00:00";

    @Autowired
    private BlackListQueryTidbMapper blackListQueryTidbMapper;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    public static void main(String[] args) {
        LocalDateTime localDateTime = LocalDateTime.parse(PHONE_BREAK_DATE);
        System.out.println();
    }

    /**
     * 手机关联三要素黑名单导入新表
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public GlobalResponse blackListPhoneImport(String startTime, String endTime) {

        LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
        String phoneBreakDate = LocalDateTime.parse(PHONE_BREAK_DATE).format(DateTimeFormatter.ISO_DATE);

        for (int i = 0; i < 100; i++) {

            try {
                startTime = erlyDate.plusMonths(i).format(DateTimeFormatter.ISO_DATE);
                endTime = erlyDate.plusMonths(i + 1).format(DateTimeFormatter.ISO_DATE);

                if (phoneBreakDate.equalsIgnoreCase(startTime)) {
                    break;
                }

                Stopwatch queryPhoneStopwatch = Stopwatch.createStarted();
                List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
                log.info("手机黑名单查询 {} --- {} 结果size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), queryPhoneStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Stopwatch executeInsertPhoneStopwatch = Stopwatch.createStarted();
                JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_PHONE_LIST_SQL, blackListJdbcTemplate);
                log.info("手机黑名单入库 {} --- {} 入库size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), executeInsertPhoneStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

            } catch (Exception e) {
                log.error("手机号黑名单导入发生异常, startTime: {} , endTime: {} ", startTime, endTime);
            }

        }

        log.info("手机号整合导入新表完毕");
        return GlobalResponse.success("手机号关联三要素导入黑名单新表完毕");

    }

    /**
     * 身份证关联三要素导入黑名单新表
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public GlobalResponse blackListIdCardImport(String startTime, String endTime) {

        LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
        String idCardBreakDate = LocalDateTime.parse(IDCARD_BREAK_DATE).format(DateTimeFormatter.ISO_DATE);

        for (int i = 0; i < 100; i++) {

            try {

                endTime = erlyDate.plusMonths(i + 1).format(DateTimeFormatter.ISO_DATE);
                startTime = erlyDate.plusMonths(i).format(DateTimeFormatter.ISO_DATE);

                Stopwatch queryStopwatch = Stopwatch.createStarted();

                if (idCardBreakDate.equalsIgnoreCase(startTime)) {
                    break;
                }

                List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
                log.info("身份证黑名单查询 {} --- {} 结果size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));


                Stopwatch executeInsertStopwatch = Stopwatch.createStarted();
                JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_PHONE_LIST_SQL, blackListJdbcTemplate);
                log.info("身份证黑名单入库 {} --- {} 入库size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), executeInsertStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

            } catch (Exception e) {
                log.error("身份证黑名单导入发生异常, startTime: {} , endTime: {} ", startTime, endTime);
            }

        }

        log.info("身份证黑名单整合导入新表完毕");
        return GlobalResponse.success("身份真关联三要素导入黑名单新表完毕");

    }


}
