package cn.quantgroup.qgblservice.config.acsdb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: vcc线上acsdb库（如果线下访问需要重新申请脱敏库） <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 16:23 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Import({AcsdbProperties.class})
@MapperScan(basePackages = AcsdbSourceConfig.PACKAGE, sqlSessionFactoryRef = "acsdbSqlSessionFactory")
@Configuration
public class AcsdbSourceConfig {

    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.acsdb";

    @Value("${acsdb.mapper-locations}")
    private String mapperLocations;

    @Value("${acsdb.type-aliases-package}")
    private String typeAliasesPackage;

    @Value("${acsdb.config-location}")
    private String configLocation;

    @Autowired
    private AcsdbProperties acsdbProperties;

    @Bean(name = "acsdbDataSource")
    public DataSource acsdbDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(acsdbProperties.getJdbcUrl());
        config.setPassword(acsdbProperties.getPassword());
        config.setMaximumPoolSize(acsdbProperties.getMaxPoolSize());
        config.setUsername(acsdbProperties.getUsername());
        config.setMinimumIdle(acsdbProperties.getMinPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        return new HikariDataSource(config);
    }

    @Bean(name = "acsdbJdbcTemplate")
    public JdbcTemplate acsdbJdbcTemplate(@Qualifier("acsdbDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "acsdbSqlSessionFactory")
    public SqlSessionFactory acsdbSqlSessionFactory(@Qualifier("acsdbDataSource") DataSource acsdbDataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(acsdbDataSource);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(configLocation));
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        return sessionFactory.getObject();
    }

    @Bean(name = "acsdbSqlSessionTemplate")
    public SqlSessionTemplate acsdbSqlSessionTemplate(@Qualifier("acsdbSqlSessionFactory") SqlSessionFactory acsdbSqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(acsdbSqlSessionFactory);
    }


}
