package cn.quantgroup.qgblservice.job.blimport;

import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 量化派黑名单导入整理至新表任务
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:13
 */
@Slf4j
@Component
public class BlackListImportManagerJob {

    @Autowired
    private IBlackListManagerService iBlackListManagerService;

    @Scheduled(cron = "0 0 4 * * ?")
    public void blackListImportJob() {

        try {

            iBlackListManagerService.blackListRealTimeManagerByDay();

        } catch (Exception e) {
            log.error("每天导入近5天逾期(15+)用户黑名单异常", e);
        }

    }

    public static void main(String[] args) {

    }

}
