package cn.quantgroup.qgblservice.config.master;

import cn.quantgroup.qgblservice.config.blacklist.BlackListProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * @Author fengjunkai
 * @Date 2019-07-02 11:58
 */
@Import({MasterProperties.class})
@MapperScan(basePackages = MasterSourceConfig.PACKAGE, sqlSessionFactoryRef = "masterSqlSessionFactory")
@Configuration
public class MasterSourceConfig {

    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.master";

    @Value("${master.mapper-locations}")
    private String mapperLocations;
    @Value("${master.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${master.config-location}")
    private String configLocation;

    @Autowired
    private MasterProperties masterProperties;

    @Bean(name = "dataSource")
    public DataSource masterDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(masterProperties.getJdbcUrl());
        config.setPassword(masterProperties.getPassword());
        config.setMaximumPoolSize(masterProperties.getMaxPoolSize());
        config.setUsername(masterProperties.getUsername());
        config.setMinimumIdle(masterProperties.getMinPoolSize());
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    @Bean(name = "masterSqlSessionFactory")
    public SqlSessionFactory masterSqlSessionFactory(@Qualifier("dataSource") DataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(configLocation));
        return sessionFactory.getObject();
    }

    @Bean(name = "masterSqlSessionTemplate")
    public SqlSessionTemplate masterSqlSessionTemplate(@Qualifier("masterSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

}
