package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackListQueryMapper;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb.BlackListQueryTidbMapper;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-05 16:43
 */
@Slf4j
@Service
public class BlackListManagerServiceImpl implements IBlackListManagerService {

    @Autowired
    private BlackListQueryTidbMapper blackListQueryTidbMapper;
    @Autowired
    private BlackListQueryMapper blackListQueryMapper;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    /**
     * 手机号黑名单black_type_list_new --> black_list_new
     *
     * @param startTime
     * @param endTime
     */
    @Override
    public void blackListPhoneManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate);
            log.info("{} - {} 手机号黑名单关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    /**
     * 身份证黑名单 black_list_idcard_new --> black_list_new
     *
     * @param startTime
     * @param endTime
     */
    @Override
    public void blackListIdCardManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate);
            log.info("{} - {} 身份证号黑名单关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    @Override
    public void blackListPhoneManagerByDay(String startTime, String endTime) {
        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());


    }

    @Override
    public void blackListIdCardManagerByDay(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());


    }

}
