package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListImportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 黑名单导入管理接口
 * black_type_list_new/black_type_idcard_new--->black_list
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:18
 */
@RestController
@RequestMapping("/")
public class BlackListImportManagerController {

    @Autowired
    private IBlackListImportService iBlackListImportManagerService;

    @RequestMapping("/phone_black_list_import_by_month")
    public GlobalResponse phoneBlackListImportByMonth(String startTime, String endTime) {

        return iBlackListImportManagerService.blackListPhoneImport(startTime, endTime);

    }

    @RequestMapping("/id_no_black_list_import_by_month")
    public GlobalResponse idNoBlackListImportByMonth(String startTime, String endTime){

        return iBlackListImportManagerService.blackListIdCardImport(startTime, endTime);

    }

}
