package cn.quantgroup.qgblservice.repository.mybatis.entity;

import cn.quantgroup.qgblservice.utils.CommonBeanUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.RowMapper;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @Author fengjunkai
 * @Date 2019-08-07 18:40
 */
public class BaseEntity<T> implements RowMapper<T>, Comparable<T>, Serializable {

    public static final long serialVersionUID = 1L;

    @Override
    public int compareTo(T o) {
        return 0;
    }
    @SuppressWarnings("unchecked")
    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Class<T> tClass=(Class<T>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        T mappedObject =  BeanUtils.instantiate(tClass);
        T rsToBean = CommonBeanUtils.rsToBean(mappedObject, rs);
        return rsToBean;
    }
    private boolean isLimit = false;

    public boolean limit() {
        return isLimit;
    }
    public void assignmentLimit(boolean isLimit) {
        this.isLimit = isLimit;
    }

}
