package cn.quantgroup.qgblservice.config.blacklist;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @Author fengjunkai
 * @Date 2019-07-02 11:58
 */
@Import({BlackListProperties.class})
@MapperScan(basePackages = BlackListSourceConfig.PACKAGE, sqlSessionFactoryRef = "blackListSqlSessionFactory")
@Configuration
public class BlackListSourceConfig {

    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist";

    @Value("${black.list.mapper-locations}")
    private String mapperLocations;
    @Value("${black.list.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${black.list.config-location}")
    private String configLocation;

    @Autowired
    private BlackListProperties blackListProperties;

    @Bean(name = "dataSource")
    @Qualifier("dataSource")
    @Primary
    public DataSource blackListDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(blackListProperties.getJdbcUrl());
        config.setUsername(blackListProperties.getUsername());
        config.setPassword(blackListProperties.getPassword());
        config.setMinimumIdle(blackListProperties.getMinPoolSize());
        config.setMaximumPoolSize(blackListProperties.getMaxPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    @Bean(name = "blackListJdbcTemplate")
    public JdbcTemplate primaryJdbcTemplate(@Qualifier("dataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "blackListSqlSessionFactory")
    public SqlSessionFactory blackListSqlSessionFactory(@Qualifier("dataSource") DataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(configLocation));
        return sessionFactory.getObject();
    }

    @Bean(name = "blackListSqlSessionTemplate")
    public SqlSessionTemplate qgBlSqlSessionTemplate(@Qualifier("blackListSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

}
