package cn.quantgroup.qgblservice.job.blimport;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.constant.ConstantBlackGrey;
import cn.quantgroup.qgblservice.service.IBlackGreyListService;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 黑灰名单明天T+1定时任务 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.16 10:22 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Component
public class BlackGreyListJob {

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private IBlackGreyListService blackGreyListService;


    private Boolean increment(String key){
        Long increment = redisTemplate.opsForValue().increment(key, 1);
        return increment <= 1;
    }

    private void setRedisValStr(String key, long timeout) {
        try {
            redisTemplate.opsForValue().set(key, "true", timeout, TimeUnit.MINUTES);
        } catch (Exception e) {
            log.error("Redis中set值异常, key: {} ", key, e);
        }
    }

    private boolean getRedisValStr(String key) {
        String value = null;
        try {
            value = redisTemplate.opsForValue().get(key);
        } catch (Exception e) {
            log.error("Redis中get值异常, key: {} ", key, e);
        }

        if (StringUtils.isNotEmpty(value) && "true".equals(value)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 每天现金贷/vcc新增逾期15天黑名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 14:15 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 14:15 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Scheduled(cron = "0 0 6 * * ?")//每天凌晨6点00
    public void blackListImportJob() {

        try {
            if(increment(ConstantBlackGrey.REDIS_KEY.JOB_ADD_BLACK_LIST_INCREMENT_KEY)){
                redisTemplate.expire(ConstantBlackGrey.REDIS_KEY.JOB_ADD_BLACK_LIST_INCREMENT_KEY, 10, TimeUnit.SECONDS);
                //yyyy-MM-dd
                String todayNyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
                long statUtc = 0L;

                //1、导入-现金分期15+逾期黑名单  约耗时65866.ms
                String xianJinDai = null;
                try {
                    statUtc = System.currentTimeMillis();
                    xianJinDai = blackGreyListService.importXianJinDaiBlackGreyList();
                    Thread.sleep(3000);//3秒
                }catch (Exception e){
                    log.error(todayNyr+", 每天执行新增现金分期15+逾期黑名单异常", e);
                }finally {
                    log.info(todayNyr+", 每天执行新增现金分期15+逾期黑名单结束, Msg: {} , 总耗时: {} ", xianJinDai, (System.currentTimeMillis()-statUtc)+".ms");
                }

                //2、导入-Vcc15+逾期黑名单 约耗时14369.ms
                String vcc = null;
                try {
                    statUtc = System.currentTimeMillis();
                    vcc = blackGreyListService.importVccBlackGreyList();
                    Thread.sleep(3000);//3秒
                }catch (Exception e){
                    log.error(todayNyr+", 每天执行新增Vcc15+逾期黑名单异常", e);
                }finally {
                    log.info(todayNyr+", 每天执行新增Vcc15+逾期黑名单结束, Msg: {} , 总耗时: {} ", vcc, (System.currentTimeMillis()-statUtc)+".ms");
                }


                //3、将逾期已还清黑名单转灰名单 耗时1206283.ms 约20分钟
                String removeBlackToGrey = null;
                try {
                    statUtc = System.currentTimeMillis();
                    removeBlackToGrey = blackGreyListService.removeBlackToGreyList();
                    Thread.sleep(10000);//10秒
                }catch (Exception e){
                    log.error(todayNyr+", 每天执行将逾期已还清黑名单转灰名单异常", e);
                }finally {
                    log.info(todayNyr+", 每天执行将逾期已还清黑名单转灰名单结束, Msg: {} , 总耗时: {} ", removeBlackToGrey, (System.currentTimeMillis()-statUtc)+".ms");
                }


                //if(StringUtils.isNotEmpty(xianJinDai) && StringUtils.isNotEmpty(vcc) && StringUtils.isNotEmpty(removeBlackToGrey)){
                    //setRedisValStr(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY, 15);
                    setRedisValStr(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY, 12);
                //}

            }
        } catch (Exception e) {
            log.error("每天执行新增15+逾期黑名单异常", e);
        }
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 每天将逾期已还清黑名单>>转灰名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 14:16 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 14:16 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    //@Scheduled(cron = "0 */10 * * * ?") //每天10分钟扫描一次
   /* public void blackToGreyListJob() {

        try {
            if(increment(ConstantBlackGrey.REDIS_KEY.JOB_REMOVE_BLACK_TO_GREY_INCREMENT_KEY)){
                redisTemplate.expire(ConstantBlackGrey.REDIS_KEY.JOB_REMOVE_BLACK_TO_GREY_INCREMENT_KEY, 10, TimeUnit.SECONDS);

                //判断是否有执行
                if (getRedisValStr(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_BLACK_TO_GREY_KEY)) {
                    //yyyy-MM-dd
                    String todayNyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);

                    String removeBlackToGrey = null;
                    try {
                        //删掉执行标记
                        redisTemplate.delete(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_BLACK_TO_GREY_KEY);

                        removeBlackToGrey = blackGreyListService.removeBlackToGreyList();
                    }catch (Exception e){
                        log.error(todayNyr+", 每天执行将逾期已还清黑名单转灰名单异常", e);
                    }

                    if(StringUtils.isNotEmpty(removeBlackToGrey)){
                        setRedisValStr(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY, 15);
                    }

                }
            }
        } catch (Exception e) {
            log.error("每天执行将逾期已还清黑名单转灰名单异常", e);
        }
    }*/

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 每天更新黑名单>>最大逾期天数和累计逾期天数 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.16 14:16 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.16 14:16 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @Scheduled(cron = "0 */10 * * * ?") //每天10分钟扫描一次
    public void updateBlackListOverdueDayJob() {

        try {
            if(increment(ConstantBlackGrey.REDIS_KEY.JOB_UPDATE_BLACK_OVERDUEDAY_INCREMENT_KEY)){
                redisTemplate.expire(ConstantBlackGrey.REDIS_KEY.JOB_UPDATE_BLACK_OVERDUEDAY_INCREMENT_KEY, 10, TimeUnit.SECONDS);

                //判断是否有执行
                if (getRedisValStr(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY)) {
                    //yyyy-MM-dd
                    String todayNyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
                    long statUtc = System.currentTimeMillis();

                    String updateBLOverdueDay = null;
                    try {
                        //删掉执行标记
                        redisTemplate.delete(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY);

                        //耗时3807471.ms  约64分钟，
                        updateBLOverdueDay = blackGreyListService.updateBlackListOverdueDay();
                    }catch (Exception e){
                        log.error(todayNyr+", 每天执行更新黑名单最大逾期天数和累计逾期天数异常", e);
                    }finally {
                        redisTemplate.delete(ConstantBlackGrey.REDIS_KEY.SIGN_IS_RUN_UPDATE_BLACK_OVERDUEDAY_KEY);
                        log.info(todayNyr+", 每天执行更新黑名单最大逾期天数和累计逾期天结束, Msg: {} , 总耗时: {} ", updateBLOverdueDay, (System.currentTimeMillis()-statUtc)+".ms");
                    }

                }

            }
        } catch (Exception e) {
            log.error("每天执行更新黑名单最大逾期天数和累计逾期天数异常", e);
        }
    }

}
