package cn.quantgroup.qgblservice.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-08-07 18:41
 */
public class DateUtil {

    public static final int PERIOD_TYPE_YEAR = 0;
    public static final int PERIOD_TYPE_MONTH = 1;
    public static final int PERIOD_TYPE_HALFMONTH = 2;
    public static final int PERIOD_TYPE_WEEK = 3;
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    /**
     * 英文简写（默认）如：2015-12
     */
    public static String yyyyMM_Bar = "yyyy-MM";
    /**
     * 英文简写（默认）如：2015-12-01
     */
    public static String yyyyMMdd_Bar = "yyyy-MM-dd";
    /**
     * 英文全称  如：2015-12-01 23:15:06
     */
    public static String yyyyMMddSpaceHHmmss_Bar = "yyyy-MM-dd HH:mm:ss";
    /**
     * 精确到毫秒的完整时间    如：yyyy-MM-dd HH:mm:ss.S
     */
    public static String yyyyMMddSpaceHHmmssFull_Bar = "yyyy-MM-dd HH:mm:ss.S";
    /**
     * 英文简写（默认）如：2015-12-01
     */
    public static String yyyyMMdd_Slash = "yyyy/MM/dd";
    /**
     * 20151201
     */
    public static String yyyyMMdd = "yyyyMMdd";
    /**
     * 20151201121321
     */
    public static String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    /**
     * 精确到毫秒
     * 20151201121321992
     */
    public static String yyyyMMddHHmmssS = "yyyyMMddHHmmssS";
    /**
     * 201512
     */
    public static String yyyyMM = "yyyyMM";

    /**
     * 获得默认的 date pattern
     */
    public static String getDatePattern() {
        return yyyyMMddSpaceHHmmss_Bar;
    }

    /**
     * 根据预设格式返回当前日期
     *
     * @return
     */
    public static String getNow() {
        return format(new Date());
    }
    public static Date getDate() {
        return new Date();
    }
    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }
    /**
     * 获取当前时间串 yyyyMMddHHmmss
     * @return
     */
    public static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(new Date());
    }
    /**
     * 根据用户格式返回当前日期
     *
     * @param format
     * @return
     */
    public static String getNow(String format) {
        return format(new Date(), format);
    }

    /**
     * 使用预设格式格式化日期
     *
     * @param date
     * @return
     */
    public static String format(Date date) {
        return format(date, getDatePattern());
    }

    /**
     * 使用用户格式格式化日期
     *
     * @param date    日期
     * @param pattern 日期格式
     * @return
     */
    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return (returnValue);
    }

    /**
     * 使用预设格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @return
     */
    public static Date parse(String strDate) {
        if(strDate == null||"".equalsIgnoreCase(strDate)){
            return null;
        }
        if(strDate.length()<12){
            return parse(strDate, "yyyy-MM-dd");
        }
        return parse(strDate, getDatePattern());
    }

    /**
     *
     * @param timestamp
     * @return
     */
    public static Date parse(long timestamp) {
        try {
            Date date = new Date();
            date.setTime(timestamp);
            return date;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 使用用户格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @param pattern 日期格式
     * @return
     */
    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 在日期上增加数个整月
     *
     * @param date 日期
     * @param n    要增加的月数
     * @return
     */
    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MONTH, n);
        return cal.getTime();
    }

    /**
     * 在日期上增加天数
     *
     * @param date 日期
     * @param n    要增加的天数
     * @return
     */
    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DATE, n);
        return cal.getTime();
    }

    /**
     * 获取日期年份
     *
     * @param date 日期
     * @return
     */
    public static String getYear(Date date) {
        return format(date).substring(0, 4);
    }

    public static String getMonth(Date date){
        return format(date).substring(5,7);
    }

    /**
     * 按默认格式的字符串距离今天的天数
     *
     * @param date 日期字符串
     * @return
     */
    public static int countDays(String date) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(parse(date));
        long t1 = c.getTime().getTime();
        return (int) (t / 1000 - t1 / 1000) / 3600 / 24;
    }

    /*
     * 返回最近月份
     * */
    public static List<Date> getLastMonths(int num) {
        List<Date> list = new ArrayList<Date>();
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, 1);
        for (int i = 0; i < num; i++) {
            c.add(Calendar.MONTH, -1);
            list.add(new Date(c.getTime().getTime()));
        }
        return list;
    }
    public static List<String> getLatestMonths(int num, String format) {
        return getLatestMonths(num, format, true);
    }

    /*
     * 返回最近月份,默认 201506,201505
     * */
    public static List<String> getLatestMonths(int num, String format, boolean isIncludeCurrentMonth) {
        if (StringUtils.isBlank(format)) {
            format = yyyyMM;
        }
        List<String> objectTmp = new ArrayList<String>();
        java.text.DateFormat format2 = new SimpleDateFormat(
                format);
        Calendar c = Calendar.getInstance();
        if (isIncludeCurrentMonth) {
            c.add(Calendar.MONTH, 1);
        }
        for (int i = 0; i < num; i++) {
            c.add(Calendar.MONTH, -1);
            Date date = c.getTime();
            String date2 = format2.format(date);
            objectTmp.add(date2);
        }
        return objectTmp;
    }

    /**
     * @param dateStr yyyy-MM-dd
     * @return
     */
    public static String lastDayOfMonth(String dateStr) {
        return lastDayOfMonth(dateStr, yyyyMMdd_Bar, yyyyMMdd_Bar);
    }
    public static String lastDayOfMonth(String dateStr,String inputFormat,String outFormat){
        return format((Object) dateStr, inputFormat, outFormat, false);
    }
    public static String lastDayOfMonth(Date date) {
        return format(date,yyyyMMdd_Bar,yyyyMMdd_Bar,false);
    }
    public static String lastDayOfMonth(Date date,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,false);
    }
    public static String lastDayOfMonth(Date date,String inputFormat,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,false);
    }
    /**
     * @param inputFormat 例如 yyyy-MM
     * @param outFormat   例如 yyyy-MM-dd
     * @return 月份的最后一天
     */
    private static String format(Object da,String inputFormat,String outFormat,boolean isFirst) {
        if(da!=null){
            Date date = null;
            try {
                if(da instanceof Date){
                    date = (Date) da;
                }else{
                    date = new SimpleDateFormat(inputFormat).parse(da.toString());
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }
            if(date!=null){
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(Calendar.DAY_OF_MONTH, 1);
                if(!isFirst){
                    cal.roll(Calendar.DAY_OF_MONTH, -1);
                }
                Date time = cal.getTime();
                SimpleDateFormat sdf = new SimpleDateFormat(outFormat);
                return sdf.format(time);
            }

        }
        return null;
    }
    /**
     * @param dateStr yyyy-MM-dd
     * @return
     */
    public static String firstDayOfMonth(String dateStr) {
        return firstDayOfMonth(dateStr, yyyyMMdd_Bar, yyyyMMdd_Bar);
    }
    public static String firstDayOfMonth(String dateStr,String inputFormat,String outFormat){
        return format((Object) dateStr, inputFormat, outFormat, true);
    }
    public static String firstDayOfMonth(Date date) {
        return format(date,yyyyMMdd_Bar,yyyyMMdd_Bar,true);
    }
    public static String firstDayOfMonth(Date date,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,true);
    }
    public static String firstDayOfMonth(Date date,String inputFormat,String outFormat) {
        return format(date, yyyyMMdd_Bar, outFormat, true);
    }

    public static Date getHourByDate(Calendar c,int hour){
        c.set(Calendar.HOUR_OF_DAY, c.get(Calendar.HOUR_OF_DAY)+hour);
//       c.set(Calendar.DAY_OF_MONTH,c.get(Calendar.DAY_OF_MONTH)+1);
        return c.getTime();
    }

    /**
     * @return  01,02月
     * @throws
     */
    public static String getChineseToDigitalMonth(String month){
        switch (month) {
            case "七月":
                return "07";
            case "六月":
                return "06";
            case "五月":
                return "05";
            case "四月":
                return "04";
            case "三月":
                return "03";
            case "二月":
                return "02";
            case "一月":
                return "01";
            case "十二月":
                return "12";
            case "十一月":
                return "11";
            case "十月":
                return "10";
            case "九月":
                return "09";
            case "八月":
                return "08";
            case "Jan":
                return "01";
            case "Feb":
                return "02";
            case "Mar":
                return "03";
            case "Apr":
                return "04";
            case "May":
                return "05";
            case "Jun":
                return "06";
            case "Jul":
                return "07";
            case "Aug":
                return "08";
            case "Sep":
                return "09";
            case "Oct":
                return "10";
            case "Nov":
                return "11";
            case "Dec":
                return "12";
            default:
                break;
        }
        return "";
    }

    public static String getRegeDate(int year, int month,int day){
        try{
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar c = Calendar.getInstance();
            try {
                c.add(Calendar.YEAR, -year);
                c.add(Calendar.MONTH, -month);
                c.add(Calendar.DATE, -day);
            } catch (Exception e) {
                logger.error("转换用户入网那个时间异常",e);
            }
            return df.format(c.getTime());
        }catch(Exception e){
            e.printStackTrace();
        }
        return "";
    }
    /**
     * 获取当前小时
     * @return
     */
    public static String getCurrentHourStr(){
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd/HH");
        return df.format(new Date());
    }
    /**
     * 获取分钟十位 前一个
     * @return
     */
    public static String getPreCurrentMinTen(){
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd/HH/mm");
        String format = df.format(new Date());
        String[] split = format.split("/");
        int hour = Integer.parseInt(split[1]);
        int min = Integer.parseInt(split[2].substring(0, 1));
        if(min==0){
            min=5;
            if(hour==0){
                hour = 23;
            }else{
                hour = hour-1;
            }
        }else{
            min=min-1;
        }
        return split[0]+hour+min;
    }
    /**
     * 获取当前分钟十位
     * @return
     */
    public static String getCurrentMinTen(){
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd/HH/mm");
        String format = df.format(new Date());
        String[] split = format.split("/");
        int hour = Integer.parseInt(split[1]);
        int min = Integer.parseInt(split[2].substring(0, 1));
        return split[0]+hour+min;
    }

    public static int calculateMonthIn(Date nowDate, Date lastAuthDate, String userId, String phoneNo) {
        try{
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(nowDate);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(lastAuthDate);
            int cha =(cal1.get(Calendar.YEAR) - cal2.get(Calendar.YEAR)) * 12 + cal1.get(Calendar.MONTH) - cal2.get(Calendar.MONTH);
            if(cha>=6) {
                logger.info("运营商增量抓取授权时间超过6个月, userId: {} , phoneNo: {} ", userId, phoneNo);
                return 6;
            }
            return cha+1;
        }catch(Exception e){
            logger.error("运营商增量抓取授权时间计算异常, userId: {} , phoneNo: {} ", userId, phoneNo, e);
        }
        logger.info("运营商增量抓取授权时间正常抓取6个月, userId: {} , phoneNo: {} ", userId, phoneNo);
        return 6;
    }

    public static String getTodayStr(){
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(new Date());
    }
    /**
     * 获取小时list
     * @param num
     * @return
     */
    public static List<String> getHourList(int num){
        List<String> list = new ArrayList<>();
        for(int i =0;i<num+1;i++){
            Calendar c = Calendar.getInstance();
            c.add(Calendar.HOUR_OF_DAY, -i);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd/HH");
            list.add(sdf.format(c.getTime()));
        }
        return list;
    }
    /**
     * 获取最近7天list
     * @return
     */
    public static List<String> getDayList(){
        List<String> list = new ArrayList<>();
        for(int i =0;i<7;i++){
            Calendar c = Calendar.getInstance();
            c.add(Calendar.DAY_OF_MONTH, -i);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            list.add(sdf.format(c.getTime()));
        }
        return list;
    }
    /**
     *
     * @return
     */
    public static int getIntHour(){
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.HOUR_OF_DAY);
    }



    /**
     * 获取上个月的今天日期
     * @return
     */
    public static Date getNowOfLastMonth(int month){
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, -month);
        return c.getTime();
    }
    /**
     * 获取上个月的指定日期
     * @return
     */
    public static Date getDayOfLastMonth(int day){
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, -1);
        int i = c.get(Calendar.DAY_OF_MONTH);
        c.add(Calendar.DAY_OF_MONTH, -i+day);
        return c.getTime();
    }
    /**
     * 获取当前月几号
     * @param day
     * @return
     */
    public static Date getDayOfMonth(int day){
        Calendar c = Calendar.getInstance();
        int i = c.get(Calendar.DAY_OF_MONTH);
        c.add(Calendar.DAY_OF_MONTH, -i+day);
        return c.getTime();
    }
    /**
     *
     * @param time
     * @return
     */
    public static int timetoint(String time){
        time=time.trim().replaceAll(" ", "");
        int s=0;
        time = time.replaceAll("钟", "").replaceAll("小时", "时");
        if(time.contains("秒") || time.contains("时") || time.contains("分") || time.contains("天")){
            if(time.contains("天")){
                s+=Integer.parseInt(time.substring(0,time.indexOf("天")))*3600*24;
            }
            if(time.contains("时")){
                s+=Integer.parseInt(time.substring(time.indexOf("天")+1,time.indexOf("时")))*3600;
            }
            if(time.contains("分")){
                s+=Integer.parseInt(time.substring(time.indexOf("时")+1,time.indexOf("分")))*60;
            }
            if(time.contains("秒")){
                s+=Integer.parseInt(time.substring(Math.max(time.indexOf("时")+1,time.indexOf("分")+1),time.indexOf("秒")));
            }
        }else{
            String split = ":";
            if (time.indexOf(split) < 0) {
                split = "'";
            }
            String[] strs = time.split(split);
            if(strs.length >= 3){
                String hour = strs[0].replace(split, "");
                String min = strs[1].replace(split, "");
                String sencond = strs[2].replace(split, "");
                s+=Integer.parseInt(hour)*3600;
                s+=Integer.parseInt(min)*60;
                s+=Integer.parseInt(sencond);
            }
        }
        return s;
    }
    //20170215 15:55:01或"2017/02/17 10:40:03"
    public static String formatOut(String dateStr){
        String formatStr = "";
        if(dateStr.contains("/")){
            formatStr = dateStr.replace("/","-");
        }else if(dateStr.length() >= 8 && !dateStr.substring(0,8).contains("-")){
            formatStr = dateStr.substring(0,4)+"-"+dateStr.substring(4,6)+"-"+dateStr.substring(6,dateStr.length());
        }
        return formatStr;
    }
    /*
     *String转Date
     * */
    public static Date StringToDate(String dateStr, String formatStr) {
        DateFormat dd = new SimpleDateFormat(formatStr);
        Date date = null;
        if (!StringUtils.isBlank(dateStr)) {
            try {
                date = dd.parse(dateStr);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }
    /*
     * 输出前几个月的信息，包括当前月,format可以是yyyy/MM
     * */
    public static List<String> getMonths(int num,String format){
        List<String> objectTmp = new ArrayList<String>();
        java.text.DateFormat format2 = new java.text.SimpleDateFormat(
                format);
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, 1);
        for (int i = 0; i < num; i++) {
            c.add(Calendar.MONTH, -1);
            Date date = c.getTime();
            String date2 = format2.format(date);
            //System.out.println(date2);
            objectTmp.add(date2);
        }
        return objectTmp;
    }
    /**返回传入月份的天数
     * @return
     */
    public static int getDaysOfMonth(String date){
        int days=0;
        try {
            Calendar rightNow = Calendar.getInstance();
            try {
                rightNow.setTime(StringToDate(date,"yyyyMM")); //要计算你想要的月份，改变这里即可
            } catch (Exception e) {
                e.printStackTrace();
            }
            days = rightNow.getActualMaximum(Calendar.DAY_OF_MONTH);
        } catch (Exception e) {
        }
        return days;
    }
    public static Date[] getPeriodByType(Date currentDate, int type) {

        Date fromDate = currentDate;
        Date toDate = currentDate;
        Calendar cal;
        switch (type) {
            case PERIOD_TYPE_YEAR:

                cal = Calendar.getInstance();
                cal.setTime(currentDate);
                cal.set(Calendar.MONTH, 0);
                cal.set(Calendar.DATE, 1);

                fromDate = cal.getTime();

                cal.add(Calendar.YEAR, 1);
                toDate = add(cal.getTime(), Calendar.DATE, -1);
                break;

            case PERIOD_TYPE_MONTH:
                cal = Calendar.getInstance();
                cal.setTime(currentDate);
                cal.set(Calendar.DATE, 1);

                fromDate = cal.getTime();

                cal.add(Calendar.MONTH, 1);
                toDate = add(cal.getTime(), Calendar.DATE, -1);
                break;

            case PERIOD_TYPE_WEEK:
                int dayOfWeek = getWeekDay(currentDate);
                int seg = -1 * dayOfWeek;

                fromDate = add(currentDate, Calendar.DATE, seg);
                toDate = add(fromDate, Calendar.DATE, 6);

                break;

            case PERIOD_TYPE_HALFMONTH:
                int dayOfMonth = getDayOfMonthByDate(currentDate);
                fromDate = add(currentDate, Calendar.DATE, -1 * dayOfMonth + 1);
                if (dayOfMonth > 15) {
                    cal = Calendar.getInstance();
                    cal.setTime(fromDate);
                    cal.add(Calendar.MONTH, 1);
                    toDate = add(cal.getTime(), Calendar.DATE, -1);
                    fromDate = add(fromDate, Calendar.DATE, 15);

                } else {
                    toDate = add(fromDate, Calendar.DATE, 14);
                }

                break;

            default:
                break;
        }

        Date[] period = new Date[2];
        period[0] = fromDate;
        period[1] = toDate;
        return period;
    }
    public static Date add(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }
    public static int getWeekDay(Date date) {
        if (date == null) {
            return -1;
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        return getWeekDay(calendar.get(Calendar.DAY_OF_WEEK));
    }
    public static int getWeekDay(int weekNumber) {
        switch (weekNumber) {
            case Calendar.MONDAY:
                return 1;

            case Calendar.TUESDAY:
                return 2;

            case Calendar.WEDNESDAY:
                return 3;

            case Calendar.THURSDAY:
                return 4;

            case Calendar.FRIDAY:
                return 5;

            case Calendar.SATURDAY:
                return 6;

            case Calendar.SUNDAY:
                return 0;

            default:
                return -1;
        }
    }
    public static int getDayOfMonthByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);

        return cal.get(Calendar.DAY_OF_MONTH);
    }

}
