package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListImportService;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 黑名单导入管理接口
 * black_type_list_new/black_type_idcard_new--->black_list
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:18
 */
@RestController
@RequestMapping("/")
@Slf4j
public class BlackListImportManagerController {

    @Autowired
    private IBlackListImportService iBlackListImportManagerService;
    @Autowired
    private IBlackListManagerService iBlackListManagerService;
    @Autowired
    private IThirdPartBlackListManagerService iThirdPartBlackListManagerService;


    @RequestMapping("/phone_black_list_import_by_month")
    public GlobalResponse phoneBlackListImportByMonth(String startTime, String endTime) {
        log.info("方法phoneBlackListImportByMonth入参, startTime: {} , endTime: {} ", startTime, endTime);
        return iBlackListImportManagerService.blackListPhoneImport(startTime, endTime);
    }

    @RequestMapping("/id_no_black_list_import_by_month")
    public GlobalResponse idNoBlackListImportByMonth(String startTime, String endTime){
        log.info("方法idNoBlackListImportByMonth入参, startTime: {} , endTime: {} ", startTime, endTime);
        return iBlackListImportManagerService.blackListIdCardImport(startTime, endTime);
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 三方数据源项目，命中外部黑名单，调该接口写入黑名单库 <br>
     * 创建人: fengjunkai  <br>
     * 创建时间: 2019-07-31 17:18 <br>
     * 最后修改人: yanhui.Hao <br>
     * 最后修改时间: 2020.04.24 11:28 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    @RequestMapping("/third_part_black_list")
    public GlobalResponse thirdPartBlackList(String uuid, String name, String phoneNo, String idCard, String type){
        log.info("方法thirdPartBlackList入参, uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} ", uuid, name, phoneNo, idCard, type);

        //return iThirdPartBlackListManagerService.saveThirdPartBlackList(uuid, name, phoneNo, idCard, type);
        //2020.04.28 21:18 历史黑名单 & 黑灰名单 都双写
        return iThirdPartBlackListManagerService.saveThirdPartGreyList(uuid, name, phoneNo, idCard, type);

    }

    @RequestMapping("/phone_black_list_test")
    public GlobalResponse phoneBlackListTest(String startTime, String endTime){
        log.info("方法phoneBlackListTest入参, startTime: {} , endTime: {} ", startTime, endTime);
        iBlackListManagerService.blackListPhoneManagerByDay(startTime, endTime);
        return GlobalResponse.success();
    }

    @RequestMapping("/idcard_black_list_test")
    public GlobalResponse idcardBlackListTest(String startTime, String endTime){
        log.info("方法idcardBlackListTest入参, startTime: {} , endTime: {} ", startTime, endTime);
        iBlackListManagerService.blackListIdCardManagerByDay(startTime, endTime);
        return GlobalResponse.success();
    }

    @RequestMapping("/black_list_real_time_test")
    public GlobalResponse blackListRealTimeTest(){
        log.info("方法blackListRealTimeTest开始调用");
        iBlackListManagerService.blackListRealTimeManagerByDay();
        return GlobalResponse.success();
    }

//    @RequestMapping("/import_blacklist_by_excel")
//    public GlobalResponse importBlacklistByExcel(@RequestParam("excelFile") MultipartFile file){
//        Map<String, Object> objectMap = null;
//        try {
//            objectMap = iBlackListManagerService.importBlacklistByExcel(file);
//        }catch (Exception e){
//            log.error("导入异常e:",e);
//            return GlobalResponse.error("导入异常"+e.getMessage());
//
//        }
//        return GlobalResponse.success(objectMap);
//    }
    @RequestMapping("/manual_import_black_list")
    public GlobalResponse manualImport(String sourcePath){
        log.info("方法manualImport入参, sourcePath: {} ", sourcePath);
        return iBlackListManagerService.manualImportBlackList(sourcePath);
    }

}
