/*
 * Copyright 2014-present Miyou tech inc. All Rights Reserved.
 */

package cn.quantgroup.qgblservice.utils.http;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统使用Exception来进行Error Code处理。如果LogType为Error，
 * 代表这种Error不应该返回给客户端，应该统一打印出服务器端错误；
 * 如果是WARNING的话，就将对应的Exception Text返回给客户端。
 */
@Slf4j
public enum QGExceptionType {
  COMMON_SERVER_ERROR(1001, "系统异常，请稍后再试"),
  COMMON_ILLEGAL_STATE(1002, "断言错误"),
  COMMON_ILLEGAL_PARAM_TOAST(1003, "参数异常", "%s"),
  COMMON_AUTH_ERROR(1004, "系统异常，请稍后再试"),
  COMMON_ILLEGAL_PARAM(1010, "参数异常"),
  COMMON_THIRD_PARTY_TIMEOUT(1011, "第三方服务超时"),
  COMMON_INVALID_PARAM(1012, "参数错误"),
  COMMON_ID_INVALID(1013, "id数据非法"),
  COMMON_STRING_PARAM_GREATER_THAN_LENGTH(1014, "参数的长度过长", "%s的长度不能大于%s"),
  COMMON_STRING_PARAM_IS_ALL_NULL(1015, "参数不能为空", "%s不能为空"),
  COMMON_STRING_PARAM_IS_NULL(1016, "参数不能同时为空", "%s不能同时为空"),
  COMMON_THIRD_PARTY_ERROR(1017, "第三方服务报错", "第三方服务报错,错误编码:%s,错误提示:%s"),
  COMMON_THIRD_PART_CALL_EXCEPTION(3001,"第三方服务调用异常", "异常信息:%s"),
  ;

  public int code;
  public String text;
  public String frontEndToastTemplate;

  QGExceptionType(int code, String text) {
    this.code = code;
    this.text = text;
    this.frontEndToastTemplate = text;
  }

  QGExceptionType(int code, String text, String frontEndToastTemplate) {
    this.code = code;
    this.text = text;
    this.frontEndToastTemplate = frontEndToastTemplate;
  }


  public static QGExceptionType fromCode(int code) {
    for (QGExceptionType exceptionType : QGExceptionType.values()) {
      if (exceptionType.code == code) {
        return exceptionType;
      }
    }
    return null;
  }

  @Override
  public String toString() {
    return "error_code: " + code + ", text: " + text + ", frontEndToastTemplate: " + frontEndToastTemplate;
  }
}
