package cn.quantgroup.qgblservice.utils.parallel;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 小例子-应用业务类 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2020.01.15 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public class ParallelDemo implements ParallelComputingProcess<Map<String,Object>,Boolean>{

    private Logger logger = Logger.getLogger(ParallelDemo.class);
    private final String log_inf = "ParallelTest";

    //并行处理框架
    private ParallelComputing<Map<String, Object>, Boolean> p = new ParallelComputing<Map<String,Object>,Boolean>("MyParallelTestName");
    /** 当前服务器CPU个数 */
    public static int SYS_CPU_COUNT = Runtime.getRuntime().availableProcessors();


    public void runMain(){

        //result 业务待处理数据
        List<Map<String, Object>> result = new ArrayList<>();

        Boolean optSecond = true;
        p.processForThread(result, this, SYS_CPU_COUNT, optSecond);

        //并行框架执行结果
        long startProcess = System.currentTimeMillis();
        if(!optSecond){//并行框架执行异常
            logger.error("runMain() ERROR! >> process().");//加监控用
            return;
        }else{
            //执行成功,覆盖执行时间
            logger.info(log_inf+" >> to process() is OK, To write redis Utc is OK!");
        }
        logger.info(log_inf+" >> to process() End, cost:"+(System.currentTimeMillis()-startProcess)+"ms.");
    }


    @Override
    public void process(int threadId, List<Map<String, Object>> list, Boolean optSecond) {
        try {
            int count1 = 0;
            for (Map<String, Object> map : list) {

                StringBuilder key1 = new StringBuilder();
                key1.append(map.get("key1").toString());

                StringBuilder value1 = new StringBuilder();
                value1.append(map.get("value1").toString());

                logger.debug("map:"+key1+"===="+value1);
                count1++;

            }
            logger.info(log_inf+"key is vid CPU_"+threadId+">总条数:"+count1);

        } catch (Exception e) {
            optSecond = false;
            logger.error(log_inf+"process() threadId:" + threadId + ",ERROR!", e);
        }
    }




}
