package cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: black_grey_list_details更新update实体 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 20:43 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Data
public class DetailsUpdate implements Serializable {

    private static final long serialVersionUID = 3504867579864272343L;

    private Long id;
    private String rId;
    private String name;
    private String phoneNo;
    private String idNo;
    private String type; //原始黑名单来源。1~99：QG黑名单（1：现金贷，2：白条，3：去哪儿，4：法院黑名单，5：线下黑名单,6新氧黑名单，8手机套现黑名单，9.环球黑卡套现，10.vcc逾期黑名单,11恶意投诉客户）；101~199：P2P黑名单（101：p2p黑名单，102：weshare黑名单，103：芝麻行业关注名单，104：其他小贷黑名单,105-企美提供黑名单,106-拿下分期黑名单）；201~299：机构黑名单（201-black_bank,202-black_kaola,203-black_car,204-前海黑名单,205-华融黑名单,206-人人信黑名单,207-同盾黑名单,208-大锤黑名单,209-国美黑名单,210-美借,211-快金,212-米么,213-手机贷,214-拍拍贷,215-掌众(闪电借款),216-向前贷(明特量化),217-齐立欣提供小贷渠道1,218-致诚阿福黑名单，219-算话黑名单)；301~399:其他黑名单（301：black_dispute）；401~499:白条黑名单（401：白条套现）；501-马上闹事群众
    private String reasonCode;//加入黑名单原因。1现金分期逾期大于15天，且仍然在逾；2.vcc逾期大于15天，且仍然在逾。；3.白条在逾；4.恶意投诉客户；
    private String maxOverdueDays;
    private String totalOverdueDays;

    private int status; //状态 0:正常有效的； -1:由灰名单进入黑名单(无效，逻辑删除的)； -2:由黑名单进入灰名单(无效，逻辑删除的)； 10：当前在黑名单，并且该条数据逾期已还清的
    private String remark;

    @JsonIgnore
    private Timestamp createdAt;
    @JsonIgnore
    private Timestamp updatedAt;

    private Integer wEqStatus; //where条件
    private List<Integer> wInStatus; //where条件
    private String wEqType;//where条件
    private List<String> wInType;//where条件



}
