package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.ConstantBlackGrey;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.*;
import cn.quantgroup.qgblservice.repository.mybatis.entity.xyqbuser.XyqbUser;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputing;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputingProcess;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 逾期已还清黑名单>>转灰名单-并行框架 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.16 21:12 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class BlackToGreyListParallel implements ParallelComputingProcess<BlackGreyListResult, Set<String>> {

    private final String log_inf = "BlackToGreyListParallel";

    //并行处理框架
    private ParallelComputing<BlackGreyListResult, Set<String>> p = new ParallelComputing<BlackGreyListResult, Set<String>>("BlackToGreyListParallel");

    //private static int THREAD_COUNT = ConstantBlackGrey.PARAM.SYS_CPU_COUNT * 2;
    private static int THREAD_COUNT = 5;

    @Autowired
    private BlackGreyListMapper blackGreyListMapper;

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate acsdbJdbcTemplate;

    //@Autowired
    //private JdbcTemplate blackListJdbcTemplate;

    public String removeBlackToGrey(List<BlackGreyListResult> tmpQueryList) {
        long startProcess = System.currentTimeMillis();
        int listSize = tmpQueryList.size();
        log.info(log_inf+"-removeBlackToGrey黑名单转灰名单开始执行>>>>>, listSize: {} , SYS_CPU_COUNT: {} ", listSize, THREAD_COUNT);

        try {
            //并行框架---执行
            Set<String> optSet = Collections.synchronizedSet(new HashSet<>());
            p.processForThread(tmpQueryList, this, THREAD_COUNT, optSet);

            //并行框架执行结果
            if (optSet.size() > 0) {//并行框架执行异常
                log.info(log_inf + "-removeBlackToGrey黑名单转灰名单执行结束-部分失败, cost: {} <<<<<< process optSet size: {} , json: {} ", (System.currentTimeMillis()-startProcess), optSet.size(), JSONObject.toJSONString(optSet));
            } else {
                //执行成功
                log.info(log_inf + "-removeBlackToGrey黑名单转灰名单执行结束-成功, cost: {} <<<<<< process is OK!", (System.currentTimeMillis() - startProcess));
            }

            String resMsgTemp = "总共 %d条, 执行成功 %d条, 失败 %d条;";
            return String.format(resMsgTemp, listSize, listSize-optSet.size(), optSet.size());
        } catch (Exception e) {
            log.error(log_inf +"-removeBlackToGrey黑名单转灰名单执行异常.", e);
        }
        return "黑名单转灰名单执行异常";
    }


    @Override
    public void process(int threadId, List<BlackGreyListResult> blackResultList, Set<String> optSet) {
        //yyyyMMdd
        String dateName = ConstantBlackGrey.PARAM.DF_YMD.format(Calendar.getInstance().getTime());
        int list_size = blackResultList.size();
        long start = System.currentTimeMillis();


        AtomicInteger err_count = new AtomicInteger();
        AtomicInteger type_11 = new AtomicInteger();
        AtomicInteger update_d_count = new AtomicInteger();
        AtomicInteger update_r_count = new AtomicInteger();

        int index = 0;
        //blackResult r_id,uuid,black_type,types,reasons
        for (BlackGreyListResult blackResult : blackResultList) {
            //status 状态 0:正常有效的； -1:由灰名单进入黑名单(无效，逻辑删除的)； -2:由黑名单进入灰名单(无效，逻辑删除的)； -3:在插入灰名单时，已经是黑名单； 10：当前在黑名单，并且该条数据逾期已还清的',
            String rId = blackResult.getRId();
            String uuid = blackResult.getUuid();
            log.info("threadId_{}: 开始执行list_size: {} , this: {} , rId: {} , uuid: {} ", threadId , list_size, (++index), rId, uuid);

            if(StringUtils.isNotEmpty(uuid)){
                try {
                    BlackGreyListQueryVo queryParam = BlackGreyListQueryVo.builder().rId(blackResult.getRId()).build();
                    //关联查询太慢
                    //List<BlackGreyListRjoinDVo> rJoinDVoList = blackGreyListMapper.findBlackGreyListRjoinD(queryParam);
                    List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryParam);
                    log.info("黑转灰-明细表查询列表: {} , rId: {} , uuid: {} ", detailsList!=null?JSON.toJSONString(detailsList):"null", rId, uuid);

                    if (detailsList!=null && detailsList.size()>0) {
                        boolean is_type_11 = false;
                        for(BlackGreyListDetails detailsVo : detailsList){
                            //type=11, 恶意投诉客服，一直在黑名单
                            if("11".equals(detailsVo.getType()) && detailsVo.getStatus().intValue()==0){
                                type_11.getAndIncrement();
                                is_type_11=true;
                                break;
                            }
                            //现金贷
                            else if("1".equals(detailsVo.getType()) && detailsVo.getStatus().intValue()==0){
                                //#现金分期在逾转已还 (条件为step1的表内join_black_reason=1的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)
                                //查询现金贷逾期，是否逾期已还清
                                Integer in_overdue_Obj = null;
                                try {
                                    in_overdue_Obj = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_XIANJINDAI_IS_PAYOFF, new Object[]{uuid}, Integer.class);
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询(现金贷)逾期逾期黑名单是否已还清-查询xyqb异常, r_Id: {} , id: {} , uuid: {} , e: {} ", rId, detailsVo.getId(), uuid, e.toString());
                                }finally {
                                    log.info("查询(现金贷)逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , in_overdue_Obj : {} ", rId, detailsVo.getId(), uuid, in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                }
                                //修改结果表状态为10
                                updateDetailStatus10(in_overdue_Obj, detailsVo, "现金贷");
                            }

                            //白条
                            else if("2".equals(detailsVo.getType()) && detailsVo.getStatus().intValue()==0){
                                //#白条在逾转已还 (条件为step1的表内join_black_reason=3的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)

                                //查询白条逾期逾期黑名单是否已还清
                                Integer in_overdue_Obj = null;
                                try {
                                    in_overdue_Obj = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_BAITIAO_IS_PAYOFF, new Object[]{uuid,uuid}, Integer.class);
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询(白条)逾期逾期黑名单是否已还清-查询xyqb异常, r_Id: {} , id: {} , uuid: {} , e: {} ", rId, detailsVo.getId(), uuid, e.toString());
                                }finally {
                                    log.info("查询(白条)逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , in_overdue_Obj : {} ", rId, detailsVo.getId(), uuid, in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                }

                                //修改结果表状态为10
                                updateDetailStatus10(in_overdue_Obj, detailsVo, "白条");
                            }

                            //Vcc
                            else if("10".equals(detailsVo.getType()) && detailsVo.getStatus().intValue()==0){
                                // #vcc在逾转已还 (条件为step1的表内join_black_reason=2的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)

                                Integer in_overdue_Obj = null;
                                XyqbUser xyqbUser = queryXyqbUserByUuid(uuid);
                                if(xyqbUser!=null && xyqbUser.getId()!=0L){
                                    try {
                                        in_overdue_Obj = acsdbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_VCC_IS_PAYOFF, new Object[]{xyqbUser.getId()}, Integer.class);
                                    }catch (EmptyResultDataAccessException e){
                                        log.error("查询(VCC)逾期逾期黑名单是否已还清-查询acsdb异常, r_Id: {} , id: {} , uuid: {} , user_id: {} , e: {} ", rId, detailsVo.getId(), uuid, xyqbUser.getId(), e.toString());
                                    }finally {
                                        log.info("查询(VCC)逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , user_id: {} , in_overdue_Obj : {} ", rId, detailsVo.getId(), uuid, xyqbUser.getId(), in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                    }

                                    //修改结果表状态为10
                                    updateDetailStatus10(in_overdue_Obj, detailsVo, "VCC");
                                }

                            }else{
                                if(detailsVo.getStatus().intValue()==0){
                                    err_count.getAndIncrement();
                                    optSet.add("otherType:"+blackResult.getRId());
                                    writeLogByName(ConstantBlackGrey.PARAM.SAVELOGPATH + dateName + ConstantBlackGrey.PARAM.SEPA + "error.log", "黑转灰时,发现其他类别>>"+blackResult.getRId());
                                }
                            }
                        }

                        //type=11, 恶意投诉客服，一直待在黑名单
                        if(is_type_11){
                            continue;
                        }

                        boolean is_grey_result = true;
                        List<ReasonsVo> reasonsList = null;
                        for(BlackGreyListDetails detailsVo  : detailsList){
                            if(detailsVo.getStatus().intValue()==0){
                                //可以有多个type，说明至少有一个逾期还没还清，就不能转出黑名单
                                is_grey_result = false;
                            }else if(detailsVo.getStatus().intValue()==10){
                                //G_002 发生过15天以上逾期已经结清的客户，从黑名单转标记为灰名单
                                reasonsList = BlackGreyListResult.reasonsToList(blackResult.getReasons(), "G_002", detailsVo.getType());
                            }
                        }

                        if(is_grey_result){
                            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                            //更新明细表
                            DetailsUpdate detailUpdateParam = new DetailsUpdate();
                            detailUpdateParam.setStatus(-2);//由黑名单进入灰名单
                            detailUpdateParam.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                            //条件
                            detailUpdateParam.setRId(blackResult.getRId());
                            detailUpdateParam.setWEqStatus(10);
                            detailUpdateParam.setWInType(Arrays.asList(ConstantBlackGrey.PARAM.BLACK_LIST_TYPES)); //('1','2','10')
                            int update_d = blackGreyListMapper.updateDetailsStatusByparams(detailUpdateParam);
                            if(update_d>0){
                                update_d_count.getAndAdd(update_d);
                            }
                            log.info("黑名单转灰名单-明细表修改状态结束, param: {} , update_d: {} ", JSON.toJSONString(detailUpdateParam), update_d);

                            //更新结果表
                            BlackGreyListResult updateResult = new BlackGreyListResult();
                            updateResult.setRId(blackResult.getRId());//条件
                            updateResult.setUpdatedAt(timestamp);
                            updateResult.setBlackType("2");
                            ////updateResult.setTypes(blackResult.getTypes());
                            if(reasonsList!=null){
                                updateResult.setReasons(JSON.toJSONString(reasonsList));
                            }
                            int update_r = blackGreyListMapper.updateBlackGreyListResult(updateResult);
                            if(update_r>0){
                                update_r_count.getAndAdd(update_r);
                            }
                            log.info("黑名单转灰名单-结果表修改状态结束, param: {} , update_d: {} ", JSON.toJSONString(updateResult), update_r);

                        }
                    }else {
                        err_count.getAndIncrement();
                        optSet.add("notFindDeatils:"+rId);
                        writeLogByName(ConstantBlackGrey.PARAM.SAVELOGPATH + dateName + ConstantBlackGrey.PARAM.SEPA + "error.log", "黑转灰时,结果表没有发现details>>"+blackResult.getRId());
                    }

                } catch (Exception e) {
                    err_count.getAndIncrement();
                    optSet.add("ERR:" + rId);
                    log.error(log_inf + "黑名单转灰名单执行异常process() threadId:" + threadId, e);
                }
            }else {
                err_count.getAndIncrement();
                optSet.add("uuid空:" + rId);
                log.error("查询逾期黑名单是否已还清-发现uuid为空, threadId_{} , r_Id: {} , uuid: {} , blackType: {} ", threadId, rId, uuid, blackResult.getBlackType());
            }
        }

        log.info(log_inf + "黑名单转灰名单process处理结束CPU_{} , this_list_size: {} , type_11: {} , update_r_count: {} , update_d_count: {} , 失败: {} ,  耗时: {} ",
                threadId, list_size, type_11.get(), update_r_count.get(), update_d_count.get(), err_count.get(),  (System.currentTimeMillis()-start));
    }




   /* @Override
    public void process(int threadId, List<BlackGreyListResult> blackResultList, Set<String> optSet) {
        //yyyyMMdd
        String dateName = df.format(Calendar.getInstance().getTime());
        int list_size = blackResultList.size();

        AtomicInteger remove_count = new AtomicInteger();
        AtomicInteger err_count = new AtomicInteger();
        AtomicInteger type_11 = new AtomicInteger();

        int index = 0;
        for (BlackGreyListResult blackResult : blackResultList) {
            //blackResult r_id,uuid,black_type,types,reasons
            //`status` tinyint(2) DEFAULT '1' COMMENT '状态 0:正常有效的； -1:由灰名单进入黑名单(无效，逻辑删除的)； -2:由黑名单进入灰名单(无效，逻辑删除的)； -3:在插入灰名单时，已经是黑名单； 10：当前在黑名单，并且该条数据逾期已还清的',
            log.info("threadId_{}: 开始执行list_size: {} , this: {} ", threadId , list_size, (++index));
            try {
                BlackGreyListQueryVo queryParam = BlackGreyListQueryVo.builder().rId(blackResult.getRId()).build();
                List<BlackGreyListRjoinDVo> rJoinDVoList = blackGreyListMapper.findBlackGreyListRjoinD(queryParam);

                if (rJoinDVoList!=null && rJoinDVoList.size()>0) {
                    boolean is_type_11 = false;
                    for(BlackGreyListRjoinDVo rJoinDVo : rJoinDVoList){
                        //type=11, 恶意投诉客服，一直在黑名单
                        if("11".equals(rJoinDVo.getType()) && rJoinDVo.getStatus()==0){
                            type_11.getAndIncrement();
                            is_type_11=true;
                            break;
                        }
                        //现金贷
                        else if("1".equals(rJoinDVo.getType()) && rJoinDVo.getStatus()==0){
                            //#现金分期在逾转已还 (条件为step1的表内join_black_reason=1的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)

                            //查询现金贷逾期，是否逾期已还清
                            Integer in_overdue_Obj = null;
                            if(StringUtils.isNotEmpty(rJoinDVo.getUuid())){
                                try {
                                    in_overdue_Obj = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_XIANJINDAI_IS_PAYOFF, new Object[]{rJoinDVo.getUuid()}, Integer.class);
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询[现金贷]逾期逾期黑名单是否已还清-查询xyqb异常, r_Id: {} , id: {} , uuid: {} , e: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), e.toString());
                                }finally {
                                    log.info("查询[现金贷]逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , in_overdue_Obj : {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                }
                            }else {
                                log.error("查询[现金贷]逾期逾期黑名单是否已还清-发现uuid为空, r_Id: {} , id: {} , id_No: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getIdNo());
                                continue;
                            }

                            //修改结果表状态为10
                            updateDetailStatus10(in_overdue_Obj, rJoinDVo, "现金贷");
                        }

                        //白条
                        else if("2".equals(rJoinDVo.getType()) && rJoinDVo.getStatus()==0){
                            //#白条在逾转已还 (条件为step1的表内join_black_reason=3的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)

                            //查询白条逾期逾期黑名单是否已还清
                            Integer in_overdue_Obj = null;
                            if(StringUtils.isNotEmpty(rJoinDVo.getUuid())){
                                try {
                                    in_overdue_Obj = xyqbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_BAITIAO_IS_PAYOFF, new Object[]{rJoinDVo.getUuid()}, Integer.class);
                                }catch (EmptyResultDataAccessException e){
                                    log.error("查询[白条]逾期逾期黑名单是否已还清-查询xyqb异常, r_Id: {} , id: {} , uuid: {} , e: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), e.toString());
                                }finally {
                                    log.info("查询[白条]逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , in_overdue_Obj : {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                }
                            }else {
                                log.error("查询[白条]逾期逾期黑名单是否已还清-发现uuid为空, r_Id: {} , id: {} , id_No: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getIdNo());
                                continue;
                            }

                            //修改结果表状态为10
                            updateDetailStatus10(in_overdue_Obj, rJoinDVo, "白条");
                        }

                        //Vcc
                        else if("10".equals(rJoinDVo.getType()) && rJoinDVo.getStatus()==0){
                            // #vcc在逾转已还 (条件为step1的表内join_black_reason=2的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)

                            Integer in_overdue_Obj = null;
                            if(StringUtils.isNotEmpty(rJoinDVo.getUuid())){
                                XyqbUser xyqbUser = queryXyqbUserByUuid(rJoinDVo.getUuid());
                                if(xyqbUser!=null && xyqbUser.getId()!=0L){
                                    try {
                                        in_overdue_Obj = acsdbJdbcTemplate.queryForObject(ConstantBlackGrey.SQL.XYQB_QUERY_VCC_IS_PAYOFF, new Object[]{xyqbUser.getId()}, Integer.class);
                                    }catch (EmptyResultDataAccessException e){
                                        log.error("查询[VCC]逾期逾期黑名单是否已还清-查询xyqb异常, r_Id: {} , id: {} , uuid: {} , user_id: {} , e: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), xyqbUser.getId(), e.toString());
                                    }finally {
                                        log.info("查询[VCC]逾期逾期黑名单是否已还清-结束, r_Id: {} , id: {} , uuid: {} , user_id: {} , in_overdue_Obj : {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getUuid(), xyqbUser.getId(), in_overdue_Obj!=null? in_overdue_Obj.toString(): "null");
                                    }

                                    //修改结果表状态为10
                                    updateDetailStatus10(in_overdue_Obj, rJoinDVo, "VCC");
                                }

                            }else {
                                log.error("查询[VCC]逾期逾期黑名单是否已还清-发现uuid为空, r_Id: {} , id: {} , id_No: {} ", rJoinDVo.getRId(), rJoinDVo.getId(), rJoinDVo.getIdNo());
                                continue;
                            }

                        }else{
                            err_count.getAndIncrement();
                            optSet.add("otherType:"+blackResult.getRId());
                            writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                        }
                    }

                    //type=11, 恶意投诉客服，一直待在黑名单
                    if(is_type_11){
                        continue;
                    }

                    boolean is_grey_result = true;
                    List<ReasonsVo> reasonsList = null;
                    for(BlackGreyListRjoinDVo rJoinDVo : rJoinDVoList){
                        if(rJoinDVo.getStatus()==0){
                            //可以有多个type，说明至少有一个逾期还没还清，就不能转出黑名单
                            is_grey_result = false;
                        }else if(rJoinDVo.getStatus()==10){
                            //Set<String> typeSet = BlackGreyListResult.typesToSet(blackResult.getTypes(), rJoinDVo.getType());
                            reasonsList = BlackGreyListResult.reasonsToList(blackResult.getReasons(), "6", rJoinDVo.getType());
                        }
                    }

                    if(is_grey_result){
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                        //update black_grey_list_details set status = ?, updated_at = ? where r_id = ? AND status =10 AND type IN ('1','2','10') ;
                        //int update = blackListJdbcTemplate.update(ConstantBlackGrey.SQL.BL_DELETE_DATAILS_BLACK, -2, timestamp, blackResult.getRId());

                        //更新明细表
                        DetailsUpdate detailUpdateParam = new DetailsUpdate();
                        detailUpdateParam.setStatus(-2);//由黑名单进入灰名单
                        detailUpdateParam.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                        //条件
                        detailUpdateParam.setRId(blackResult.getRId());
                        detailUpdateParam.setWEqStatus(10);
                        detailUpdateParam.setWInType(Arrays.asList(ConstantBlackGrey.PARAM.BLACK_LIST_TYPES)); //('1','2','10')
                        int update_d = blackGreyListMapper.updateDetailsStatusByparams(detailUpdateParam);

                        //更新结果表
                        BlackGreyListResult updateResult = new BlackGreyListResult();
                        updateResult.setRId(blackResult.getRId());//条件
                        updateResult.setUpdatedAt(timestamp);
                        updateResult.setBlackType("2");
                        //updateResult.setTypes(blackResult.getTypes());
                        if(reasonsList!=null){
                            updateResult.setReasons(JSON.toJSONString(reasonsList));
                        }

                        int update_r = blackGreyListMapper.updateBlackGreyListResult(updateResult);
                        if(update_d>0 && update_r>0){
                            remove_count.getAndIncrement();
                        }
                    }
                }else {
                    err_count.getAndIncrement();
                    optSet.add("notFind:"+blackResult.getRId());
                    writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                }

            } catch (Exception e) {
                optSet.add("ERR:" + blackResult.getRId());
                log.error(log_inf + "process() threadId:" + threadId + ",ERROR!", e);
            }

        }
        log.info(log_inf + "处理结束 CPU_{} , remove_count:{} , 失败:{} , this_list_size: {} ", threadId, remove_count.get(), err_count.get(), list_size);
    }
*/
    //-------------------------------------------------------------------------

    private static void writeLogByName(String fileName, String msg) {
        String time = ConstantBlackGrey.PARAM.DF_YMDHMS.format(System.currentTimeMillis());
        try {
            FileUtils.write(new File(fileName), time + " " +msg + "\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error," + msg + "," + e.toString());
        }
    }


    private XyqbUser queryXyqbUserByUuid(String uuid) {
        String sql_byUUid = "select u.id, u.uuid, u.phone_no from `user` u where u.uuid=? AND u.`enable`=1 ";
        List<XyqbUser> xyqbUserList = null;
        try {
            xyqbUserList = xyqbUserJdbcTemplate.query(sql_byUUid, new Object[]{uuid}, new RowMapper<XyqbUser>() {
                @Override
                public XyqbUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                    XyqbUser bean = new XyqbUser();
                    bean.setId(rs.getLong("id"));
                    bean.setUuid(rs.getString("uuid"));
                    bean.setPhoneNo(rs.getString("phone_no"));
                    return bean;
                }
            });


        } catch (Exception e) {
            log.error("根据uuid查询xyqb用户异常, uuid: {} ", uuid, e);
        }

        if(xyqbUserList!=null && xyqbUserList.size()>0){
            return xyqbUserList.get(0);
        }
        return null;
    }

    //将黑名单明细表的状态改为10
    private int updateDetailStatus10(Integer in_overdue_Obj, BlackGreyListDetails rJoinDVo, String log_inf){ //BlackGreyListRjoinDVo >> BlackGreyListDetails
        //修改结果表状态为10
        try {
            if(in_overdue_Obj!=null && StringUtils.isNotEmpty(in_overdue_Obj.toString())){
                int in_overdue = Integer.parseInt(in_overdue_Obj.toString());
                if(in_overdue ==0 ){
                    DetailsUpdate detailUpdateParam = new DetailsUpdate();
                    detailUpdateParam.setStatus(10);//当前在黑名单，并且该条数据逾期已还清的
                    detailUpdateParam.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                    //条件
                    detailUpdateParam.setRId(rJoinDVo.getRId());
                    detailUpdateParam.setWEqType(rJoinDVo.getType());
                    detailUpdateParam.setWEqStatus(0);
                    int update = blackGreyListMapper.updateDetailsStatusByparams(detailUpdateParam);
                    if(update>0){
                        //用于修改结果表标记
                        rJoinDVo.setStatus(10);
                    }
                    return update;
                }
            }
        }catch (Exception e){
            log.error("查询("+log_inf+")逾期逾期黑名单是否已还清-修改结果表状态为10出现异常, r_Id: {} , id: {}  ", rJoinDVo.getRId(), rJoinDVo.getId(), e);
        }
        return 0;
    }

}
