package cn.quantgroup.qgblservice.utils.jdbc;

import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyList;
import cn.quantgroup.qgblservice.utils.MD5Util;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.*;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * Created by renfeng on 2019/4/22.
 */
public class JdbcExecuters {

    private static final Logger log = LoggerFactory.getLogger(JdbcExecuters.class);

    public static int blackListImportBatchExecute(List<BlackListQueryTidbVo0> blackListQueryTidbVo0s, String sql, JdbcTemplate jdbcTemplate, String type) {
        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {

            conn = jdbcTemplate.getDataSource().getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

                BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                ps.setString(1, blackListQueryTidbVo0.getUuid());
                ps.setString(2, blackListQueryTidbVo0.getName());
                ps.setString(3, blackListQueryTidbVo0.getPhoneNo());
                ps.setString(4, blackListQueryTidbVo0.getIdNo());
                ps.setString(5, blackListQueryTidbVo0.getMajorType());
                ps.setString(6, blackListQueryTidbVo0.getType());
                ps.setString(7, blackListQueryTidbVo0.getTotalOverdueDays());
                ps.setString(8, blackListQueryTidbVo0.getMaxOverdueDays());
                ps.setString(9, blackListQueryTidbVo0.getBlackLevel());
                ps.setString(10, blackListQueryTidbVo0.getJoinBlackReason());
                ps.setTimestamp(11, blackListQueryTidbVo0.getCreatedAt());
                ps.setTimestamp(12, blackListQueryTidbVo0.getUpdatedAt());

                //modify 2019.09.20 增加phone_no_md5、id_no_md5
                String phoneNo_md5 = null, idCard_md5 = null;
                if(StringUtils.isNotEmpty(blackListQueryTidbVo0.getPhoneNo())){
                    phoneNo_md5 = MD5Util.getMD5Digest(blackListQueryTidbVo0.getPhoneNo());
                }
                if(StringUtils.isNotEmpty(blackListQueryTidbVo0.getIdNo())){
                    idCard_md5 = MD5Util.getMD5Digest(blackListQueryTidbVo0.getIdNo());
                }
                ps.setString(13,phoneNo_md5);
                ps.setString(14,idCard_md5);


                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % 5000 == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }

            ps.executeBatch();
            conn.commit();

        } catch (Exception e) {
            log.error("{} 批量插入数据异常", type, e);
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }


    public static int blackListUpdateBatchExecute(List<BlackListQueryTidbVo0> blackListQueryTidbVo0s, String sql, JdbcTemplate jdbcTemplate, String type) {
        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {

            conn = jdbcTemplate.getDataSource().getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

                BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                ps.setString(1, blackListQueryTidbVo0.getTotalOverdueDays());
                ps.setString(2, blackListQueryTidbVo0.getMaxOverdueDays());
                ps.setTimestamp(3, blackListQueryTidbVo0.getUpdatedAt());
                ps.setLong(4, blackListQueryTidbVo0.getId());

                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % 500 == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }

            ps.executeBatch();
            conn.commit();

        } catch (Exception e) {
            log.error("{} 批量插入数据异常", type, e);
            return 0;
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }


    /**
     * 描述:  根据用户id批量修改 phone_no_md5，id_no_md5  <br/>
     * 参数: [blackListQueryTidbVo0s, sql, jdbcTemplate, type]  <br/>
     * 返回值: int  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.19  <br/>
     */
    public static int blackListUpdateMd5BatchExecute(List<BlackListQueryTidbVo0> blackListQueryTidbVo0s, String sql, JdbcTemplate jdbcTemplate, String type) {
        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {
            conn = jdbcTemplate.getDataSource().getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            //update black_list_new set  phone_no_md5='111' ,id_no_md5='111' where id=111;
            for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {
                BlackListQueryTidbVo0 blackListbean = blackListQueryTidbVo0s.get(i);
                ps.setString(1, blackListbean.getPhoneNoMd5());
                ps.setString(2, blackListbean.getIdNoMd5());
                ps.setLong(3, blackListbean.getId());

                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % 500 == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }

            ps.executeBatch();
            conn.commit();

        } catch (Exception e) {
            log.error("{} 批量修改数据异常", type, e);
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }

    public static int insertBatchExecute(List<TmpBlackGreyList> tmpBlackGreyList, JdbcTemplate jdbcTemplate) {
        String sql = "insert ignore into tmp_black_grey_list (`id`, `uuid`, `name`, `phone_no`, `id_no`, `phone_no_md5`, `id_no_md5`, `black_type`, `type`, `join_black_reason`, `max_overdue_days`, `total_overdue_days`, `created_at`, `updated_at`) " +
                " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";

        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {
            conn = jdbcTemplate.getDataSource().getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < tmpBlackGreyList.size(); i++) {

                TmpBlackGreyList vo = tmpBlackGreyList.get(i);
                ps.setLong(1, vo.getId());
                ps.setString(2, vo.getUuid());
                ps.setString(3, vo.getName());
                ps.setString(4, vo.getPhoneNo());
                ps.setString(5, vo.getIdNo());
                ps.setString(6, vo.getPhoneNoMd5());
                ps.setString(7, vo.getIdNoMd5());
                ps.setString(8, vo.getBlackType());
                ps.setString(9, vo.getType());
                ps.setString(10, vo.getJoinBlackReason());
                ps.setString(11, vo.getMaxOverdueDays());
                ps.setString(12, vo.getTotalOverdueDays());
                ps.setTimestamp(13, vo.getCreatedAt());
                ps.setTimestamp(14, vo.getUpdatedAt());

                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % 1000 == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }
            ps.executeBatch();
            conn.commit();
        } catch (Exception e) {
            log.error("tmp_black_grey_list表批量插入数据异常", e);
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }


    /**
     * 关闭资源
     *
     * @param conn
     * @param st
     * @param rs
     */
    private static void close(Connection conn, Statement st, ResultSet rs) {
        try {
            if (rs != null)
                rs.close();
            if (st != null)
                st.close();
            if (conn != null)
                conn.close();
        } catch (SQLException e) {
            log.error("关闭jdbc资源异常", e);
        }

    }

}
