package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListDetails;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListQueryVo;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListResult;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackListChannelExpireConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyList;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyListRowMapper;
import cn.quantgroup.qgblservice.repository.mybatis.entity.xyqbuser.XyqbUser;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackGreyListService;
import cn.quantgroup.qgblservice.service.IBlackListToolsManagerService;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.ReadExcelUtils;
import cn.quantgroup.qgblservice.utils.ReadOrWriteTxt;
import cn.quantgroup.qgblservice.utils.blacklist.BlackListUtils;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


@Slf4j
@Service
public class BlackListToolsManagerServiceImpl implements IBlackListToolsManagerService {

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    @Autowired
    private JdbcTemplate acsdbJdbcTemplate;

    @Autowired
    @Qualifier(value = "stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    private static Map<String, Integer> channelBlackListExpireConfigMap = new ConcurrentHashMap<>();

    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static int LIMIT = 10000;
    private static int LIMIT_1000 = 1000;
    private static int LIMIT_X = 1000;

    @Autowired
    private IBlackGreyListService blackGreyListService;

    @Autowired
    private BlackGreyListMapper blackGreyListMapper;

    @PostConstruct
    public void initChannelBlackListExpireConfig() {
        List<BlackListChannelExpireConfigVo0> queryBlackListChannelExpireConfigVo0List = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_CHANNEL_BLACK_LIST_EXPIRE_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackListChannelExpireConfigVo0.class));
        channelBlackListExpireConfigMap = queryBlackListChannelExpireConfigVo0List.stream().collect(Collectors.toMap(BlackListChannelExpireConfigVo0::getType, BlackListChannelExpireConfigVo0::getExpireTime));
        log.info("加载渠道黑名单有效期配置完成, result: {} ", JSON.toJSONString(channelBlackListExpireConfigMap));
    }


    @Override
    public GlobalResponse compareByExcel(String filePath,String titleNames,String haveTitle, String byColumnName,String columnDataType) {
        log.info("用户black_list_new黑名单比对开始, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , columnDataType: {} ", filePath, titleNames, haveTitle, byColumnName,columnDataType);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<Map<String,String>> paramsList = new ArrayList<Map<String,String>>();
        if(filePath!=null && byColumnName!=null){
            //1.读取表格
            boolean have = haveTitle!=null && haveTitle.equals("false") ? false:true;//默认有标题
            Map<String, Object> readMap = ReadExcelUtils.readExcel(filePath,titleNames, have);
            List<String> readList = null;
            if(readMap!=null && readMap.get("code").toString().equals("0") && readMap.get("result")!=null) {
                readList = (List<String>) readMap.get("result");
                if(readList==null || readList.size()==0){
                    return GlobalResponse.error("读取文件内容为空！");
                }
            }else{
                return GlobalResponse.error(readMap.get("msg").toString());
            }


            //判断是否MD5数据
            boolean isMD5 = false;
            if(StringUtils.isNotEmpty(columnDataType) && "MD5".equals(columnDataType)){
                isMD5 = true;
            }

            //2.查询
            String sql = "";
            List<BlackListQueryTidbVo0> blackList = new ArrayList<BlackListQueryTidbVo0>();
            //byColumnName:idcard  phoneNo  name
            if(byColumnName.equals("idcard")){
                StringBuffer querysql = new StringBuffer();
                int beachCount = 0;
                for(String params : readList){
                    beachCount++;
                    String tmp[] = params.split("[|]");
                    String tmp_Sql = Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_SQL2;
                    //判断是否MD5数据
                    if(isMD5){
                        tmp_Sql = tmp_Sql.replace("id_no =","id_no_md5 =");
                    }
                    tmp_Sql = String.format(tmp_Sql, tmp[0], tmp[3].substring(0,10)+" 00:00:00");
                    //500条查询一次
                    if(beachCount==500){
                        querysql.append(tmp_Sql);
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                        beachCount=0;
                        querysql = new StringBuffer();
                    }else{
                        querysql.append(tmp_Sql.replace(";", " union all "));
                    }
                }
                //最后不够500
                if(querysql!=null && querysql.length()>0){
                    String sql2 = querysql.toString();
                    if(querysql.toString().endsWith("union all") || querysql.toString().endsWith("union all ")){
                        sql2 = sql2.substring(0,sql2.lastIndexOf("union all"));
                    }
                    if(!querysql.toString().endsWith(";")){
                        sql2 = sql2 + ";";
                    }
                    List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                    if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                        blackList.addAll(tmpQueryList);
                    }
                }
            }else if (byColumnName.equals("mobile")){
                StringBuffer querysql = new StringBuffer();
                int beachCount = 0;
                for(String params : readList){
                    beachCount++;
                    String tmp[] = params.split("[|]");

                    String tmp_Sql = Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_SQL2;
                    //判断是否MD5数据
                    if(isMD5){
                        tmp_Sql = tmp_Sql.replace("phone_no =","phone_no_md5 =");
                    }
                    tmp_Sql = String.format(tmp_Sql, tmp[2], tmp[3].substring(0,10)+" 00:00:00");
                    //500条查询一次
                    if(beachCount==500){
                        querysql.append(tmp_Sql);
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                        beachCount=0;
                        querysql = new StringBuffer();
                    }else{
                        querysql.append(tmp_Sql.replace(";", " union all "));
                    }
                }
                //最后不够500
                if(querysql!=null && querysql.length()>0){
                    String sql_2 = querysql.toString();
                    querysql=null;
                    if(sql_2.toString().endsWith("union all") || sql_2.toString().endsWith("union all ")){
                        sql_2 = sql_2.substring(0,sql_2.lastIndexOf("union all"));
                    }
                    if(!sql_2.toString().endsWith(";")){
                        sql_2 = sql_2 + ";";
                    }
                    List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql_2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                    if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                        blackList.addAll(tmpQueryList);
                    }
                }
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "byColumnName无效的查询类型", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.error("无效的查询类型byColumnName["+byColumnName+"]");
            }

            //3.比较，处理
            if (CollectionUtils.isNotEmpty(blackList)) {
                blackList.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0 && o.isStatus()).forEach(blackListQueryTidbVo0 -> {

                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));
                });

                StringBuffer tmp = new StringBuffer();
                String[] titilName = {"id", "uuid", "name", "phone_no", "id_no", "major_type", "type", "total_overdue_days", "max_overdue_days", "black_level", "join_black_reason", "status", "created_at", "updated_at"};
                //标题
                for (int i = 0; i < titilName.length; i++) {
                    if (i==0){
                        tmp.append(titilName[i]);
                    }else{
                        tmp.append("\t");
                        tmp.append(titilName[i]);
                    }
                }

                for (BlackListQueryTidbVo0 bean:blackList) {
                    tmp.append("\n");
                    tmp.append(bean.getId());
                    tmp.append("\t"+bean.getUuid());
                    tmp.append("\t"+bean.getName());
                    //判断是否MD5数据
                    if (isMD5){
                        tmp.append("\t"+bean.getPhoneNoMd5());
                        tmp.append("\t"+bean.getIdNoMd5());
                    }else {
                        tmp.append("\t"+bean.getPhoneNo());
                        tmp.append("\t"+bean.getIdNo());
                    }
                    tmp.append("\t"+bean.getMajorType());
                    tmp.append("\t"+bean.getType());
                    tmp.append("\t"+(bean.getTotalOverdueDays()!=null ? bean.getTotalOverdueDays(): ""));
                    tmp.append("\t"+(bean.getMaxOverdueDays()!=null ? bean.getMaxOverdueDays(): ""));
                    tmp.append("\t"+bean.getBlackLevel());
                    tmp.append("\t"+bean.getJoinBlackReason());
                    tmp.append("\t"+bean.isStatus());
                    tmp.append("\t"+bean.getJoinBlackTime());
                    tmp.append("\t"+bean.getBlackUpdatedTime());
                }
                String writeFilePath = "";
                if(filePath.lastIndexOf("/")!=-1){//linux
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("/"))+"/"+byColumnName+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }else{//windows
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\"+byColumnName+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }
                ReadOrWriteTxt.writeTxt(writeFilePath,tmp.toString());
                log.info("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, ("导出成功，文件位置:"+writeFilePath), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("导出成功，文件位置:"+writeFilePath);
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "查询为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("查询为空！");
            }
        }
        log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , byColumnName: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, byColumnName, "参数为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return GlobalResponse.error("参数为空！");
    }

    /**
     * 描述: 手动更新black_list_new黑名单表手机号&身份证号md5字段   <br/>
     * 参数: [filePath, titleNames, haveTitle, queryType]  <br/>
     * 返回值: cn.quantgroup.qgblservice.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.10  <br/>
     */
    @Override
    public GlobalResponse buildMd5Tools(String privateKey, String operatType, String idArray, String gtCreatUtc) {
        //Base64.encode("huat24WBoOxpNBpBi5wd8w==")
        if(StringUtils.isNotEmpty(privateKey) && "aHVhdDI0V0JvT3hwTkJwQmk1d2Q4dz09".equals(privateKey)){
            if(StringUtils.isEmpty(operatType)){
                return GlobalResponse.error("参数为空！");
            }
            if("all".equals(operatType)){
                return GlobalResponse.success(dealWithAll());
            }else if("byId".equals(operatType)){
                if(StringUtils.isNotEmpty(idArray) && idArray.indexOf(",,")==-1){
                    return GlobalResponse.success(dealWithById(idArray));
                }else{
                    return GlobalResponse.error("参数为空或不正确！");
                }
            }else if("byCreatUtc".equals(operatType)){
                if(StringUtils.isNotEmpty(gtCreatUtc) && gtCreatUtc.length()==13){
                    Date date = new Date(Long.parseLong(gtCreatUtc));
                    return GlobalResponse.success(dealWithByCreatUtc(sdf.format(date)));
                }else{
                    return GlobalResponse.error("参数为空或不正确！");
                }
            }else{
                return GlobalResponse.error("未知的操作类型！");
            }
        }
        return GlobalResponse.error("私钥为空或不正确，请联系管理员！");
    }

    private String dealWithAll(){
        long star = System.currentTimeMillis();
        final String SQL_MAXID = "select max(id) as 'maxId' from black_list_new;";
        final String SQL_QUERLISTBYID = "select id as 'id', phone_no as 'phone_no', id_no as 'id_no' from black_list_new where id >%d and id<=%d;";
        int maxId = 0;
        int totalCount = 0, runOkCount = 0;
        Map<String, Object> maxIdMap = blackListJdbcTemplate.queryForMap(SQL_MAXID);
        if(maxIdMap!=null && maxIdMap.get("maxId")!=null){
            maxId = Integer.parseInt(String.valueOf(maxIdMap.get("maxId")));
            log.info("dealWith all query  maxId: {} ",maxId);
            int totalPage = maxId/LIMIT;
            if((maxId%LIMIT)!=0){
                totalPage+=1;
            }

            int startId = 0,endId = 0;
            for (int page = 1; page <= totalPage; page++) {
                startId = (page-1) * LIMIT;
                endId = page * LIMIT;
                int batchExecuteResult = 0;
                long startUtc = System.currentTimeMillis();
                List<BlackListQueryTidbVo0> updateBeanList = null;
                try{
                    String query_sql = String.format(SQL_QUERLISTBYID,startId,endId);
                    log.info("dealWith all Start page: {} , startId: {} , endId: {} ",page,startId,endId);
                    List<Map<String, Object>> tmpQueryList = blackListJdbcTemplate.queryForList(query_sql);

                    if(tmpQueryList!=null && tmpQueryList.size()>0){
                        totalCount = totalCount + tmpQueryList.size();
                        updateBeanList = new ArrayList<>();
                        BlackListQueryTidbVo0 bean = null;
                        String phoneNo_md5 = null, idNo_md5 = null;
                        for(Map<String, Object> map : tmpQueryList){
                            phoneNo_md5 = null;
                            idNo_md5 = null;
                            if(map.get("phone_no")!=null && !"".equals(map.get("phone_no").toString())){
                                phoneNo_md5 = MD5Util.getMD5Digest(map.get("phone_no").toString());
                            }
                            if(map.get("id_no")!=null && !"".equals(map.get("id_no").toString())){
                                idNo_md5 = MD5Util.getMD5Digest(map.get("id_no").toString());
                            }
                            if(StringUtils.isNotEmpty(phoneNo_md5) || StringUtils.isNotEmpty(idNo_md5)){
                                bean = new BlackListQueryTidbVo0();
                                bean.setId((Long)map.get("id"));
                                bean.setPhoneNoMd5(phoneNo_md5);
                                bean.setIdNoMd5(idNo_md5);
                                updateBeanList.add(bean);
                            }
                        }
                        if(updateBeanList.size()>0){
                            batchExecuteResult = JdbcExecuters.blackListUpdateMd5BatchExecute(updateBeanList, Constant.SQL.BLACK_LIST_NEW_UPDATE_PHONENOMD5_AND_IDNOMD5_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONESMD5_AND_IDNOMD5_MANUAL);
                            runOkCount = runOkCount+batchExecuteResult;
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                    log.error("dealWith all Error page: {} , startId: {} , endId: {} ",page,startId,endId);
                }finally {
                    log.info("dealWith all End page: {} , startId: {} , endId: {} , list.size: {} , batchExecuteResult: {} ,",page,startId,endId,(updateBeanList!=null ? updateBeanList.size(): 0),batchExecuteResult,((System.currentTimeMillis()-startUtc)+".ms"));
                }
            }
        }
        log.info("dealWithAll Method End, totalCount: {} , runOkCount: {} , total cost: {} ",totalCount,runOkCount,(System.currentTimeMillis()-star)+".ms");
        return "dealWith all OK, totalCount="+totalCount+",runOkCount="+runOkCount;
    }


    private String dealWithById(String idArray){
        long star = System.currentTimeMillis();
        final String SQL_QUERLISTBYID = "select id as 'id', phone_no as 'phone_no', id_no as 'id_no' from black_list_new where id=%s ";
        String[] idArrays = idArray.split(",");
        int maxCount = idArrays.length;
        int runOkCount = 0;
        log.info("dealWith byId query  maxCount: {} ",maxCount);
        int LIMIT = 1000;
        int totalPage = maxCount/LIMIT;
        if((maxCount%LIMIT)!=0){
            totalPage+=1;
        }
        for (int page = 1; page <= totalPage; page++) {
            int startIndex = (page-1) * LIMIT;
            int endIndex = page * LIMIT;
            if(endIndex > maxCount){
                endIndex = maxCount;
            }
            long startUtc = System.currentTimeMillis();
            log.info("dealWith byId Start page: {} , startIndex: {} , endIndex: {} , maxCount: {} ",page,startIndex,endIndex,maxCount);
            StringBuffer querysql = new StringBuffer();
            String[] log_idArry = new String[endIndex-startIndex];
            int c = 0;
            for(int indx = startIndex; indx < endIndex; indx++){
                String tmpsql = String.format(SQL_QUERLISTBYID,idArrays[indx]);
                if(querysql.length()==0){
                    querysql.append(tmpsql);
                }else{
                    querysql.append(" union all ");
                    querysql.append(tmpsql);
                }
                log_idArry[c] = idArrays[indx];
                c++;
            }
            if(querysql.length()>0){
                querysql.append(";");
            }

            int batchExecuteResult = 0;
            List<BlackListQueryTidbVo0> updateBeanList = null;
            try{
                List<Map<String, Object>> tmpQueryList = blackListJdbcTemplate.queryForList(querysql.toString());
                if(tmpQueryList!=null && tmpQueryList.size()>0){
                    updateBeanList = new ArrayList<>();
                    BlackListQueryTidbVo0 bean = null;
                    String phoneNo_md5 = null, idNo_md5 = null;
                    for(Map<String, Object> map : tmpQueryList){
                        phoneNo_md5 = null;
                        idNo_md5 = null;
                        if(map.get("phone_no")!=null && !"".equals(map.get("phone_no").toString())){
                            phoneNo_md5 = MD5Util.getMD5Digest(map.get("phone_no").toString());
                        }
                        if(map.get("id_no")!=null && !"".equals(map.get("id_no").toString())){
                            idNo_md5 = MD5Util.getMD5Digest(map.get("id_no").toString());
                        }
                        if(StringUtils.isNotEmpty(phoneNo_md5) || StringUtils.isNotEmpty(idNo_md5)){
                            bean = new BlackListQueryTidbVo0();
                            bean.setId((Long)map.get("id"));
                            bean.setPhoneNoMd5(phoneNo_md5);
                            bean.setIdNoMd5(idNo_md5);
                            updateBeanList.add(bean);
                        }
                    }
                    if(updateBeanList.size()>0){
                        batchExecuteResult = JdbcExecuters.blackListUpdateMd5BatchExecute(updateBeanList, Constant.SQL.BLACK_LIST_NEW_UPDATE_PHONENOMD5_AND_IDNOMD5_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONESMD5_AND_IDNOMD5_MANUAL);
                        runOkCount+=batchExecuteResult;
                    }
                }
            }catch (Exception e){
                e.printStackTrace();
                log.error("dealWith byId Error page: {} , startIndex: {} , endIndex: {} , ids: {} ",page,startIndex,endIndex,String.join(",",log_idArry));
            }finally {
                log.info("dealWith byId End page: {} , startIndex: {} , endIndex: {} , list.size: {} , batchExecuteResult: {} ,",page,startIndex,endIndex,(updateBeanList!=null ? updateBeanList.size(): 0),batchExecuteResult,((System.currentTimeMillis()-startUtc)+".ms"));
            }
        }
        log.info("dealWithById Method End, totalCount: {} , runOkCount: {} , total cost: {} ",maxCount,runOkCount,(System.currentTimeMillis()-star)+".ms");
        return "dealWith byId OK, totalCount="+maxCount+",runOkCount="+runOkCount;
    }


    private String dealWithByCreatUtc(String nyr){
        return "暂不支持根据created_at操作.";
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: black_list_new 数据，往tmp_black_grey_list清洗<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.02 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     */
    @Async
    @Override
    public void cleanTableData(String privateKey, String operatType) {
        if(StringUtils.isEmpty(operatType)){
            log.error("cleanTableData参数为空！");
            return;
        }

        if("copyBlackList".equals(operatType)){
            //copyBlackListNew();
            log.warn("该方法值执行一次，已经执行!");
        }
        else if("updat_idNoIsPhone".equals(operatType)){
            String sql_query = "select b.id, b.uuid, b.name, b.phone_no, b.id_no, b.black_type, b.type, b.join_black_reason, b.max_overdue_days, b.total_overdue_days, b.created_at, b.updated_at " +
                   " from tmp_black_grey_list b where LENGTH(b.id_no)=11; "; //5010条
            String sql_update = " update tmp_black_grey_list set phone_no=?, phone_no_md5= ?, id_no=?, id_no_md5=?, name=?  where id=? ";
            //updat_idNoIsPhone(sql_query, sql_update, "1");
        }
        else if("updat_PhoneNot11".equals(operatType)){
            String sql_query = "select b.id, b.uuid, b.name, b.phone_no, b.id_no, b.black_type, b.type, b.join_black_reason, b.max_overdue_days, b.total_overdue_days, b.created_at, b.updated_at " +
                    " from tmp_black_grey_list b where LENGTH(b.phone_no)!=11; "; //5398条
            String sql_update = " update tmp_black_grey_list set phone_no=?, phone_no_md5= ?, id_no=?, id_no_md5=?, name=?  where id=? ";
            //updat_idNoIsPhone(sql_query, sql_update, "2");
        }
        else if("update_huiTohei_type1".equals(operatType)){
           // update_huiTohei_type1();
        }
        else if("update_huiTohei_type2".equals(operatType)){
            // update_huiTohei_type2();
        }
        else if("update_huiTohei_type10".equals(operatType)){
            //update_huiTohei_type10();
        }
        else if("tmpBlackGreyToProduct".equals(operatType)){
            //tmpBlackGreyToProduct();
        }

        if("copyBlackGreyListResult_old2".equals(operatType)){
            copyBlackGreyListResult_old2();
        }


        //测试job中的方法
        //现金分期，每日逾期15+用户 每日执行导入新的黑名单表
        else if("importXianJinDaiBlackGreyList".equals(operatType)){
            blackGreyListService.importXianJinDaiBlackGreyList();
        }
        //vcc逾期，每日逾期15+用户 每日执行导入新的黑名单表
        else if("importVccBlackGreyList".equals(operatType)){
            blackGreyListService.importVccBlackGreyList();
        }
        //逾期已还清黑名单>>转灰名单
        else if("removeBlackToGreyList".equals(operatType)){
            blackGreyListService.removeBlackToGreyList();
        }
        //更新黑名单>>逾期天数
        else if("updateBlackListOverdueDay".equals(operatType)){
            blackGreyListService.updateBlackListOverdueDay();
        }

        else{
            log.error("cleanTableData未知的操作类型！");
            return;
        }
    }


    private void copyBlackListNew(){
        long star = System.currentTimeMillis();
        final String SQL_MAXID = "SELECT max(id) as 'maxId' FROM black_list_new;";
        String SQL_QUERY = "SELECT b.id, b.uuid, b.name, b.phone_no, b.id_no, " +
                "if(type=11,'1','2') black_type, b.type, if(b.type=11,'4','5') join_black_reason, " +
                " b.max_overdue_days, b.total_overdue_days, b.created_at, b.updated_at" +
                " FROM black_list_new b WHERE id > ? and id<=?;";

        int maxId = 0;
        int totalCount = 0, runOkCount = 0;
        Map<String, Object> maxIdMap = blackListJdbcTemplate.queryForMap(SQL_MAXID);
        if(maxIdMap!=null && maxIdMap.get("maxId")!=null){
            maxId = Integer.parseInt(String.valueOf(maxIdMap.get("maxId")));
            log.info("dealWith all query  maxId: {} ",maxId);

            int totalPage = maxId/LIMIT_1000;
            if((maxId%LIMIT_1000)!=0){
                totalPage+=1;
            }

            int startId = 0,endId = 0;
            for (int page = 1; page <= totalPage; page++) {
                startId = (page-1) * LIMIT_1000;
                endId = page * LIMIT_1000;

                int batchExecuteResult = 0;
                long startUtc = System.currentTimeMillis();
                List<TmpBlackGreyList> updateBeanList = null;

                try{
                    //String query_sql = String.format(SQL_QUERLISTBYID,startId,endId);

                    log.info("dealWith all Start page: {} , startId: {} , endId: {} ------>>>>>>", page, startId, endId);

                    List<TmpBlackGreyList> tmpQueryList = blackListJdbcTemplate.query(SQL_QUERY, new Object[]{startId, endId}, new TmpBlackGreyListRowMapper());

                    if(tmpQueryList!=null && tmpQueryList.size()>0){
                        totalCount = totalCount + tmpQueryList.size();
                        updateBeanList = new ArrayList<>();
                        for(TmpBlackGreyList queryBean : tmpQueryList){

                            if(queryBean.getUuid()!=null){
                                if(queryBean.getUuid().equals("null")){
                                    queryBean.setUuid(null);
                                }
                            }
                            if(queryBean.getName()!=null){
                                if(queryBean.getName().equals("null")){
                                    queryBean.setName(null);
                                }

                            }
                            if(queryBean.getPhoneNo()!=null){
                                if(queryBean.getPhoneNo().equals("null")){
                                    queryBean.setPhoneNo(null);
                                }
                                //手机号等于姓名的
                                else if(queryBean.getName()!=null && queryBean.getPhoneNo().equals(queryBean.getName()) && BlackListUtils.isContainChinese(queryBean.getPhoneNo())){
                                    queryBean.setPhoneNo(null);
                                }
                            }
                            if(queryBean.getIdNo()!=null){
                                if(queryBean.getIdNo().equals("null") || queryBean.getIdNo().equals("1")){
                                    queryBean.setIdNo(null);
                                }
                                //`440582199711272032
                                else if(queryBean.getIdNo().length()==19 && queryBean.getIdNo().startsWith("`")){
                                    queryBean.setIdNo(queryBean.getIdNo().substring(1, queryBean.getIdNo().length()));
                                }
                                //3.5058219811212e+17
                                else if (queryBean.getIdNo().length()!=15 && queryBean.getIdNo().length()!=18
                                        && queryBean.getIdNo().contains(".") && queryBean.getIdNo().contains("+")){
                                    queryBean.setIdNo(null);
                                }
                            }

                            //姓名和身份证反了
                            if(queryBean.getName()!=null && queryBean.getIdNo()!=null && (queryBean.getName().length()==15 || queryBean.getName().length()==18)){
                                String idNo = queryBean.getIdNo();
                                String  name = queryBean.getName();
                                if(BlackListUtils.isContainChinese(idNo) && BlackListUtils.isIDNumber(name)){
                                    queryBean.setName(idNo);
                                    queryBean.setIdNo(name);
                                }
                            }

                            if(queryBean.getIdNo()!=null){
                                queryBean.setIdNoMd5(MD5Util.getMD5Digest(queryBean.getIdNo().toUpperCase()));
                            }
                            if(queryBean.getPhoneNo()!=null){
                                queryBean.setPhoneNoMd5(MD5Util.getMD5Digest(queryBean.getPhoneNo()));
                            }

                            updateBeanList.add(queryBean);
                        }

                        if(updateBeanList.size()>0){
                            batchExecuteResult = JdbcExecuters.insertBatchExecute(updateBeanList, blackListJdbcTemplate);
                            runOkCount = runOkCount+batchExecuteResult;
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                    log.error("方法copyBlackListNew()处理异常, page: {} , startId: {} , endId: {} ", page, startId, endId);
                }finally {
                    log.info("方法copyBlackListNew()处理End page: {} , startId: {} , endId: {} , list.size: {} , batchExecuteResult: {} <<<<<<------\n",page,startId,endId,(updateBeanList!=null ? updateBeanList.size(): 0),batchExecuteResult,((System.currentTimeMillis()-startUtc)+".ms"));
                }
            }
        }
        log.info("\n>>>>>>方法copyBlackListNew()处理 Method End, totalCount: {} , runOkCount: {} , total cost: {} <<<<<<",totalCount,runOkCount,(System.currentTimeMillis()-star)+".ms");
        //return "dealWith all OK, totalCount="+totalCount+",runOkCount="+runOkCount;
    }


    private void copyBlackGreyListResult_old2() {
        long startTime = System.currentTimeMillis();

        int pageSize = 1000;
        int offset = 0;
        String sql_tmp = "SELECT r.* FROM black_grey_list_result_old2 r ORDER BY r.r_id LIMIT ?, ? ; ";

        int count_query = 0;
        int count_insert = 0;

        while (true) {
            long start = System.currentTimeMillis();
            try{
                List<BlackGreyListResult> tmpQueryList = blackListJdbcTemplate.query(sql_tmp, new Object[]{offset, pageSize}, new RowMapper<BlackGreyListResult>() {
                    @Override
                    public BlackGreyListResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                        BlackGreyListResult bean = new BlackGreyListResult();
                        bean.setRId(rs.getString("r_id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setName(rs.getString("name"));
                        bean.setPhoneNo(rs.getString("phone_no"));
                        bean.setIdNo(rs.getString("id_no"));
                        bean.setPhoneNoMd5(rs.getString("phone_no_md5"));
                        bean.setIdNoMd5(rs.getString("id_no_md5"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setTypes(rs.getString("types"));
                        bean.setReasons(rs.getString("reasons"));
                        bean.setCreatedAt(rs.getTimestamp("created_at"));
                        bean.setUpdatedAt(rs.getTimestamp("updated_at"));
                        return bean;
                    }
                });

                if(tmpQueryList!=null && tmpQueryList.size() >0){
                    count_query+=tmpQueryList.size();

                    for (BlackGreyListResult blackGreyListResult : tmpQueryList){
                        try{
                            int ins =  blackGreyListMapper.insertBlackGreyListResult(blackGreyListResult);
                            count_insert+=ins;
                        }catch (Exception e){
                            log.error("插入黑灰名单结果表异常, offset: {} , pageSize: {} , bean: {} ", offset, pageSize, JSON.toJSONString(blackGreyListResult), e);
                        }
                    }
                }else {
                    break;
                }

            }catch (Exception e){
                log.error("插入黑灰名单结果表异常, offset: {} , pageSize: {}  ", offset, pageSize);
            }finally {
                log.info("插入结束, offset: {} , pageSize: {} , 耗时: {} ", offset, pageSize, (System.currentTimeMillis()-start));

                offset=offset + pageSize;
            }
        }

        log.info("黑转灰-查询黑灰名单结果表结束, 查询大小: {} , 插入大小: {} , 耗时: {} ", count_query, count_insert, (System.currentTimeMillis()-startTime));
    }




    private void updat_idNoIsPhone(String sql_query, String sql_update, String type) {
        long star = System.currentTimeMillis();

        List<TmpBlackGreyList> tmpQueryList = null;
        List<TmpBlackGreyList> updateBeanList = null;
        int batchResult = 0;

        try {
            tmpQueryList = blackListJdbcTemplate.query(sql_query, new Object[]{}, new TmpBlackGreyListRowMapper());
            log.info("方法copyBlackListNew()查询列表大小: {}", tmpQueryList != null ? tmpQueryList.size() : "null");
            if (tmpQueryList != null && tmpQueryList.size() > 0) {

                updateBeanList = new ArrayList<>();
                for (TmpBlackGreyList queryBean : tmpQueryList) {

                    if("1".equals(type)){
                        if (queryBean.getIdNo() != null && queryBean.getIdNo().length() == 11) {
                            if (queryBean.getPhoneNo() == null) {
                                queryBean.setPhoneNo(queryBean.getIdNo());
                                queryBean.setPhoneNoMd5(MD5Util.getMD5Digest(queryBean.getIdNo()));
                                queryBean.setIdNo(null);
                                queryBean.setIdNoMd5(null);

                                updateBeanList.add(queryBean);
                            }
                        }
                    }
                    else if("2".equals(type)){
                        if (queryBean.getPhoneNo() != null && queryBean.getPhoneNo().length() != 11) {

                            //手机和姓名颠倒的
                            if (queryBean.getName()!=null && queryBean.getPhoneNo()!=null && BlackListUtils.isChinaPhone(queryBean.getName()) && BlackListUtils.isContainChinese(queryBean.getPhoneNo())) {
                                String name = queryBean.getName();
                                String phone = queryBean.getPhoneNo();
                                queryBean.setPhoneNo(name);
                                queryBean.setPhoneNoMd5(MD5Util.getMD5Digest(name));
                                queryBean.setName(phone);

                                updateBeanList.add(queryBean);
                            }
                            //手机号结尾"
                            else if(queryBean.getPhoneNo().length()==12 && queryBean.getPhoneNo().endsWith("\"")){
                                queryBean.setPhoneNo(queryBean.getPhoneNo().substring(0,11));
                                queryBean.setPhoneNoMd5(MD5Util.getMD5Digest(queryBean.getPhoneNo()));
                                updateBeanList.add(queryBean);
                            }
                            //手机号是姓名的
                            else if(BlackListUtils.isContainChinese(queryBean.getPhoneNo())) {
                                if(queryBean.getName()==null){
                                    queryBean.setName(queryBean.getPhoneNo());
                                }
                                queryBean.setPhoneNo(null);
                                queryBean.setPhoneNoMd5(null);

                                updateBeanList.add(queryBean);
                            }
                        }
                    }

                }
                log.info("方法copyBlackListNew()过滤后的list大小: {} ", updateBeanList.size());
                if (updateBeanList.size() > 0) {
                    //batchResult = JdbcExecuters.updateBatchExecute(updateBeanList, sql_update, blackListJdbcTemplate, "updat_idNoIsPhone");
                    /*for (TmpBlackGreyList bean : updateBeanList) {
                        StringBuffer buff = new StringBuffer();
                        buff.append(" update tmp_black_grey_list set ");
                        buff.append(" phone_no="+bean.getPhoneNo());
                        buff.append(", phone_no_md5="+bean.getPhoneNoMd5());
                        buff.append(", id_no="+bean.getIdNo());
                        buff.append(", id_no_md5="+bean.getIdNoMd5());
                        buff.append(", name="+bean.getName());
                        buff.append(" where id="+bean.getId());
                        buff.append(";");
                        log.info(buff.toString());
                    }*/
                    for (TmpBlackGreyList bean : updateBeanList) {
                        List<TmpBlackGreyList> updateBean = new ArrayList<TmpBlackGreyList>();
                        updateBean.add(bean);
                        try{
                            batchResult+= JdbcExecuters.updateBatchExecute(updateBean, sql_update, blackListJdbcTemplate, "updat_idNoIsPhone");
                        }catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("方法copyBlackListNew()处理异常", e);
        }

        log.info("\n>>>>>>方法copyBlackListNew()处理结束, 查询大小: {} , 过滤后大小: {} , 更新大小: {} , total cost: {} <<<<<<", tmpQueryList.size(), updateBeanList.size(), batchResult, (System.currentTimeMillis() - star) + ".ms");
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 将tmp_black_grey_list表，black_type=2 && type=1(现金贷)的，符合条件的更新为黑名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.13 14:31 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.13 14:31 <br>
     * 入参说明: [] <br>
     * 出参说明: void <br>
     * -----------------------------------------------------------------------------
     */
    private void update_huiTohei_type1(){
        long totalStar = System.currentTimeMillis();

        //blackListJdbcTemplate
        String sql_blacklist3_query = "SELECT t.id, t.uuid, t.`name`, t.phone_no, t.id_no, t.black_type, t.type from tmp_black_grey_list t " +
                " WHERE t.black_type='2' AND t.type='1'" +
                " AND id > ? AND id<=?;";

        //xyqbJdbcTemplate
        String sql_xyqb_query_type1 = "select count(distinct a.user_id) in_overdue " +
                "from repayment_plan a " +
                "left join loan_application_manifest_history b " +
                "on a.loan_application_history_id=b.loan_application_history_id " +
                "left join user c on a.user_id=c.id " +
                "where c.uuid='##UUID##' " +
                "and b.transaction_status in (2,5) " +
                "and a.repayment_status not in (3,4) and a.deadline<=CURDATE()";

        //int maxId = 11429420;
        int maxId = 0;
        try{
            String value = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_MAXID_TYPE1");
            if(StringUtils.isNotEmpty(value)){
                maxId = Integer.parseInt(value);
            }
        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", "UPDATE_HUITOHEI_MAXID_TYPE1", e);
        }
        log.info("方法update_huiTohei_type1()查询缓存, maxId : {} ", maxId);
        if(maxId<=0){
            return;
        }

        int totalQueryCount = 0, totalUpdateCount = 0, totalOkCount = 0;
        int totalPage = maxId/LIMIT_1000;
        if((maxId%LIMIT_1000)!=0){
            totalPage+=1;
        }

        int startId = 0,endId = 0;
        for (int page = 1; page <= totalPage; page++) {
            startId = (page-1) * LIMIT_1000;
            endId = page * LIMIT_1000;

            long thisPageStart= System.currentTimeMillis();
            List<TmpBlackGreyList> updateBeanList = null;
            int thisPageOk = 0;

            try{
                log.info("方法update_huiTohei_type1()处理开始 page: {} , startId: {} , endId: {} , totalPage: {} ------>>>>>>", page, startId, endId, totalPage);
                List<TmpBlackGreyList> tmpQueryList = blackListJdbcTemplate.query(sql_blacklist3_query, new Object[]{startId, endId}, new RowMapper<TmpBlackGreyList>() {
                    @Override
                    public TmpBlackGreyList mapRow(ResultSet rs, int rowNum) throws SQLException {
                        TmpBlackGreyList bean = new TmpBlackGreyList();
                        bean.setId(rs.getLong("id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setName(rs.getString("name"));
                        bean.setPhoneNo(rs.getString("phone_no"));
                        bean.setIdNo(rs.getString("id_no"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setType(rs.getString("type"));
                        return bean;
                    }
                });

                if(tmpQueryList!=null && tmpQueryList.size()>0){

                    totalQueryCount = totalQueryCount + tmpQueryList.size();
                    updateBeanList = new ArrayList<>();

                    for(TmpBlackGreyList queryBean : tmpQueryList){

                        if(queryBean.getUuid()==null){
                            log.info("方法update_huiTohei_type1()检测用户信息id:{} 的uuid是空的", queryBean.getId());
                            if(StringUtils.isNotEmpty(queryBean.getIdNo()) && StringUtils.isNotEmpty(queryBean.getName())){

                                String sql_query_byIdNo = "select u.id, u.uuid as uuid, d.id as userId, d.`name`, d.phone_no, d.id_no from user_detail d left join user u on d.user_id=u.id " +
                                        "where u.`enable`=1 AND d.id_no='"+queryBean.getIdNo().trim().toUpperCase()+"' AND d.`name`='"+queryBean.getName().trim()+"' LIMIT 1 ";

                                Map<String, Object> tmpMap = null;
                                try {
                                    tmpMap = xyqbUserJdbcTemplate.queryForMap(sql_query_byIdNo);
                                }catch (EmptyResultDataAccessException e){
                                    log.error("补全用户信息uuid异常, idNo: {} , name: {} , e: {} ", queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().trim(), e.toString());
                                }

                                if(tmpMap!=null && tmpMap.get("uuid")!=null && StringUtils.isNotEmpty(tmpMap.get("uuid").toString())){
                                    queryBean.setUuid(tmpMap.get("uuid").toString());
                                    //为了标记，修改uuid
                                    queryBean.setRemark(tmpMap.get("uuid").toString());
                                    log.info("方法update_huiTohei_type1()检测用户信息id:{} 的uuid是空, 但根据id_no和name补全了uuid={}, id_no={}, name={} ", queryBean.getId(), queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().toUpperCase());
                                }
                            }
                        }

                        if(StringUtils.isNotEmpty(queryBean.getUuid())){
                            queryBean.setBlackType("2");
                            queryBean.setJoinBlackReason("6");

                            Map<String, Object> in_overdue_Map = null;
                            try {
                                in_overdue_Map = xyqbJdbcTemplate.queryForMap(sql_xyqb_query_type1.replace("##UUID##", queryBean.getUuid()));
                            }catch (EmptyResultDataAccessException e){
                                log.error("查询逾期in_overdue_Map异常, uuid: {} , idNo: {} , name: {} , e: {} ", queryBean.getUuid(), queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().trim(), e.toString());
                            }

                            if(in_overdue_Map!=null && in_overdue_Map.get("in_overdue")!=null && StringUtils.isNotEmpty(in_overdue_Map.get("in_overdue").toString())){
                                int in_overdue = Integer.parseInt(in_overdue_Map.get("in_overdue").toString());
                                if(in_overdue >=1 ){
                                    queryBean.setBlackType("1");
                                    queryBean.setJoinBlackReason("1");
                                }
                            }
                            updateBeanList.add(queryBean);
                            totalUpdateCount++;
                        }else{
                            log.warn("查询in_overdue时用户uuid为空跳过, id: {} ", queryBean.getId());
                        }
                    }
                    log.info("方法update_huiTohei_type1()筛选结束, page: {} , startId: {} , endId: {}, list大小: {} ", page, startId, endId, updateBeanList.size());

                    if(updateBeanList.size()>0){
                        //batchResult = JdbcExecuters.updateBatchExecute(updateBean, sql_update_type1, blackListJdbcTemplate, "update_huiTohei_type1");
                        String sql_update_type1 = "update tmp_black_grey_list set black_type='##black_type##', join_black_reason='##join_black_reason##' ##have_UUID## where id=##id##";

                        for (TmpBlackGreyList bean : updateBeanList) {
                            try{
                                String sql_tmp = sql_update_type1.replace("##id##", ""+bean.getId());
                                sql_tmp = sql_tmp.replace("##join_black_reason##", bean.getJoinBlackReason());
                                sql_tmp = sql_tmp.replace("##black_type##", bean.getBlackType());

                                if(StringUtils.isNotEmpty(bean.getRemark())){
                                    sql_tmp = sql_tmp.replace("##have_UUID##", ", uuid='"+bean.getUuid()+"'");
                                }else{
                                    sql_tmp = sql_tmp.replace("##have_UUID##", "");
                                }

                                int update = blackListJdbcTemplate.update(sql_tmp);

                                thisPageOk = thisPageOk + update;
                                totalOkCount = totalOkCount + update;

                            }catch (Exception e){
                                log.error("方法update_huiTohei_type1()修改异常, id: {} ", bean.getId(), e);
                            }
                        }
                    }
                }
            }catch (Exception e){
                //e.printStackTrace();
                log.error("update_huiTohei_type1()处理异常, page: {} , startId: {} , endId: {} ", page, startId, endId, e);
            }finally {
                log.info("update_huiTohei_type1()处理结束 page: {} , startId: {} , endId: {} , updateBeanList: {} , thisPageOk: {} , 耗时: {} <<<<<<------\n", page, startId, endId, (updateBeanList!=null ? updateBeanList.size(): 0), thisPageOk, ((System.currentTimeMillis()-thisPageStart)+".ms"));
            }
        }

        log.info("\n>>>>>>update_huiTohei_type1()处理 Method End, totalQueryCount: {} , totalUpdateCount: {} , totalOkCount: {} , total cost: {} <<<<<<", totalQueryCount, totalUpdateCount, totalOkCount, (System.currentTimeMillis()-totalStar)+".ms");
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 将tmp_black_grey_list表，black_type=2 && type=2(白条)的，符合条件的更新为黑名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.13 14:31 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.13 14:31 <br>
     * 入参说明: [] <br>
     * 出参说明: void <br>
     * -----------------------------------------------------------------------------
     */
    private void update_huiTohei_type2(){
        long totalStar = System.currentTimeMillis();

        //blackListJdbcTemplate
        String sql_blacklist3_query = "SELECT t.id, t.uuid, t.`name`, t.phone_no, t.id_no, t.black_type, t.type from tmp_black_grey_list t " +
                " WHERE t.black_type='2' AND t.type='2'" +
                " AND id > ? AND id<=?;";

        //xyqbJdbcTemplate
        String sql_xyqb_query_type2 = "select count(distinct a.user_id) in_overdue " +
                "from baitiao_repayment_plan a " +
                "left join baitiao_order b on a.order_id=b.id " +
                "left join user c on a.user_id=c.id " +
                "where c.uuid='##UUID##' " +
                "and b.status=1 " +
                "and a.repayment_status not in (3,4) and a.deadline<CURDATE()";

        //int maxId = 11429420;
        int maxId = 0;
        try{
            String value = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_MAXID_TYPE1");
            if(StringUtils.isNotEmpty(value)){
                maxId = Integer.parseInt(value);
            }
        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", "UPDATE_HUITOHEI_MAXID_TYPE1", e);
        }
        log.info("方法update_huiTohei_type2()查询缓存, maxId : {} ", maxId);
        if(maxId<=0){
            return;
        }

        int totalQueryCount = 0, totalUpdateCount = 0, totalOkCount = 0;
        int totalPage = maxId/LIMIT_1000;
        if((maxId%LIMIT_1000)!=0){
            totalPage+=1;
        }

        int startId = 0,endId = 0;
        for (int page = 1; page <= totalPage; page++) {
            startId = (page-1) * LIMIT_1000;
            endId = page * LIMIT_1000;

            long thisPageStart= System.currentTimeMillis();
            List<TmpBlackGreyList> updateBeanList = null;
            int thisPageOk = 0;

            try{
                log.info("方法update_huiTohei_type2()处理开始 page: {} , startId: {} , endId: {} , totalPage: {} ------>>>>>>", page, startId, endId, totalPage);
                List<TmpBlackGreyList> tmpQueryList = blackListJdbcTemplate.query(sql_blacklist3_query, new Object[]{startId, endId}, new RowMapper<TmpBlackGreyList>() {
                    @Override
                    public TmpBlackGreyList mapRow(ResultSet rs, int rowNum) throws SQLException {
                        TmpBlackGreyList bean = new TmpBlackGreyList();
                        bean.setId(rs.getLong("id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setName(rs.getString("name"));
                        bean.setPhoneNo(rs.getString("phone_no"));
                        bean.setIdNo(rs.getString("id_no"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setType(rs.getString("type"));
                        return bean;
                    }
                });

                if(tmpQueryList!=null && tmpQueryList.size()>0){

                    totalQueryCount = totalQueryCount + tmpQueryList.size();
                    updateBeanList = new ArrayList<>();

                    for(TmpBlackGreyList queryBean : tmpQueryList){

                        if(queryBean.getUuid()==null || "".equals(queryBean.getUuid().trim())){
                            log.info("方法update_huiTohei_type2()检测用户信息id:{} 的uuid是空的", queryBean.getId());
                            if(StringUtils.isNotEmpty(queryBean.getIdNo()) && StringUtils.isNotEmpty(queryBean.getName())){

                                String sql_query_byIdNo = "select u.id, u.uuid, d.`name`, d.phone_no, d.id_no from user_detail d left join user u on d.user_id=u.id " +
                                        "where u.`enable`=1 AND d.id_no='"+queryBean.getIdNo().trim().toUpperCase()+"' AND d.`name`='"+queryBean.getName().trim()+"' LIMIT 1 ";

                                XyqbUser xyqbUser = null;
                                try {
                                     xyqbUser = xyqbUserJdbcTemplate.queryForObject(sql_query_byIdNo, new RowMapper<XyqbUser>() {
                                        @Override
                                        public XyqbUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                                            XyqbUser bean = new XyqbUser();
                                            bean.setId(rs.getLong("id"));
                                            bean.setUuid(rs.getString("uuid"));
                                            bean.setName(rs.getString("name"));
                                            bean.setPhoneNo(rs.getString("phone_no"));
                                            bean.setIdNo(rs.getString("id_no"));
                                            return bean;
                                        }
                                    });
                                }catch (EmptyResultDataAccessException e){
                                    log.error("方法update_huiTohei_type2补全用户信息uuid异常, idNo: {} , name: {} , e: {} ", queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().trim(), e.toString());
                                }finally {
                                    log.info("方法update_huiTohei_type2补全用户信息: {} , id: {} ", xyqbUser!=null ? xyqbUser.toString():"null", queryBean.getId());
                                }

                                if(xyqbUser!=null && StringUtils.isNotEmpty(xyqbUser.getUuid())){
                                    queryBean.setUuid(xyqbUser.getUuid());
                                    queryBean.setRemark(xyqbUser.getUuid());//为了标记，修改uuid
                                    log.info("方法update_huiTohei_type2()检测用户信息id:{} 的uuid是空, 但根据id_no和name补全了uuid={}, id_no={}, name={} ", queryBean.getId(), queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().toUpperCase());
                                }
                            }
                        }

                        if(StringUtils.isNotEmpty(queryBean.getUuid())){
                            queryBean.setBlackType("2");
                            queryBean.setJoinBlackReason("6");

                            Object in_overdue_Obj = null;
                            try {
                                in_overdue_Obj = xyqbJdbcTemplate.queryForObject(sql_xyqb_query_type2.replace("##UUID##", queryBean.getUuid()), String.class);
                            }catch (EmptyResultDataAccessException e){
                                log.error("方法update_huiTohei_type2查询逾期in_overdue_Obj异常, uuid: {} , idNo: {} , name: {} , e: {} ", queryBean.getUuid(), queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().trim(), e.toString());
                            }finally {
                                log.info("方法update_huiTohei_type2查询逾期in_overdue_Obj : {} , uuid: {} ", in_overdue_Obj!=null ? in_overdue_Obj.toString() : "null", queryBean.getUuid());
                            }

                            if(in_overdue_Obj!=null && StringUtils.isNotEmpty(in_overdue_Obj.toString())){
                                int in_overdue = Integer.parseInt(in_overdue_Obj.toString());
                                if(in_overdue >=1 ){
                                    queryBean.setBlackType("1");
                                    queryBean.setJoinBlackReason("3");
                                }
                            }
                            updateBeanList.add(queryBean);
                            totalUpdateCount++;
                        }else{
                            log.warn("方法update_huiTohei_type2查询in_overdue时用户uuid为空跳过, id: {} ", queryBean.getId());
                        }
                    }
                    log.info("方法update_huiTohei_type2()筛选结束, page: {} , startId: {} , endId: {}, list大小: {} ", page, startId, endId, updateBeanList.size());

                    if(updateBeanList.size()>0){
                        //batchResult = JdbcExecuters.updateBatchExecute(updateBean, sql_update_type1, blackListJdbcTemplate, "update_huiTohei_type1");
                        String sql_update_type1 = "update tmp_black_grey_list set black_type='##black_type##', join_black_reason='##join_black_reason##' ##have_UUID## where id=##id##";

                        for (TmpBlackGreyList bean : updateBeanList) {
                            try{
                                String sql_tmp = sql_update_type1.replace("##id##", ""+bean.getId());
                                sql_tmp = sql_tmp.replace("##join_black_reason##", bean.getJoinBlackReason());
                                sql_tmp = sql_tmp.replace("##black_type##", bean.getBlackType());

                                if(StringUtils.isNotEmpty(bean.getRemark())){
                                    sql_tmp = sql_tmp.replace("##have_UUID##", ", uuid='"+bean.getUuid()+"'");
                                }else{
                                    sql_tmp = sql_tmp.replace("##have_UUID##", "");
                                }

                                int update = blackListJdbcTemplate.update(sql_tmp);

                                thisPageOk = thisPageOk + update;
                                totalOkCount = totalOkCount + update;

                            }catch (Exception e){
                                log.error("方法update_huiTohei_type2()修改异常, id: {} ", bean.getId(), e);
                            }
                        }
                    }
                }
            }catch (Exception e){
                log.error("方法update_huiTohei_type2()处理异常, page: {} , startId: {} , endId: {} ", page, startId, endId, e);
            }finally {
                log.info("方法update_huiTohei_type2()处理结束 page: {} , startId: {} , endId: {} , updateBeanList: {} , thisPageOk: {} , 耗时: {} <<<<<<------\n", page, startId, endId, (updateBeanList!=null ? updateBeanList.size(): 0), thisPageOk, ((System.currentTimeMillis()-thisPageStart)+".ms"));
            }
        }

        log.info("\n>>>>>>方法update_huiTohei_type2()处理 Method End, totalQueryCount: {} , totalUpdateCount: {} , totalOkCount: {} , total cost: {} <<<<<<", totalQueryCount, totalUpdateCount, totalOkCount, (System.currentTimeMillis()-totalStar)+".ms");
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 将tmp_black_grey_list表，black_type=2 && type=10(VCC)的，符合条件的更新为黑名单 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.13 14:31 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.13 14:31 <br>
     * 入参说明: [] <br>
     * 出参说明: void <br>
     * -----------------------------------------------------------------------------
     */
    private void update_huiTohei_type10() {
        long totalStar = System.currentTimeMillis();

        //blackListJdbcTemplate
        String sql_blacklist3_query = "SELECT t.id, t.uuid, t.`name`, t.phone_no, t.id_no, t.black_type, t.type from tmp_black_grey_list t " +
                " WHERE t.black_type='2' AND t.type='10'" +
                " AND id > ? AND id<=?;";

        //acsdbJdbcTemplate
        String sql_acsdb_query_type10 = "select count(distinct a.user_id) in_overdue " +
                "from acs_plan a " +
                "left join acs_trans b on a.trans_id = b.id " +
                "where a.plan_status ='Overdue' " +
                "and b.trans_type in ('Shop','Loan') " +
                "and b.trans_status = 'Complete' " +
                "and a.user_id='##user_id##'";

        //int maxId = 11429420;
        int maxId = 0;
        try {
            String value = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_MAXID_TYPE1");
            if (StringUtils.isNotEmpty(value)) {
                maxId = Integer.parseInt(value);
            }
        } catch (Exception e) {
            log.error("获取redis里值异常, key: {} ", "UPDATE_HUITOHEI_MAXID_TYPE1", e);
        }
        log.info("方法update_huiTohei_type10()查询缓存, maxId : {} ", maxId);
        if (maxId <= 0) {
            return;
        }

        int totalQueryCount = 0, totalUpdateCount = 0, totalOkCount = 0;
        int totalPage = maxId / LIMIT_1000;
        if ((maxId % LIMIT_1000) != 0) {
            totalPage += 1;
        }

        int startId = 0, endId = 0;
        for (int page = 1; page <= totalPage; page++) {
            startId = (page - 1) * LIMIT_1000;
            endId = page * LIMIT_1000;

            long thisPageStart = System.currentTimeMillis();
            List<TmpBlackGreyList> updateBeanList = null;
            int thisPageOk = 0;

            try {
                log.info("方法update_huiTohei_type10()处理开始 page: {} , startId: {} , endId: {} , totalPage: {} ------>>>>>>", page, startId, endId, totalPage);
                List<TmpBlackGreyList> tmpQueryList = blackListJdbcTemplate.query(sql_blacklist3_query, new Object[]{startId, endId}, new RowMapper<TmpBlackGreyList>() {
                    @Override
                    public TmpBlackGreyList mapRow(ResultSet rs, int rowNum) throws SQLException {
                        TmpBlackGreyList bean = new TmpBlackGreyList();
                        bean.setId(rs.getLong("id"));
                        bean.setUuid(rs.getString("uuid"));
                        bean.setName(rs.getString("name"));
                        bean.setPhoneNo(rs.getString("phone_no"));
                        bean.setIdNo(rs.getString("id_no"));
                        bean.setBlackType(rs.getString("black_type"));
                        bean.setType(rs.getString("type"));
                        return bean;
                    }
                });

                if (tmpQueryList != null && tmpQueryList.size() > 0) {
                    totalQueryCount = totalQueryCount + tmpQueryList.size();
                    updateBeanList = new ArrayList<>();

                    for (TmpBlackGreyList queryBean : tmpQueryList) {

                        if (StringUtils.isNotEmpty(queryBean.getUuid())) {
                            String sql_query_byIdUUid = "select id as user_id, uuid from user where uuid='" + queryBean.getUuid() + "' AND `enable`=1 LIMIT 1  ";
                            XyqbUser xyqbUser = null;
                            try {
                                xyqbUser = xyqbUserJdbcTemplate.queryForObject(sql_query_byIdUUid, new RowMapper<XyqbUser>() {
                                    @Override
                                    public XyqbUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                                        XyqbUser bean = new XyqbUser();
                                        bean.setId(rs.getLong("user_id"));
                                        bean.setUuid(rs.getString("uuid"));
                                        return bean;
                                    }
                                });
                            } catch (EmptyResultDataAccessException e) {
                                log.error("查询用户user_id异常, id: {} , idNo: {} , name: {} , e: {} ", queryBean.getId(), queryBean.getIdNo(), queryBean.getName(), e.toString());
                            } finally {
                                log.info("查询用户user_id: {} , id: {} ", xyqbUser != null ? xyqbUser.toString() : "null", queryBean.getId());
                            }


                            if (xyqbUser != null && xyqbUser.getId() != 0L) {
                                queryBean.setBlackType("2");
                                queryBean.setJoinBlackReason("6");

                                Object in_overdue_Obj = null;
                                try {
                                    in_overdue_Obj = acsdbJdbcTemplate.queryForObject(sql_acsdb_query_type10.replace("##user_id##", "" + xyqbUser.getId()), String.class);
                                } catch (EmptyResultDataAccessException e) {
                                    log.error("方法update_huiTohei_type10查询逾期in_overdue_Obj异常, uuid: {} , idNo: {} , name: {} , e: {} ", queryBean.getUuid(), queryBean.getIdNo().trim().toUpperCase(), queryBean.getName().trim(), e.toString());
                                } finally {
                                    log.info("方法update_huiTohei_type10查询逾期in_overdue_Obj : {} , uuid: {} ", in_overdue_Obj != null ? in_overdue_Obj.toString() : "null", queryBean.getUuid());
                                }

                                if (in_overdue_Obj != null && StringUtils.isNotEmpty(in_overdue_Obj.toString())) {
                                    int in_overdue = Integer.parseInt(in_overdue_Obj.toString());
                                    if (in_overdue >= 1) {
                                        queryBean.setBlackType("1");
                                        queryBean.setJoinBlackReason("2");
                                    }
                                }
                                updateBeanList.add(queryBean);
                                totalUpdateCount++;
                            } else {
                                log.warn("查询用户user_id为空跳过, id: {} ", queryBean.getId());
                            }
                        }
                        log.info("方法update_huiTohei_type10()筛选结束, page: {} , startId: {} , endId: {}, list大小: {} ", page, startId, endId, updateBeanList.size());
                    }

                    if (updateBeanList.size() > 0) {
                        String sql_update_type1 = "update tmp_black_grey_list set black_type='##black_type##', join_black_reason='##join_black_reason##' where id=##id##";

                        for (TmpBlackGreyList bean : updateBeanList) {
                            try {
                                String sql_tmp = sql_update_type1.replace("##id##", "" + bean.getId());
                                sql_tmp = sql_tmp.replace("##join_black_reason##", bean.getJoinBlackReason());
                                sql_tmp = sql_tmp.replace("##black_type##", bean.getBlackType());

                                int update = blackListJdbcTemplate.update(sql_tmp);

                                thisPageOk = thisPageOk + update;
                                totalOkCount = totalOkCount + update;

                            } catch (Exception e) {
                                log.error("方法update_huiTohei_type10()修改异常, id: {} ", bean.getId(), e);
                            }
                        }
                    }

                }
            } catch (Exception e) {
                log.error("方法update_huiTohei_type10()处理异常, page: {} , startId: {} , endId: {} ", page, startId, endId, e);
            } finally {
                log.info("方法update_huiTohei_type10()处理结束 page: {} , startId: {} , endId: {} , updateBeanList: {} , thisPageOk: {} , 耗时: {} <<<<<<------\n", page, startId, endId, (updateBeanList != null ? updateBeanList.size() : 0), thisPageOk, ((System.currentTimeMillis() - thisPageStart) + ".ms"));
            }
        }
        log.info("\n>>>>>>方法update_huiTohei_type10()处理 Method End, totalQueryCount: {} , totalUpdateCount: {} , totalOkCount: {} , total cost: {} <<<<<<", totalQueryCount, totalUpdateCount, totalOkCount, (System.currentTimeMillis() - totalStar) + ".ms");
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 将tmp_black_grey_list临时表数据，copy到black_grey_list_result、black_grey_list_details <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.04.15 11:29 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.04.15 11:29 <br>
     * 入参说明:  <br>
     * 出参说明:  <br>
     * -----------------------------------------------------------------------------
     */
    private void tmpBlackGreyToProduct(){
        long totalStar = System.currentTimeMillis();
        //blackListJdbcTemplate
        String sql_blacklist3_query = "SELECT t.id, t.uuid, t.`name`, t.phone_no, t.id_no, t.black_type, t.type, t.join_black_reason, t.max_overdue_days, t.total_overdue_days, t.created_at, t.updated_at " +
                " from tmp_black_grey_list t " +
                " WHERE id > ? AND id<=?;";

        int maxId = 0;
        int BEGIN_ID = 0, startId = 0, endId = 0;
        try{
            String value_maxId = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_P_MAXID");
            if(StringUtils.isNotEmpty(value_maxId)){
                maxId = Integer.parseInt(value_maxId);
            }

            String value_beginId = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_P_BEGINID");
            if(StringUtils.isNotEmpty(value_beginId)){
                BEGIN_ID = Integer.parseInt(value_beginId);
            }

            String value_limitX = stringRedisTemplate.opsForValue().get("UPDATE_HUITOHEI_P_LIMIT_X");
            if(StringUtils.isNotEmpty(value_limitX)){
                LIMIT_X = Integer.parseInt(value_limitX);
            }

        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", "UPDATE_HUITOHEI_MAXID_TYPE1", e);
        }
        log.info("方法tmpBlackGreyToProduct()查询缓存, maxId : {} , BEGIN_ID : {} , startId : {} , endId: {} , LIMIT_X : {} ", maxId, BEGIN_ID, startId, endId, LIMIT_X);
        if(maxId<=0){
            return;
        }

        int totalQueryCount=0, totalOkCount = 0;
        int totalPage = (maxId-BEGIN_ID) / LIMIT_X;
        if(( (maxId-BEGIN_ID)%LIMIT_X)!=0){
            totalPage+=1;
        }


        for (int page = 1; page <= totalPage; page++) {
            //startId = (page-1) * LIMIT_1000;
            //endId =  page * LIMIT_1000;

            startId = BEGIN_ID + (page-1) * LIMIT_X;
            endId =  startId + LIMIT_X;

            long thisPageStart= System.currentTimeMillis();
            List<TmpBlackGreyList> tmpQueryList = null;
            int thisPageOk = 0;

            try{
                log.info("方法tmpBlackGreyToProduct()处理开始 page: {} , startId: {} , endId: {} , totalPage: {} ------>>>>>>", page, startId, endId, totalPage);
                tmpQueryList = blackListJdbcTemplate.query(sql_blacklist3_query, new Object[]{startId, endId}, new TmpBlackGreyListRowMapper());

                if(tmpQueryList!=null && tmpQueryList.size()>0){
                    totalQueryCount+=tmpQueryList.size();

                   /* for (TmpBlackGreyList blackGreyObj : tmpQueryList) {
                        blackGreyListService.saveBlackRreyList(blackGreyObj);
                        thisPageOk++;
                        totalOkCount++;
                    }*/
                    int count = blackGreyListService.saveBlackGreyListByJdbc(tmpQueryList);
                    thisPageOk+=count;
                    totalOkCount+=count;
                }
            }catch (Exception e){
                log.error("方法tmpBlackGreyToProduct()处理异常, page: {} , startId: {} , endId: {} ", page, startId, endId, e);
            }finally {
                log.info("方法tmpBlackGreyToProduct()处理结束 page: {} , startId: {} , endId: {} , tmpQueryList: {} , thisPageOk: {} , 耗时: {} <<<<<<------\n", page, startId, endId, (tmpQueryList!=null ? tmpQueryList.size(): 0), thisPageOk, ((System.currentTimeMillis()-thisPageStart)+".ms"));
            }
        }

        log.info("\n>>>>>>方法tmpBlackGreyToProduct()处理 Method End, totalQueryCount: {} , totalOkCount: {} , total cost: {} <<<<<<", totalQueryCount, totalOkCount, (System.currentTimeMillis()-totalStar)+".ms");
    }

    @Override
    public String importBlackGrey(String txtTableFile) {
        List<String> contextList = ReadOrWriteTxt.readTxtList(txtTableFile);
        if(contextList==null || contextList.size()==0){
            return txtTableFile+",读取参数文件为空!";
        }

        int details_haveCount = 0;
        int saveOkCount = 0;
        List<TmpBlackGreyList> blackGreyList = new ArrayList<TmpBlackGreyList>();
        TmpBlackGreyList blackGreyObj = null;
        for (String context: contextList) {
            //uuid|name|phone_no|id_no|black_type|type|join_black_reason|max_overdue_days|total_overdue_days|remark|created_at|updated_at
            if(context.length()<11){
                log.warn("该行参数有误, 跳过: {} ", context);
                continue;
            }
            String[] array = context.trim().split("[|]");
            if(array.length<12){
                log.warn("该行参数格式有误, 跳过: {} ", context);
                continue;
            }

            blackGreyObj = new TmpBlackGreyList();
            if(StringUtils.isNotEmpty(array[0].trim())){
                blackGreyObj.setUuid(array[0].trim());
            }
            if(StringUtils.isNotEmpty(array[1].trim())){
                blackGreyObj.setName(array[1].trim());
            }
            if(StringUtils.isNotEmpty(array[2].trim())){
                blackGreyObj.setPhoneNo(array[2].trim());
            }
            if(StringUtils.isNotEmpty(array[3].trim())){
                blackGreyObj.setIdNo(array[3].trim());
            }
            if(StringUtils.isNotEmpty(array[4].trim())){
                blackGreyObj.setBlackType(array[4].trim());
            }
            if(StringUtils.isNotEmpty(array[5].trim())){
                blackGreyObj.setType(array[5].trim());
            }
            if(StringUtils.isNotEmpty(array[6].trim())){
                blackGreyObj.setJoinBlackReason(array[6].trim());
            }
            if(StringUtils.isNotEmpty(array[7].trim())){
                blackGreyObj.setMaxOverdueDays(array[7].trim());
            }
            if(StringUtils.isNotEmpty(array[8].trim())){
                blackGreyObj.setTotalOverdueDays(array[8].trim());
            }
            if(StringUtils.isNotEmpty(array[9].trim())){
                blackGreyObj.setRemark(array[9].trim());
            }
            if(StringUtils.isNotEmpty(array[10].trim())){
                Timestamp createdAt = new Timestamp(System.currentTimeMillis());
                try {
                    createdAt = Timestamp.valueOf(array[10].trim());//yyyy-mm-dd hh:mm:ss
                } catch (Exception e) {
                    e.printStackTrace();
                }
                blackGreyObj.setCreatedAt(createdAt);
            }
            if(StringUtils.isNotEmpty(array[11].trim())){
                Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                try {
                    updatedAt = Timestamp.valueOf(array[11].trim());//yyyy-mm-dd hh:mm:ss
                } catch (Exception e) {
                    e.printStackTrace();
                }
                blackGreyObj.setCreatedAt(updatedAt);

                blackGreyObj.setUpdatedAt(updatedAt);
            }

            BlackGreyListQueryVo queryResultParam = BlackGreyListQueryVo.builder().name(blackGreyObj.getName()).idNo(blackGreyObj.getIdNo()).phoneNo(blackGreyObj.getPhoneNo())
                    .type(blackGreyObj.getType()).status(0).build();

            //List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryResultParam);
            List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetailsBy3YS(queryResultParam);
            if(detailsList!=null && detailsList.size()>0){
                details_haveCount++;
            }else {
                blackGreyList.add(blackGreyObj);
            }
        }
        if(blackGreyList!=null && blackGreyList.size()> 0){
            try {
                saveOkCount  = blackGreyListService.saveBlackGreyListByJdbc(blackGreyList);
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }

        String resMsgTemp = "文件:%s 总共 %d条, 明细表已存在 %d条, 插入成功 %d条;";
        return String.format(resMsgTemp, txtTableFile, contextList.size(), details_haveCount, saveOkCount);
    }

}
