package cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist;

import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.*;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 黑灰名单 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 21:41 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Repository
public interface BlackGreyListMapper {

    BlackGreyListResult findBGLResultByRid(String rId);

    List<BlackGreyListResult> findBlackGreyListResultByParam(BlackGreyListQueryVo queryParams);
    //通过三要素精确查询
    List<BlackGreyListResult> findBlackGreyListResultBy3YS(BlackGreyListQueryVo queryParams);


    List<BlackGreyListDetails> findBlackGreyListDetails(BlackGreyListQueryVo queryParams);
    //通过三要素精确查询
    List<BlackGreyListDetails> findBlackGreyListDetailsBy3YS(BlackGreyListQueryVo queryParams);


    //结果表和明细表关联查询
    List<BlackGreyListRjoinDVo> findBlackGreyListRjoinD(BlackGreyListQueryVo queryParams);


    int insertBlackGreyListResult(BlackGreyListResult result);

    int insertBlackGreyListDetails(BlackGreyListDetails details);

    int updateBlackGreyListResult(BlackGreyListResult params);

    int updateDetailsStatusByparams(DetailsUpdate params);

    int updateDetailOverdueDayById(DetailsUpdate params);



}
