package cn.quantgroup.qgblservice.utils.blacklist;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;

import java.sql.Timestamp;
import java.time.LocalDateTime;

/**
 * @Author fengjunkai
 * @Date 2019-08-19 17:41
 */
public class BlackListUtils {

    public static void getOrUpdateBlackListLevel(BlackListQueryTidbVo0 blackListQueryTidbVo0, String type) {
        LocalDateTime localDateTimeCreatedAt = blackListQueryTidbVo0.getCreatedAt().toLocalDateTime();
        LocalDateTime localDateTimeNow = LocalDateTime.now();

        long time12 = Timestamp.valueOf(localDateTimeCreatedAt.plusMonths(12)).getTime();
        long time24 = Timestamp.valueOf(localDateTimeCreatedAt.plusMonths(24)).getTime();
        long timeNow = Timestamp.valueOf(localDateTimeNow).getTime();

        if (time12 - timeNow < 0 && time24 - timeNow > 0) {
            blackListQueryTidbVo0.setBlackLevel(type.equals(Constant.PARAM.BLACK_LIST_THIRD_PART) ? Constant.PARAM.BLACK_LIST_LEVEL_D2 : Constant.PARAM.BLACK_LIST_LEVEL_A2);
        } else if (time24 - timeNow < 0) {
            blackListQueryTidbVo0.setBlackLevel(type.equals(Constant.PARAM.BLACK_LIST_THIRD_PART) ? Constant.PARAM.BLACK_LIST_LEVEL_D3 : Constant.PARAM.BLACK_LIST_LEVEL_A3);
        }

    }

}
