package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.ConstantBlackGrey;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListDetails;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListQueryVo;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListResult;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputing;
import cn.quantgroup.qgblservice.utils.parallel.ParallelComputingProcess;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

import java.io.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: 逾期已还清黑名单>>转灰名单-并行框架 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.16 21:12 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class BlackToGreyListParallel implements ParallelComputingProcess<BlackGreyListResult, Set<String>> {

    private final String log_inf = "BlackToGreyListParallel";

    private final String sepa = java.io.File.separator; //System.getProperty("file.separator");
    private final DateFormat df = new SimpleDateFormat(ConstantBlackGrey.DAYE_FORMAT.YYYYMMDD);
    private final String  saveLogPath = "/home/logs/";


    //并行处理框架
    private ParallelComputing<BlackGreyListResult, Set<String>> p = new ParallelComputing<BlackGreyListResult, Set<String>>("BlackToGreyListParallel");
    /**
     * 当前服务器CPU个数
     */
    private static int SYS_CPU_COUNT = Runtime.getRuntime().availableProcessors();//4
    //private static int SYS_CPU_COUNT = 6;

    @Autowired
    private BlackGreyListMapper blackGreyListMapper;


    public void runMain(List<BlackGreyListResult> tmpQueryList) {
        long startProcess = System.currentTimeMillis();
        int listSize = tmpQueryList.size();
        log.info(log_inf+"-runMain开始执行, listSize: {} , SYS_CPU_COUNT: {} ", listSize, SYS_CPU_COUNT);

        try {
            //并行框架---执行
            Set<String> optSet = Collections.synchronizedSet(new HashSet<>());
            p.processForThread(tmpQueryList, this, SYS_CPU_COUNT, optSet);

            //并行框架执行结果
            if (optSet.size() > 0) {//并行框架执行异常
                log.error("runMain() ERROR! >> optSet size:{} , Json:{} ", optSet.size(), JSONObject.toJSONString(optSet));
                return;
            } else {
                //执行成功,覆盖执行时间
                log.info(log_inf + " >> to process() is OK!");
            }

            log.info(log_inf +"-runMain执行结束, cost:" + (System.currentTimeMillis() - startProcess) + "ms.");
        } catch (Exception e) {
            log.error(log_inf +"-runMain执行异常.", e);
        }
    }


    @Override
    public void process(int threadId, List<BlackGreyListResult> blackResultList, Set<String> optSet) {
        AtomicInteger ok_count = new AtomicInteger();
        AtomicInteger err_count = new AtomicInteger();
        int list_size = blackResultList.size();
        //yyyyMMdd
        Calendar calendar = Calendar.getInstance();
        String dateName = df.format(calendar.getTime());
        int index = 0;
        for (BlackGreyListResult blackResult : blackResultList) {
            log.info("threadId_{}: 开始执行list_size: {} , this: {} ", threadId , list_size, (++index));

            try {
                BlackGreyListQueryVo queryParam = BlackGreyListQueryVo.builder().rId(blackResult.getRId()).build();
                List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryParam);

                if (detailsList!=null && detailsList.size()>0) {

                    for(BlackGreyListDetails details : detailsList){
                        //现金贷
                        if("1".equals(details.getType()) && details.getStatus()==0){
                            /*#现金分期在逾转已还 (条件为step1的表内join_black_reason=1的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)
                            use xyqb;
                            select
                            count(distinct a.user_id) in_overdue
                            from repayment_plan a
                            left join loan_application_manifest_history b
                            on a.loan_application_history_id=b.loan_application_history_id
                            left join user c on a.user_id=c.id
                            where c.uuid='d9867db1-cb8e-4a94-adfc-d3f80079c8d0'
                            and b.transaction_status in (2,5)
                            and a.repayment_status not in (3,4) and a.deadline<=CURDATE();*/

                        }
                        //白条
                        else if("2".equals(details.getType()) && details.getStatus()==0){
                        /*#白条在逾转已还 (条件为step1的表内join_black_reason=3的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)
                            use xyqb;
                            select
                            count(distinct a.user_id) in_overdue
                            from baitiao_repayment_plan a
                            left join baitiao_order b on a.order_id=b.id
                            left join user c on a.user_id=c.id
                            where c.uuid='e501ab61-ae1b-4098-a322-fc59b17b1109'
                            and b.status=1
                            and a.repayment_status not in (3,4) and a.deadline<CURDATE();*/
                        }
                        //Vcc
                        else if("10".equals(details.getType()) && details.getStatus()==0){
                           /* #vcc在逾转已还 (条件为step1的表内join_black_reason=2的用户，判断其是否还处于在逾状态，如果in_overdue=0，则更新step1的表的black_type为2并更新join_black_reason为6,否则不做修改)
                            use xyqb_user;
                            select id user_id from user where uuid='24fdc7b7-b0b7-46e9-8045-f79ad8eaeb1b';

                            use acsdb;
                            select
                            count(distinct a.user_id) in_overdue
                            from acs_plan a
                            left join acs_trans b on a.trans_id = b.id
                            where a.plan_status ='Overdue'
                            and b.trans_type in ('Shop','Loan')
                            and b.trans_status = 'Complete'
                            and a.user_id='58308876';*/
                        }else{
                            err_count.getAndIncrement();
                            optSet.add("otherType:"+blackResult.getRId());
                            writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                        }

                    }

                    ok_count.getAndIncrement();


                }else {
                    err_count.getAndIncrement();
                    optSet.add("notFind:"+blackResult.getRId());
                    writeLogByName(saveLogPath + dateName + sepa + "error.log", "black_list_result_not_find_details>>"+blackResult.getRId());
                }

            } catch (Exception e) {
                optSet.add("ERR:" + blackResult.getRId());
                log.error(log_inf + "process() threadId:" + threadId + ",ERROR!", e);
            }

        }
        log.info(log_inf + "处理结束 CPU_{} , 成功条数:{} , 失败:{} , this_list_size: {} ", threadId, ok_count.get(), err_count.get(), list_size);
    }





    //-------------------------------------------------------------------------

    private static void writeLogByName(String fileName, String msg) {
        try {
            FileUtils.write(new File(fileName), msg + "\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error," + msg + "," + e.toString());
        }
    }


}
