package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.model.blacklist.ThirdPartBlackListConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 三方数据源黑名单管理保存
 *
 * @Author fengjunkai
 * @Date 2019-08-12 17:25
 */
@Slf4j
@Service
public class ThirdPartBlackListServiceImpl implements IThirdPartBlackListManagerService {

    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    private static Map<String, String> thirdPartBlackListCacheConfigMap = new ConcurrentHashMap<>();

    @Override
    public GlobalResponse saveThirdPartBlackList(String uuid, String name, String phoneNo, String idCard, String type) {

        try {
            List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListJdbcTemplate.query(String.format(Constant.SQL.QUERY_BY_UNIQUE_KEY_SQL,
                    phoneNo, name, idCard, thirdPartBlackListCacheConfigMap.get(type)), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
            if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {

                for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {
                    BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                    blackListQueryTidbVo0.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                    blackListJdbcTemplate.update(String.format(Constant.SQL.UPDATE_THIRD_PART_BLACK_LIST_SQL,
                            blackListQueryTidbVo0.getUuid(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo0.getUpdatedAt(), blackListQueryTidbVo0.getId()));
                }

            } else {
                saveThirdPartBlackListJdbc(uuid, name, phoneNo, idCard, type);
            }

            return GlobalResponse.success("保存成功");

        } catch (Exception e) {
            log.error("保存三方数据源黑名单异常, uuid: {} , name: {} , phoneNo: {} , idCard: {} ", uuid, name, phoneNo, idCard, e);
        }

        return GlobalResponse.error("保存异常");

    }

    public void saveThirdPartBlackListJdbc(String uuid, String name, String phoneNo, String idCard, String type) {

        Object param[] = new Object[10];
        param[0] = uuid;
        param[1] = name;
        param[2] = phoneNo;
        param[3] = idCard;
        param[4] = "3";
        param[5] = thirdPartBlackListCacheConfigMap.get(type);
        param[6] = "C2";
        param[7] = "3";
        param[8] = new Timestamp(System.currentTimeMillis());
        param[9] = new Timestamp(System.currentTimeMillis());
        blackListJdbcTemplate.update(Constant.SQL.INSERT_THIRD_PART_BLACK_LIST_SQL, param);

    }

    @PostConstruct
    public void initThirdPartBlackListConfig() {

        List<ThirdPartBlackListConfigVo0> thirdPartBlackListConfigVo0s = blackListJdbcTemplate.query(Constant.SQL.QUERY_THIRD_PART_BLACK_LIST_CONFIG, new BeanPropertyRowMapper<>(ThirdPartBlackListConfigVo0.class));
        thirdPartBlackListCacheConfigMap = thirdPartBlackListConfigVo0s.stream().collect(Collectors.toMap(ThirdPartBlackListConfigVo0::getChannelType, ThirdPartBlackListConfigVo0::getType));

    }

}
