package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryByThreeEleParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackListQueryMapper;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb.BlackListQueryTidbMapper;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-05 16:43
 */
@Slf4j
@Service
public class BlackListManagerServiceImpl implements IBlackListManagerService {

    @Autowired
    private BlackListQueryTidbMapper blackListQueryTidbMapper;
    @Autowired
    private BlackListQueryMapper blackListQueryMapper;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    /**
     * 手机号黑名单black_type_list_new --> black_list_new
     *
     * @param startTime
     * @param endTime
     */
    @Override
    public void blackListPhoneManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONES_MONTH);
            log.info("{} - {} 手机号黑名单(month)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    /**
     * 身份证黑名单 black_list_idcard_new --> black_list_new
     *
     * @param startTime
     * @param endTime
     */
    @Override
    public void blackListIdCardManagerByMonth(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_IDCARDS_MONTH);
            log.info("{} - {} 身份证号黑名单(month)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    @Override
    public void blackListPhoneManagerByDay(String startTime, String endTime) {
        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

            BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
            List<BlackListQueryTidbVo0> blackListByPhones = blackListQueryMapper.findBlackListByPhone(BlackListQueryByThreeEleParam0.builder().phone(blackListQueryTidbVo0.getPhoneNo()).build());

            updateOrNo(blackListByPhones, blackListQueryTidbVo0, Constant.BATCH_TYPE.BATCH_PHONES_DAYS);

        }

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_PHONES_DAYS);
            log.info("{} - {} 手机号黑名单(day)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    @Override
    public void blackListIdCardManagerByDay(String startTime, String endTime) {

        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListIdCardByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());

        for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

            BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
            List<BlackListQueryTidbVo0> blackListByIdcards = blackListQueryMapper.findBlackListByIdcard(BlackListQueryByThreeEleParam0.builder().phone(blackListQueryTidbVo0.getIdNo()).build());

            updateOrNo(blackListByIdcards, blackListQueryTidbVo0, Constant.BATCH_TYPE.BATCH_IDCARDS_DAYS);

        }

        if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int batchExecuteResult = JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_THREE_ELE_LIST_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_IDCARDS_DAYS);
            log.info("{} - {} 身份证号黑名单(day)关联三要素导入完成, 结果大小: {} , 入库大小: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), batchExecuteResult, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }

    }

    /**
     * blackListQueryTidbVo0 三要素+uuid都不为空的时候采取更新数据库中对应三要素缺失的记录
     *
     * @param blackListByPhones
     * @param blackListQueryTidbVo0
     */
    public void updateOrNo(List<BlackListQueryTidbVo0> blackListByPhones, BlackListQueryTidbVo0 blackListQueryTidbVo0, String type) {

        for (int j = 0; j < blackListByPhones.size(); j++) {

            try {
                BlackListQueryTidbVo0 blackListByPhone = blackListByPhones.get(j);
                String name = blackListByPhone.getName();
                String idNo = blackListByPhone.getIdNo();
                String uuid = blackListByPhone.getUuid();
                String phoneNo = blackListByPhone.getPhoneNo();

                if (StringUtils.isAnyBlank(name, idNo, uuid, phoneNo)
                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())
                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())
                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())
                        && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())) {

                    if (StringUtils.isBlank(phoneNo) && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())) {
                        blackListByPhone.setPhoneNo(blackListQueryTidbVo0.getPhoneNo());
                    }

                    if (StringUtils.isBlank(name) && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())) {
                        blackListByPhone.setName(blackListQueryTidbVo0.getName());
                    }

                    if (StringUtils.isBlank(idNo) && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())) {
                        blackListByPhone.setIdNo(blackListQueryTidbVo0.getIdNo());
                    }

                    if (StringUtils.isBlank(uuid) && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())) {
                        blackListByPhone.setUuid(blackListQueryTidbVo0.getUuid());
                    }

                    List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListJdbcTemplate.query(String.format(Constant.SQL.QUERY_BY_UNIQUE_KEY_SQL,
                            blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo0.getType()), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));

                    if(CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)){
                        blackListJdbcTemplate.update(String.format(Constant.SQL.UPDATE_BY_RECORD_ID_SQL, blackListByPhone.getCreatedAt(), blackListByPhone.getUpdatedAt(), blackListByPhone.getId()));
                        log.info("{} 黑名单禁用", type);
                    }else{
                        blackListJdbcTemplate.update(String.format(Constant.SQL.UPDATE_THREE_ELE_SQL, blackListByPhone.getUuid(), blackListByPhone.getName(), blackListByPhone.getPhoneNo(), blackListByPhone.getIdNo(), blackListByPhone.getId()));
                        log.info("{} 黑名单更新缺失三要素", type);
                    }

                }
            } catch (Exception e) {
                log.error("{} 黑名单单条更新异常", type, e);
            }

        }

    }

}
