package cn.quantgroup.qgblservice.utils.jdbc;

import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.*;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * Created by renfeng on 2019/4/22.
 */
public class JdbcExecuters {

    private static final Logger log = LoggerFactory.getLogger(JdbcExecuters.class);

    public static int batchExecute(List<BlackListQueryTidbVo0> blackListQueryTidbVo0s, String sql, JdbcTemplate jdbcTemplate, String type) {
        Connection conn = null;
        PreparedStatement ps = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {

            conn = jdbcTemplate.getDataSource().getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

                BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                ps.setString(1, blackListQueryTidbVo0.getUuid());
                ps.setString(2, blackListQueryTidbVo0.getName());
                ps.setString(3, blackListQueryTidbVo0.getPhoneNo());
                ps.setString(4, blackListQueryTidbVo0.getIdNo());
                ps.setString(5, blackListQueryTidbVo0.getMajorType());
                ps.setString(6, blackListQueryTidbVo0.getType());
                ps.setString(7, blackListQueryTidbVo0.getFirstOverdueDays());
                ps.setString(8, blackListQueryTidbVo0.getMaxOverdueDays());
                ps.setString(9, blackListQueryTidbVo0.getBlackLevel());
                ps.setString(10, blackListQueryTidbVo0.getBelongsType());
                ps.setTimestamp(11, blackListQueryTidbVo0.getCreatedAt());
                ps.setTimestamp(12, blackListQueryTidbVo0.getUpdatedAt());

                ps.addBatch();
                atomicInteger.getAndIncrement();

                if (i > 0 && i % 5000 == 0) {
                    ps.executeBatch();
                    conn.commit();
                    ps.clearBatch();
                }
            }

            ps.executeBatch();
            conn.commit();

        } catch (Exception e) {
            log.error("{} 批量插入数据异常", type, e);
        } finally {
            close(conn, ps, null);
        }
        return atomicInteger.get();
    }

    /**
     * 关闭资源
     *
     * @param conn
     * @param st
     * @param rs
     */
    private static void close(Connection conn, Statement st, ResultSet rs) {
        try {
            if (rs != null)
                rs.close();
            if (st != null)
                st.close();
            if (conn != null)
                conn.close();
        } catch (SQLException e) {
            log.error("关闭jdbc资源异常", e);
        }

    }

}
