package cn.quantgroup.qgblservice.service;

import cn.quantgroup.qgblservice.response.GlobalResponse;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.09.19 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public interface IBlackListToolsManagerService {

    /**
     * 描述:  用户Excel表格数据和black_list_new黑名单比对   <br/>
     * 参数: [filePath, titleNames, haveTitle, byColumnName,columnDataType]  <br/>
     * 返回值: cn.quantgroup.qgblservice.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.10  <br/>
     */
    public GlobalResponse compareByExcel(String filePath, String titleNames, String haveTitle, String byColumnName,String columnDataType);



    /**
     * 描述: 手动更新black_list_new黑名单表手机号&身份证号md5字段   <br/>
     * 参数: [filePath, titleNames, haveTitle, queryType]  <br/>
     * 返回值: cn.quantgroup.qgblservice.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.10  <br/>
     */
    public GlobalResponse buildMd5Tools(String privateKey, String operatType, String idArray, String gtCreatUtc);



    /**
     * -----------------------------------------------------------------------------<br>
     * 描述: black_list_new 数据，往tmp_black_grey_list清洗<br>
     * 作者：yanhui.Hao <br>
     * 时间：2020.04.02 <br>
     * 授权: (C) Copyright (c) 2017 <br>
     * 公司: 北京众信利民信息技术有限公司 <br>
     * -----------------------------------------------------------------------------
     */
    public void cleanTableData(String privateKey, String operatType);

}
