package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListQueryManagerService;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预留刷新缓存接口
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:16
 */
@Slf4j
@RestController
@RequestMapping("/")
public class BlackListCacheManagerController {

    @Autowired
    private IThirdPartBlackListManagerService iThirdPartBlackListManagerService;
    @Autowired
    private IBlackListQueryManagerService iBlackListQueryManagerService;

    @RequestMapping("/third_cache_reload")
    public GlobalResponse reloadThirdCacheConfig(){
        try{
            iThirdPartBlackListManagerService.initThirdPartBlackListConfig();
            log.info("更新三方数据源缓存配置成功"); //日志
            return GlobalResponse.success("更新三方数据源缓存配置成功");
        }catch(Exception e){
            log.error("更新三方数据源缓存配置异常", e);
        }
        return GlobalResponse.error("更新三方数据源缓存配置失败");
    }

    @RequestMapping("/black_expire_reload")
    public GlobalResponse reloadBlackExpire(){
        try{
            iBlackListQueryManagerService.initChannelBlackListExpireConfig();
            log.info("更新有效期配置成功");
            return GlobalResponse.success("更新有效期配置成功");
        }catch(Exception e){
            log.error("更新有效期配置异常", e);
        }
        return GlobalResponse.error("更新有效期配置失败");
    }

}
