package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackListChannelExpireConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListQueryManagerService;
import cn.quantgroup.qgblservice.utils.ReadExcelUtils;
import cn.quantgroup.qgblservice.utils.ReadOrWriteTxt;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 0.手机号
 * 1.身份证号
 * 2.手机号+身份证号 且关系
 * 3.手机号+姓名+身份证号  且关系
 * 4.身份证或手机号命中其一
 * 5.uuid
 *
 * @Author fengjunkai
 * @Date 2019-08-13 18:28
 */
@Slf4j
@Service
public class BlackListQueryManagerServiceImpl implements IBlackListQueryManagerService {

    @Autowired
    private JdbcTemplate xyqbUserJdbcTemplate;
    @Autowired
    private JdbcTemplate xyqbJdbcTemplate;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    private static Map<String, Integer> channelBlackListExpireConfigMap = new ConcurrentHashMap<>();

    @Override
    public GlobalResponse queryBlackList(String uuid, String name, String phoneNo, String idNo, String type) {
        log.info("查询黑名单开始, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} ", uuid, name, phoneNo, idNo, type);
        try {
            switch (type) {
                case "0":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_SQL, phoneNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "1":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_SQL, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_ID_NO_SQL, idNo), uuid, name, phoneNo, idNo, type));
                case "2":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_IDNO_SQL, phoneNo, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "3":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_THREE_ELE_SQL, phoneNo, idNo, name), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "4":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_OR_PHONENO_SQL, phoneNo, idNo), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_PHONE_NO_SQL, phoneNo), uuid, name, phoneNo, idNo, type));
                case "5":
                    return GlobalResponse.success(getBlackListData(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UUID_SQL, uuid), String.format(Constant.SQL.XYQB_USER_QUERY_USER_DETAIL_BY_UUID_SQL, uuid), uuid, name, phoneNo, idNo, type));
                default:
                    return GlobalResponse.error("无效的查询类型");
            }
        } catch (Exception e) {
            log.error("查询黑名单异常, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} ", uuid, name, phoneNo, idNo, type, e);
        }

        return GlobalResponse.error("查询黑名单异常");
    }

    public List<BlackListQueryTidbVo0> getBlackListData(String queryBlackListSql, String queryUserIdSql, String uuid, String name, String phoneNo, String idNo, String type) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<BlackListQueryTidbVo0> queryListBlackListByPhoneNos = blackListJdbcTemplate.query(queryBlackListSql, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
        log.info("用户黑名单查询结果, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(queryListBlackListByPhoneNos));
        List<Map<String, Object>> queryXyqbUserInfoByPhoneNo = xyqbUserJdbcTemplate.queryForList(queryUserIdSql);
        log.info("用户userId查询结果, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(queryXyqbUserInfoByPhoneNo));

        if (CollectionUtils.isNotEmpty(queryListBlackListByPhoneNos)) {
            List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(queryXyqbUserInfoByPhoneNo)) {

                Map<String, Object> userIdMap = queryXyqbUserInfoByPhoneNo.get(0);
                List<Map<String, Object>> totalOverdueDaysList = xyqbJdbcTemplate.queryForList(String.format(Constant.SQL.XYQB_QUERY_USER_TOTAL_OVERDUE_SQL, userIdMap.get(Constant.PARAM.USER_ID)));
                log.info("用户历史逾期总天数, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(totalOverdueDaysList));
                List<Map<String, Object>> maxOverdueDaysList = xyqbJdbcTemplate.queryForList(String.format(Constant.SQL.XYQB_QUERY_USER_MAX_OVERDUE_SQL, userIdMap.get(Constant.PARAM.USER_ID)));
                log.info("用户最大逾期天数, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(maxOverdueDaysList));

                queryListBlackListByPhoneNos.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0 && o.isStatus()).forEach(blackListQueryTidbVo0 -> {

                    if (CollectionUtils.isNotEmpty(totalOverdueDaysList)) {
                        Object totalOverdueDays = totalOverdueDaysList.get(0).get(Constant.PARAM.TOTAL_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setTotalOverdueDays(Objects.nonNull(totalOverdueDays) ? totalOverdueDays.toString() : null);
                    }
                    if (CollectionUtils.isNotEmpty(maxOverdueDaysList)) {
                        Object maxOverdueDays = maxOverdueDaysList.get(0).get(Constant.PARAM.MAX_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setMaxOverdueDays(Objects.nonNull(maxOverdueDays) ? maxOverdueDays.toString() : null);
                    }

                    blackListQueryTidbVo0s.add(blackListQueryTidbVo0);
                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));

                });
            } else {

                queryListBlackListByPhoneNos.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0 && o.isStatus()).forEach(blackListQueryTidbVo0 -> {

                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0s.add(blackListQueryTidbVo0);

                });

            }

            JdbcExecuters.blackListUpdateBatchExecute(blackListQueryTidbVo0s, Constant.SQL.BLACK_LIST_NEW_UPDATE_FIRST_OR_MAX_OVERDUE_DAYS_SQL, blackListJdbcTemplate, Constant.BATCH_TYPE.BATCH_UPDATE_OVERDUE_DAYS);

        }
        log.info("查询黑名单结束, uuid: {} , name: {} , phoneNo: {} , idNo: {} , type: {} , result: {} , 耗时: {} ", uuid, name, phoneNo, idNo, type, JSON.toJSONString(queryListBlackListByPhoneNos), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return queryListBlackListByPhoneNos;
    }

    @PostConstruct
    public void initChannelBlackListExpireConfig() {
        List<BlackListChannelExpireConfigVo0> queryBlackListChannelExpireConfigVo0List = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_CHANNEL_BLACK_LIST_EXPIRE_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackListChannelExpireConfigVo0.class));
        channelBlackListExpireConfigMap = queryBlackListChannelExpireConfigVo0List.stream().collect(Collectors.toMap(BlackListChannelExpireConfigVo0::getType, BlackListChannelExpireConfigVo0::getExpireTime));
        log.info("加载渠道黑名单有效期配置完成, result: {} ", JSON.toJSONString(channelBlackListExpireConfigMap));
    }

    @Override
    public GlobalResponse queryDateBack(String filePath,String titleNames,String haveTitle, String queryType) {
        log.info("用户black_list_new黑名单比对开始, filePath: {} , titleNames: {} , haveTitle: {} , queryType: {} ", filePath, titleNames, haveTitle, queryType);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<Map<String,String>> paramsList = new ArrayList<Map<String,String>>();
        if(filePath!=null && queryType!=null){
            boolean have = haveTitle!=null && haveTitle.equals("false") ? false:true;//默认有标题
            Map<String, Object> readMap = ReadExcelUtils.readExcel(filePath,titleNames, have);
            List<String> readList = null;
            if(readMap!=null && readMap.get("code").toString().equals("0") && readMap.get("result")!=null) {
                readList = (List<String>) readMap.get("result");
                if(readList==null || readList.size()==0){
                    return GlobalResponse.error("读取文件内容为空！");
                }
            }else{
                return GlobalResponse.error(readMap.get("msg").toString());
            }

            String sql = "";
            List<BlackListQueryTidbVo0> blackList = new ArrayList<BlackListQueryTidbVo0>();
            //queryType:idCard  phoneNo  name
            if(queryType.equals("idCard")){
                StringBuffer querysql = new StringBuffer();
                int beachCount = 0;
                for(String params : readList){
                    beachCount++;
                    String tmp[] = params.split("[|]");
                    String tmpSql = String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_SQL2, tmp[0], tmp[3].substring(0,10)+" 00:00:00");
                    if(beachCount==500){//500条查询一次
                        querysql.append(tmpSql);
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                        beachCount=0;
                        querysql = new StringBuffer();
                    }else{
                        querysql.append(tmpSql.replace(";", " union all "));
                    }
                }
                //最后不够500
                if(querysql!=null && querysql.length()>0){
                    String sql2 = querysql.toString();
                    if(querysql.toString().endsWith("union all") || querysql.toString().endsWith("union all ")){
                        sql2 = sql2.substring(0,sql2.lastIndexOf("union all"));
                    }
                    if(!querysql.toString().endsWith(";")){
                        sql2 = sql2 + ";";
                    }
                    List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                    if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                        blackList.addAll(tmpQueryList);
                    }
                }
            }else if (queryType.equals("mobile")){
                    StringBuffer querysql = new StringBuffer();
                    int beachCount = 0;
                    for(String params : readList){
                        beachCount++;
                        String tmp[] = params.split("[|]");
                        String tmpSql = String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_PHONENO_SQL2, tmp[2], tmp[3].substring(0,10)+" 00:00:00");
                        if(beachCount==500){//500条查询一次
                            querysql.append(tmpSql);
                            List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(querysql.toString(), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                            if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                                blackList.addAll(tmpQueryList);
                            }
                            beachCount=0;
                            querysql = new StringBuffer();
                        }else{
                            querysql.append(tmpSql.replace(";", " union all "));
                        }
                    }
                    //最后不够500
                    if(querysql!=null && querysql.length()>0){
                        String sql_2 = querysql.toString();
                        querysql=null;
                        if(sql_2.toString().endsWith("union all") || sql_2.toString().endsWith("union all ")){
                            sql_2 = sql_2.substring(0,sql_2.lastIndexOf("union all"));
                        }
                        if(!sql_2.toString().endsWith(";")){
                            sql_2 = sql_2 + ";";
                        }
                        List<BlackListQueryTidbVo0> tmpQueryList = blackListJdbcTemplate.query(sql_2, new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                        if (CollectionUtils.isNotEmpty(tmpQueryList)) {
                            blackList.addAll(tmpQueryList);
                        }
                    }
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , queryType: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, queryType, "无效的查询类型[queryType]", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.error("无效的查询类型[queryType]");
            }

            if (CollectionUtils.isNotEmpty(blackList)) {
                blackList.stream().filter(o -> Timestamp.valueOf(
                        LocalDateTime.now().minusYears(channelBlackListExpireConfigMap.get(o.getType())).format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS))
                ).getTime() - o.getCreatedAt().getTime() < 0 && o.isStatus()).forEach(blackListQueryTidbVo0 -> {
                   /* if (CollectionUtils.isNotEmpty(totalOverdueDaysList)) {
                        Object totalOverdueDays = totalOverdueDaysList.get(0).get(Constant.PARAM.TOTAL_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setTotalOverdueDays(Objects.nonNull(totalOverdueDays) ? totalOverdueDays.toString() : null);
                    }
                    if (CollectionUtils.isNotEmpty(maxOverdueDaysList)) {
                        Object maxOverdueDays = maxOverdueDaysList.get(0).get(Constant.PARAM.MAX_OVERDUE_DAYS);
                        blackListQueryTidbVo0.setMaxOverdueDays(Objects.nonNull(maxOverdueDays) ? maxOverdueDays.toString() : null);
                    }
                    blackListQueryTidbVo0s.add(blackListQueryTidbVo0);*/

                    Timestamp updatedAt = new Timestamp(System.currentTimeMillis());
                    String updatedAtStr = updatedAt.toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS));
                    blackListQueryTidbVo0.setBlackUpdatedTime(updatedAtStr);
                    blackListQueryTidbVo0.setUpdatedAt(updatedAt);
                    blackListQueryTidbVo0.setJoinBlackTime(new Timestamp(blackListQueryTidbVo0.getCreatedAt().getTime()).toLocalDateTime().format(DateTimeFormatter.ofPattern(Constant.DAYE_FORMAT.YYYY_MM_DD_HH_MM_SS)));
                });

                StringBuffer tmp = new StringBuffer();
                String[] titilName = {"id", "uuid", "name", "phone_no", "id_no", "major_type", "type", "total_overdue_days", "max_overdue_days", "black_level", "join_black_reason", "status", "created_at", "updated_at"};
                //标题
                for (int i = 0; i < titilName.length; i++) {
                    if (i==0){
                        tmp.append(titilName[i]);
                    }else{
                        tmp.append("\t");
                        tmp.append(titilName[i]);
                    }
                }

                for (BlackListQueryTidbVo0 bean:blackList) {
                    tmp.append("\n");
                    tmp.append(bean.getId());
                    tmp.append("\t"+bean.getUuid());
                    tmp.append("\t"+bean.getName());
                    tmp.append("\t"+bean.getPhoneNo());
                    tmp.append("\t"+bean.getIdNo());
                    tmp.append("\t"+bean.getMajorType());
                    tmp.append("\t"+bean.getType());
                    tmp.append("\t"+(bean.getTotalOverdueDays()!=null ? bean.getTotalOverdueDays(): ""));
                    tmp.append("\t"+(bean.getMaxOverdueDays()!=null ? bean.getMaxOverdueDays(): ""));
                    tmp.append("\t"+bean.getBlackLevel());
                    tmp.append("\t"+bean.getJoinBlackReason());
                    tmp.append("\t"+bean.isStatus());
                    tmp.append("\t"+bean.getJoinBlackTime());
                    tmp.append("\t"+bean.getBlackUpdatedTime());
                }
                String writeFilePath = "";
                if(filePath.lastIndexOf("/")!=-1){//linux
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("/"))+"/"+queryType+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }else{//windows
                    writeFilePath = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\"+queryType+"_"+blackList.size()+"_"+System.currentTimeMillis()+".txt";
                }
                ReadOrWriteTxt.writeTxt(writeFilePath,tmp.toString());
                log.info("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , queryType: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, queryType, ("导出成功，文件位置:"+writeFilePath), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("导出成功，文件位置:"+writeFilePath);
            }else{
                log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , queryType: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, queryType, "查询为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                return GlobalResponse.success("查询为空！");
            }
        }
        log.warn("用户black_list_new黑名单比对结束, filePath: {} , titleNames: {} , haveTitle: {} , queryType: {} , result: {} , 耗时: {} ", filePath, titleNames, haveTitle, queryType, "参数为空", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return GlobalResponse.error("参数为空！");
    }

}
