package cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.*;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: black_grey_list_result表实体 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 20:43 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Data
public class BlackGreyListResult implements Serializable {

    private static final long serialVersionUID = 3504867579864272343L;

    private String rId;
    private String uuid;
    private String name;
    private String phoneNo;
    private String idNo;

    /**phoneNo md5加密*/
    private String phoneNoMd5;
    /**idNo md5加密*/
    private String idNoMd5;

    private String blackType;
    private String types;
    private String reasons;

    @JsonIgnore
    private Timestamp createdAt;
    @JsonIgnore
    private Timestamp updatedAt;

    private Long Id;



    public static Set<String> typesToSet(String oldTypesStr, String newType){
        Set<String> typesSet = null;
        try {
            if(StringUtils.isEmpty(oldTypesStr)) {
                typesSet = new HashSet<>();
            }else{
                String[] array = oldTypesStr.trim().split("[,]");
                typesSet = new HashSet<>(Arrays.asList(array));
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(typesSet==null){
            typesSet = new HashSet<>();
        }
        typesSet.add(newType);
        return typesSet;
    }

    @Deprecated
    public static List<ReasonsVo> reasonsToList_old(String oldJsonStr, String newReason, String newType){
        List<ReasonsVo> reasonList = null;
        try {
            if(StringUtils.isNotEmpty(oldJsonStr)) {
                reasonList = JSONArray.parseArray(oldJsonStr, ReasonsVo.class);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(reasonList==null){
            reasonList = new ArrayList<ReasonsVo>();
        }

        int size = reasonList.size();
        if(size>=2){
            ReasonsVo back1 = reasonList.get(0);
            for(int i=1; i < size; i++){
                ReasonsVo tmp2 = reasonList.get(i);
                if(back1.getUtcTime() <= tmp2.getUtcTime()){
                    back1 = tmp2;
                }
            }
            reasonList = new ArrayList<ReasonsVo>();
            reasonList.add(back1);
        }

        ReasonsVo newObj = new ReasonsVo();
        newObj.setReason(newReason);
        newObj.setType(newType);
        newObj.setUtcTime(System.currentTimeMillis());
        reasonList.add(newObj);
        return reasonList;
    }

    //在历史reason的json基础上追加
    public static List<ReasonsVo> reasonsToList(String oldJsonStr, String newReasonCode, String newType){
        List<ReasonsVo> reasonList = null;
        try {
            if(StringUtils.isNotEmpty(oldJsonStr)) {
                reasonList = JSONArray.parseArray(oldJsonStr, ReasonsVo.class);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(reasonList==null){
            reasonList = new ArrayList<ReasonsVo>();
        }

        //`reasons` varchar(1024) 最多保存18条ReasonsVo，不能无限追加，大于18条的丢弃掉历史最老的
        int maxLeng = 18;
        int size = reasonList.size();
        if(size >= maxLeng){
            //把ReasonsVo按照时间从小到大排列
            Collections.sort(reasonList, new Comparator<ReasonsVo>() {
                @Override
                public int compare(ReasonsVo v1, ReasonsVo v2) {
                    if (v1.getUtcTime() > v2.getUtcTime()) {
                        return 1;
                    }
                    if (v1.getUtcTime() == v2.getUtcTime()) {
                        return 0;
                    }
                    return -1;
                }
            });

            //取时间最近的maxLeng-1条
            List<ReasonsVo> tmpList = new ArrayList<ReasonsVo>();
            for(int i=0; i < maxLeng-1; i++){
                tmpList.add(reasonList.get(size-1-i));
            }
            reasonList = tmpList;
        }

        ReasonsVo newObj = new ReasonsVo();
        newObj.setReason(newReasonCode);
        newObj.setType(newType);
        newObj.setUtcTime(System.currentTimeMillis());
        reasonList.add(newObj);
        return reasonList;
    }


   /* public static void main(String[] args) {
        String oldJsonStr = "[{\"reason\":\"G_001\",\"type\":\"1\",\"utcTime\":1570550400000},{\"reason\":\"G_001\",\"type\":\"2\",\"utcTime\":1587128783310},{\"reason\":\"G_001\",\"type\":\"10\",\"utcTime\":1587128790628}]";
        List<ReasonsVo> reasonsToList = BlackGreyListResult.reasonsToList(oldJsonStr, "G_999", "99");

        System.out.println(JSON.toJSONString(reasonsToList));
    }*/



}
