package cn.quantgroup.qgblservice.utils.blacklist;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author fengjunkai
 * @Date 2019-08-19 17:41
 */
public class BlackListUtils {

    private static Pattern p_chinese = Pattern.compile("[\u4e00-\u9fa5]");//中文

    private static Pattern p_phone = Pattern.compile("^((13[0-9])|(15[^4])|(18[0,2,3,5-9])|(17[0-8])|(147))\\d{8}$");


    public static void getOrUpdateBlackListLevel(BlackListQueryTidbVo0 blackListQueryTidbVo0, String type) {
        LocalDateTime localDateTimeCreatedAt = blackListQueryTidbVo0.getCreatedAt().toLocalDateTime();
        LocalDateTime localDateTimeNow = LocalDateTime.now();

        long time12 = Timestamp.valueOf(localDateTimeCreatedAt.plusMonths(12)).getTime();
        long time24 = Timestamp.valueOf(localDateTimeCreatedAt.plusMonths(24)).getTime();
        long timeNow = Timestamp.valueOf(localDateTimeNow).getTime();

        if (time12 - timeNow < 0 && time24 - timeNow > 0) {
            blackListQueryTidbVo0.setBlackLevel(type.equals(Constant.PARAM.BLACK_LIST_THIRD_PART) ? Constant.PARAM.BLACK_LIST_LEVEL_D2 : Constant.PARAM.BLACK_LIST_LEVEL_A2);
        } else if (time24 - timeNow < 0) {
            blackListQueryTidbVo0.setBlackLevel(type.equals(Constant.PARAM.BLACK_LIST_THIRD_PART) ? Constant.PARAM.BLACK_LIST_LEVEL_D3 : Constant.PARAM.BLACK_LIST_LEVEL_A3);
        }

    }

    public static boolean isContainChinese(String str) {
        Matcher m = p_chinese.matcher(str);
        if (m.find()) {
            return true;
        }
        return false;
    }

    public static boolean isIDNumber(String IDNumber) {
        if (IDNumber == null || "".equals(IDNumber)) {
            return false;
        }

        // 定义判别用户身份证号的正则表达式（15位或者18位，最后一位可以为字母）
        String regularExpression = "(^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|" +
                "(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)";
        boolean matches = IDNumber.matches(regularExpression);
        //判断第18位校验值
        if (matches) {
            if (IDNumber.length() == 18) {
                try {
                    char[] charArray = IDNumber.toCharArray();
                    //前十七位加权因子
                    int[] idCardWi = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
                    //这是除以11后，可能产生的11位余数对应的验证码
                    String[] idCardY = {"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
                    int sum = 0;
                    for (int i = 0; i < idCardWi.length; i++) {
                        int current = Integer.parseInt(String.valueOf(charArray[i]));
                        int count = current * idCardWi[i];
                        sum += count;
                    }
                    char idCardLast = charArray[17];
                    int idCardMod = sum % 11;
                    if (idCardY[idCardMod].toUpperCase().equals(String.valueOf(idCardLast).toUpperCase())) {
                        return true;
                    } else {
                        return false;
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

        }
        return matches;
    }

    /**
     * 大陆手机号码11位数，匹配格式：前三位固定格式+后8位任意数
     * 此方法中前三位格式有：
     * 13+任意数
     * 15+除4的任意数
     * 18+除1和4的任意数
     * 17+除9的任意数
     * 147
     */
    public static boolean isChinaPhone(String str) {
        Matcher m = p_phone.matcher(str);
        return m.matches();
    }

}
