package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListQueryManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author fengjunkai
 * @Date 2019-08-13 18:23
 */
@RestController
@RequestMapping("/black_list")
public class BlackListQueryManagerController {

    @Autowired
    private IBlackListQueryManagerService iBlackListQueryManagerService;

    @RequestMapping("/query")
    public GlobalResponse queryBlackList(String uuid, String name, String phoneNo, String idCard, String type){
        return iBlackListQueryManagerService.queryBlackList(uuid, name, phoneNo, idCard, type);
    }

    /**
     * @描述
     * @参数  [filePath：原文件地址； titleNames：表格的头部标题，已逗号分隔； haveTitle：是否有标题列，默认true； queryType：查询类别，目前可以传idCard或phoneNo，name暂不支持]
     * @返回值  cn.quantgroup.qgblservice.response.GlobalResponse
     * @创建人  yanhui.Hao
     * @创建时间  2019.09.10
     */
    @RequestMapping("/queryDateBack")
    public GlobalResponse queryDateBack(String filePath,String titleNames, String haveTitle, String queryType){
        return iBlackListQueryManagerService.queryDateBack(filePath,titleNames,haveTitle,queryType);
    }

}
