package cn.quantgroup.qgblservice.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;

/**
 * @Author fengjunkai
 * @Date 2019-08-07 18:40
 */
public class CommonBeanUtils {

    private static final Logger logger = LoggerFactory.getLogger(CommonBeanUtils.class);

    @SuppressWarnings("unchecked")
    public static <T> T rsToBean(T entity, ResultSet rs){
        T target =null;
        try {
            Class<T> tclass = (Class<T>) entity.getClass();
            target = tclass.newInstance();
            Field[] fields = tclass.getDeclaredFields();

            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();

            for(int i=0;i<columnCount;i++){
                String columnName = metaData.getColumnName(i+1);
                String columnNameT = columnName.replaceAll("_", "").toLowerCase();
                for(Field field:fields){
                    //设置可访问私有变量。
                    field.setAccessible(true);
                    Type fieldType= field.getGenericType();
                    String fieldTypeStr=fieldType.toString();
                    String fileNameT = field.getName().replaceAll("_", "").toLowerCase();
                    if(fieldTypeStr.equals("class java.lang.String") && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getString(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Integer") ||fieldTypeStr.equals("int")) && columnNameT.equals(fileNameT)){
                        int num = rs.getInt(columnName);
                        if(num!=0){
                            field.set(target,rs.getInt(columnName));
                        }else{
                            field.set(target,rs.getObject(columnName));
                        }
                        break;
                    }else if(fieldTypeStr.equals("class java.util.Date") && columnNameT.equals(fileNameT)){
                        field.set(target,DateUtil.parse(rs.getString(columnName)));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Boolean") || fieldTypeStr.equals("boolean"))&& columnNameT.equals(fileNameT)){
                        field.set(target,rs.getBoolean(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Double")||fieldTypeStr.equals("double")) && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getDouble(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Short")||fieldTypeStr.equals("short")) && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getShort(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Long")||fieldTypeStr.equals("long")) && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getLong(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.math.BigDecimal")) && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getBigDecimal(columnName));
                        break;
                    }else if((fieldTypeStr.equals("class java.lang.Float")||fieldTypeStr.equals("float")) && columnNameT.equals(fileNameT)){
                        field.set(target,rs.getFloat(columnName));
                        break;
                    }
                }
            }
        } catch (Exception e) {
            logger.error("rs cast to bean exception",e);
        }
        return target;
    }
    /**
     * request2Bean
     * @param request
     * @return
     */
    public static <T> T  request2Bean(HttpServletRequest request, T t){
        try {
            @SuppressWarnings("unchecked")
            Class<T> tclass = (Class<T>) t.getClass();
            Field[] fields = tclass.getDeclaredFields();
            for (Field field : fields) {
                String param = request.getParameter(field.getName());
                if(StringUtils.isNotEmpty(param)){
                    //设置可访问私有变量。
                    field.setAccessible(true);
                    field.set(t,param.replaceAll(" ","").replaceAll(" ", ""));
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return t;
    }
    /**
     * request2Bean
     * @param request
     * @return
     */
    public static <T> T  request2BeanNew(HttpServletRequest request,T t){
        try {
            @SuppressWarnings("unchecked")
            Class<T> tclass = (Class<T>) t.getClass();
            Field[] fields = tclass.getDeclaredFields();
            for (Field field : fields) {
                String param = request.getParameter(field.getName());
                if(StringUtils.isNotEmpty(param)){
                    //设置可访问私有变量。
                    field.setAccessible(true);
                    field.set(t,param);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    /**
     * bean转map
     * @param o
     * @return
     */
    @SuppressWarnings("unchecked")
    public static Map<String,Object> beanToMap(Object o){
        Map<String,Object> map=null;
        try{
            if(o!=null){
                String jsonString = JSON.toJSONString(o);
                map = JSON.parseObject(jsonString, Map.class);
            }else{
                throw new NullPointerException("bean to map NullPointerException: bean is null");
            }
        }catch(Exception e){
            logger.error("bean cast to map exception",e);
        }
        return map;
    }

    /**
     * bean转map
     * @param o
     * @return
     */
    @SuppressWarnings("unchecked")
    public static Map<String,Object> beanToMapByDateFormat(Object o){
        Map<String,Object> map=null;
        if(o!=null){
            String jsonString = JSON.toJSONString(o, SerializerFeature.WriteDateUseDateFormat);
            map = JSON.parseObject(jsonString, Map.class);
        }else{
            throw new NullPointerException("bean to map NullPointerException: bean is null");
        }
        return map;
    }
    @SuppressWarnings("unchecked")
    public static Map<Object,Object> beanToSaveDBMap(Object o){
        Map<Object,Object> map=null;
        if(o!=null){
            String jsonString = JSONObject.toJSONString(o,SerializerFeature.WriteDateUseDateFormat,SerializerFeature.WriteNullNumberAsZero,SerializerFeature.WriteNullStringAsEmpty,SerializerFeature.WriteMapNullValue);
            map = JSON.parseObject(jsonString, Map.class);
        }else{
            throw new NullPointerException("bean to map NullPointerException: bean is null");
        }
        return map;
    }


    public static boolean isAllFieldNull(Object obj) throws Exception{
        Class stuCla = (Class) obj.getClass();// 得到类对象
        Field[] fs = stuCla.getDeclaredFields();//得到属性集合
        boolean flag = true;
        for (Field f : fs) {//遍历属性
            f.setAccessible(true); // 设置属性是可以访问的(私有的也可以)
            Object val = f.get(obj);// 得到此属性的值
            String name = f.getName();
            if(StringUtils.isNotEmpty(name) && "serialVersionUID".equalsIgnoreCase(name)){
                continue;
            }
            if(val!=null) {//只要有1个属性不为空,那么就不是所有的属性值都为空
                flag = false;
                break;
            }
        }
        return flag;
    }

}
