package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.model.blacklist.ThirdPartBlackListConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListUpdateThreeEleService;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import cn.quantgroup.qgblservice.utils.blacklist.BlackListUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 三方数据源黑名单管理保存
 *
 * @Author fengjunkai
 * @Date 2019-08-12 17:25
 */
@Slf4j
@Service
public class ThirdPartBlackListServiceImpl implements IThirdPartBlackListManagerService {

    @Autowired
    private JdbcTemplate blackListJdbcTemplate;
    @Autowired
    private IBlackListUpdateThreeEleService iBlackListUpdateThreeEleService;

    private static Map<String, String> thirdPartBlackListCacheConfigMap = new ConcurrentHashMap<>();
    private static Map<String, String> thirdPartBlackListMap = new ConcurrentHashMap<>();

    @Override
    public GlobalResponse saveThirdPartBlackList(String uuid, String name, String phoneNo, String idCard, String type) {

        try {
            List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UNIQUE_KEY_SQL,
                    phoneNo, name, idCard, thirdPartBlackListCacheConfigMap.get(type)), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));

            if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {

                for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

                    BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                    blackListQueryTidbVo0.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                    BlackListUtils.getOrUpdateBlackListLevel(blackListQueryTidbVo0, Constant.PARAM.BLACK_LIST_THIRD_PART);
                    blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_BLACK_LIST_LEVEL_SQL,  blackListQueryTidbVo0.getBlackLevel(), blackListQueryTidbVo0.getId()));

                }
                iBlackListUpdateThreeEleService.updateOrNoThreeElementsById(blackListQueryTidbVo0s, Constant.PARAM.BLACK_LIST_THIRD_PART);
            } else {
                saveThirdPartBlackListJdbc(uuid, name, phoneNo, idCard, type);
            }

            return GlobalResponse.success("保存成功");

        } catch (Exception e) {
            log.error("保存三方数据源黑名单异常, uuid: {} , name: {} , phoneNo: {} , idCard: {} ", uuid, name, phoneNo, idCard, e);
        }

        return GlobalResponse.error("保存异常");

    }


    public void saveThirdPartBlackListJdbc(String uuid, String name, String phoneNo, String idCard, String type) {

        Object param[] = new Object[10];
        param[0] = uuid;
        param[1] = name;
        param[2] = phoneNo;
        param[3] = idCard;
        param[4] = Constant.PARAM.BLACK_LIST_MAJAOR;
        param[5] = thirdPartBlackListCacheConfigMap.get(type);
        param[6] = Constant.PARAM.BLACK_LIST_LEVEL_D1;
        param[7] = thirdPartBlackListMap.get(type);
        param[8] = new Timestamp(System.currentTimeMillis());
        param[9] = new Timestamp(System.currentTimeMillis());
        blackListJdbcTemplate.update(Constant.SQL.BLACK_LIST_NEW_INSERT_THIRD_PART_BLACK_LIST_SQL, param);

    }

    @PostConstruct
    public void initThirdPartBlackListConfig() {

        List<ThirdPartBlackListConfigVo0> thirdPartBlackListConfigVo0s = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_THIRD_PART_BLACK_LIST_CONFIG_SQL, new BeanPropertyRowMapper<>(ThirdPartBlackListConfigVo0.class));
        thirdPartBlackListCacheConfigMap = thirdPartBlackListConfigVo0s.stream().collect(Collectors.toMap(ThirdPartBlackListConfigVo0::getChannelType, ThirdPartBlackListConfigVo0::getType));
        thirdPartBlackListMap = thirdPartBlackListConfigVo0s.stream().collect(Collectors.toMap(ThirdPartBlackListConfigVo0::getChannelType, ThirdPartBlackListConfigVo0::getName));

        log.info("加载三方数据源黑名单配置完成, result: {} ", JSON.toJSONString(thirdPartBlackListCacheConfigMap));

    }

}
