package cn.quantgroup.qgblservice.config.tidb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * @Author fengjunkai
 * @Date 2019-08-01 15:18
 */
@Import(TidbDataSourceProperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = TidbDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "tidbSqlSessionFactory")
public class TidbDataSourceConfig {


    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb";

    @Value("${tidb.mapper-locations}")
    private String mapperLocations;
    @Value("${tidb.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${tidb.config-location}")
    private String configLocation;

//    @Autowired
//    private TidbDataSourceProperties tidbDataSourceProperties;

//    @Bean(name = "tidbDataSource")
//    public DataSource tidbDataSource() {
//        HikariConfig config = new HikariConfig();
//        config.setJdbcUrl(tidbDataSourceProperties.getJdbcUrl());
//        log.info("TIDB数据库地址:{}", tidbDataSourceProperties.getJdbcUrl());
//        config.setPassword(tidbDataSourceProperties.getPassword());
//        config.setUsername(tidbDataSourceProperties.getUsername());
//        config.setMaximumPoolSize(tidbDataSourceProperties.getMaxPoolSize());
//        config.setMinimumIdle(tidbDataSourceProperties.getMinPoolSize());
//        config.addDataSourceProperty("cachePrepStmts", "true");
//        config.addDataSourceProperty("prepStmtCacheSize", "250");
//        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
//        return new HikariDataSource(config);
//    }

//    @Bean(name = "tidbSqlSessionFactory")
//    public SqlSessionFactory tidbSqlSessionFactory(@Qualifier("tidbDataSource") DataSource tidbDataSource) throws Exception {
//        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
//        sessionFactory.setDataSource(tidbDataSource);
//        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
//                .getResources(mapperLocations));
//        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
//        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
//                .getResource(configLocation));
//        return sessionFactory.getObject();
//    }
//
//    @Bean(name = "tidbSqlSessionTemplate")
//    public SqlSessionTemplate tidbSqlSessionTemplate(@Qualifier("tidbSqlSessionFactory") SqlSessionFactory tidbSqlSessionFactory) throws Exception {
//        return new SqlSessionTemplate(tidbSqlSessionFactory, ExecutorType.BATCH);
//    }

}
