package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.service.IBlackListUpdateThreeEleService;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.blacklist.BlackListUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.List;

/**
 * @Author fengjunkai
 * @Date 2019-08-19 17:45
 */
@Slf4j
@Service
public class BlackListUpdateThreeEleServiceImpl implements IBlackListUpdateThreeEleService {

    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    @Async
    @Override
    public void updateOrNoThreeElementsById(List<BlackListQueryTidbVo0> blackListQueryTidbVo0s, String type) {

        for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

            try{
                BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                List<BlackListQueryTidbVo0> query = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_IDNO_OR_PHONENO_SQL, blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getIdNo()), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));

                for (int j = 0; j < query.size(); j++) {

                    BlackListQueryTidbVo0 blackListQueryTidbVo01 = query.get(j);
                    if (StringUtils.isAnyBlank(blackListQueryTidbVo01.getUuid(), blackListQueryTidbVo01.getName(), blackListQueryTidbVo01.getPhoneNo(), blackListQueryTidbVo01.getIdNo(),blackListQueryTidbVo01.getPhoneNoMd5(),blackListQueryTidbVo01.getIdNoMd5())
                            && blackListQueryTidbVo01.isStatus()) {

                        if (StringUtils.isBlank(blackListQueryTidbVo01.getUuid()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())) {
                            blackListQueryTidbVo01.setUuid(blackListQueryTidbVo0.getUuid());
                        }

                        if (StringUtils.isBlank(blackListQueryTidbVo01.getName()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())) {
                            blackListQueryTidbVo01.setName(blackListQueryTidbVo0.getName());
                        }

                        if (StringUtils.isBlank(blackListQueryTidbVo01.getPhoneNo()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())) {
                            blackListQueryTidbVo01.setPhoneNo(blackListQueryTidbVo0.getPhoneNo());
                        }

                        if (StringUtils.isBlank(blackListQueryTidbVo01.getIdNo()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())) {
                            blackListQueryTidbVo01.setIdNo(blackListQueryTidbVo0.getIdNo());
                        }

                        //modify 2019.09.20 增加phone_no_md5、id_no_md5
                        String idCard_md5 = null,phoneNo_md5=null;
                        if(StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())){
                            idCard_md5 = MD5Util.getMD5Digest(blackListQueryTidbVo0.getIdNo());
                        }
                        if(StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())){
                            phoneNo_md5 = MD5Util.getMD5Digest(blackListQueryTidbVo0.getPhoneNo());
                        }
                        //如果为空，则赋值
                        if(StringUtils.isBlank(blackListQueryTidbVo01.getIdNoMd5()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())){
                            blackListQueryTidbVo01.setIdNoMd5(idCard_md5);
                        }
                        if(StringUtils.isBlank(blackListQueryTidbVo01.getPhoneNoMd5()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getPhoneNo())){
                            blackListQueryTidbVo01.setPhoneNoMd5(phoneNo_md5);
                        }


                        try{
                            //List<BlackListQueryTidbVo0> blackListQueryTidbVo0sByUniqueKey = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UNIQUE_KEY_SQL, blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo01.getType()), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));

                            List<BlackListQueryTidbVo0> blackListQueryTidbVo0sByUniqueKey = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UNIQUE_KEY_SQL2_MD5, blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo01.getType(),
                                    phoneNo_md5,idCard_md5), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));
                            if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0sByUniqueKey)) {
                                blackListQueryTidbVo01.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                                blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_DISABLE_BY_RECORD_ID_SQL, blackListQueryTidbVo01.getUpdatedAt(), blackListQueryTidbVo01.getId()));
                            } else {
                                BlackListUtils.getOrUpdateBlackListLevel(blackListQueryTidbVo01, type);
                                blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_THREE_ELE_AND_BLACK_LEVEL_SQL, blackListQueryTidbVo0.getUuid(), blackListQueryTidbVo0.getName(), blackListQueryTidbVo0.getPhoneNo(), blackListQueryTidbVo0.getIdNo(), blackListQueryTidbVo01.getBlackLevel(), phoneNo_md5,idCard_md5,  blackListQueryTidbVo01.getId()));
                            }
                        }catch(Exception e){
                            log.error("更新单条黑名单三要素异常, uploadData: {} , queryData: {} ", JSON.toJSONString(blackListQueryTidbVo01), JSON.toJSONString(blackListQueryTidbVo0), e);
                        }
                    }

                }
            }catch(Exception e){
                log.error("更新黑名单三要素异常{} ", type, e);
            }

        }

    }

}
